/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDocumentFactory {
    private static String[] properties = new String[]{"method", "version", "encoding", "omit-xml-declaration", "standalone", "doctype-public", "doctype-system", "indent", "media-type"};
    private static int METHOD = 0;
    private static int VERSION = 1;
    private static int ENCODING = 2;
    private static int OMIT_XML_DECLARATION = 3;
    private static int STANDALONE = 4;
    private static int DOCTYPE_PUBLIC = 5;
    private static int DOCTYPE_SYSTEM = 6;
    private static int CDATA_SECTION_ELEMENTS = 7;
    private static int INDENT = 8;
    private static int MEDIA_TYPE = 9;
    private String fileName;

    public XMLDocumentFactory() {
    }

    public XMLDocumentFactory(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static Document parse(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new UtilErrorHandler());
            Document document = documentBuilder.parse(string);
            return document;
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return null;
    }

    public Document parse() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new UtilErrorHandler());
            Document document = documentBuilder.parse(this.fileName);
            return document;
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return null;
    }

    public static void serialize(Node node, String string, Properties properties) {
        Object object;
        String string2 = "<?xml version=\"1.0\"?>";
        File file = new File(string);
        if (properties != null) {
            string2 = "<?xml";
            object = "";
            for (int i = 0; i < XMLDocumentFactory.properties.length; ++i) {
                object = (String)properties.get(XMLDocumentFactory.properties[i]);
                if (object == null) continue;
                string2 = string2 + " " + XMLDocumentFactory.properties[i] + "=\"" + (String)object + "\"";
            }
            string2 = string2 + "?>";
        }
        try {
            object = new FileOutputStream(file);
            string2 = string2 + node.toString();
            ((FileOutputStream)object).write(string2.getBytes());
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            System.err.println("Error serializing file");
        }
    }

    public void serialize(Node node) {
        File file = new File(this.fileName);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(node.toString().getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error serializing file");
        }
    }

    static class UtilErrorHandler
    implements ErrorHandler {
        UtilErrorHandler() {
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw new SAXException(sAXParseException);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Validation : Warning] URI = " + sAXParseException.getMessage());
        }
    }
}

