/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.xml;

import org.enhydra.xml.CommentImpl;
import org.enhydra.xml.ElementImpl;
import org.enhydra.xml.Indent;
import org.enhydra.xml.NodeDOMException;
import org.enhydra.xml.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeImpl
implements Node,
NodeList {
    protected Document ownerDocument;
    protected String nodeName = null;
    protected String nodeValue = null;
    protected short type = 1;
    protected NodeImpl parent = null;
    protected int numChildren = 0;
    protected NodeImpl firstChild = null;
    protected NodeImpl lastChild = null;
    protected NodeImpl nextSibling = null;
    protected NodeImpl previousSibling = null;

    public NodeImpl() {
    }

    public NodeImpl(NodeImpl nodeImpl) {
        this.ownerDocument = nodeImpl.ownerDocument;
        this.nodeName = nodeImpl.nodeName;
        this.nodeValue = nodeImpl.nodeValue;
        this.type = nodeImpl.type;
        this.parent = nodeImpl.parent;
        this.numChildren = nodeImpl.numChildren;
        this.firstChild = nodeImpl.firstChild;
        this.lastChild = nodeImpl.lastChild;
        this.nextSibling = nodeImpl.nextSibling;
        this.previousSibling = nodeImpl.previousSibling;
    }

    public NodeImpl(Node node) {
        this(node, true);
    }

    public NodeImpl(Node node, boolean bl) {
        this.ownerDocument = node.getOwnerDocument();
        this.nodeName = node.getNodeName();
        this.type = node.getNodeType();
        this.nodeValue = node.getNodeValue();
        if (bl) {
            this.initNodeImplChildren(node);
        }
    }

    public NodeImpl(Document document, String string) {
        this.ownerDocument = document;
        this.nodeName = this.nodeName;
    }

    public NodeImpl(Document document, String string, short s) {
        this.ownerDocument = document;
        this.nodeName = string;
        this.type = s;
    }

    public NodeImpl(Document document, String string, short s, String string2) {
        this.ownerDocument = document;
        this.nodeName = string;
        this.type = s;
        this.nodeValue = string2;
    }

    protected void initNodeImplChildren(Node node) {
        block5: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            switch (node2.getNodeType()) {
                case 1: {
                    this.appendChild(this.newElementInstance(node2));
                    continue block5;
                }
                case 3: {
                    this.appendChild(this.newTextInstance(node2));
                    continue block5;
                }
                case 8: {
                    this.appendChild(this.newCommentInstance(node2));
                    continue block5;
                }
                default: {
                    this.appendChild(this.newDefaultInstance(node2));
                }
            }
        }
    }

    protected Node newElementInstance(Node node) {
        return new ElementImpl(node);
    }

    protected Node newTextInstance(Node node) {
        return new TextImpl(node);
    }

    protected Node newCommentInstance(Node node) {
        return new CommentImpl(node);
    }

    protected Node newDefaultInstance(Node node) {
        return new NodeImpl(node);
    }

    private void checkNode(Node node) throws DOMException {
        if (node == null) {
            return;
        }
        if (!(node instanceof NodeImpl)) {
            throw new NodeDOMException(4, "Node not an NodeImpl!");
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public void setNodeValue(String string) {
        this.nodeValue = string;
    }

    public short getNodeType() {
        return this.type;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return this.firstChild;
    }

    public Node getLastChild() {
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public Node getNextSibling() {
        return this.nextSibling;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    public Node insertBefore(Node node, Node node2) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(node);
        this.checkNode(node2);
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl nodeImpl2 = (NodeImpl)node2;
        NodeImpl nodeImpl3 = null;
        NodeImpl nodeImpl4 = null;
        if (node2 == null) {
            nodeImpl3 = this.lastChild;
            nodeImpl4 = null;
            this.lastChild = nodeImpl;
        } else {
            nodeImpl3 = nodeImpl2.previousSibling;
            nodeImpl4 = nodeImpl2;
        }
        if (nodeImpl3 != null) {
            nodeImpl3.nextSibling = nodeImpl;
        }
        if (nodeImpl4 != null) {
            nodeImpl4.previousSibling = nodeImpl;
        }
        nodeImpl.parent = this;
        nodeImpl.previousSibling = nodeImpl3;
        nodeImpl.nextSibling = nodeImpl4;
        if (this.firstChild == nodeImpl2) {
            this.firstChild = nodeImpl;
        }
        ++this.numChildren;
        return nodeImpl;
    }

    public Node replaceChild(Node node, Node node2) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(node);
        this.checkNode(node2);
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl nodeImpl2 = (NodeImpl)node2;
        NodeImpl nodeImpl3 = nodeImpl2.previousSibling;
        NodeImpl nodeImpl4 = nodeImpl2.nextSibling;
        if (nodeImpl3 != null) {
            nodeImpl3.nextSibling = nodeImpl;
        }
        if (nodeImpl4 != null) {
            nodeImpl4.previousSibling = nodeImpl;
        }
        nodeImpl.parent = this;
        nodeImpl.previousSibling = nodeImpl3;
        nodeImpl.nextSibling = nodeImpl4;
        if (this.firstChild == nodeImpl2) {
            this.firstChild = nodeImpl;
        }
        if (this.lastChild == nodeImpl2) {
            this.lastChild = nodeImpl;
        }
        nodeImpl2.parent = null;
        nodeImpl2.previousSibling = null;
        nodeImpl2.nextSibling = null;
        return nodeImpl2;
    }

    public Node removeChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("oldChild == null!");
        }
        this.checkNode(node);
        NodeImpl nodeImpl = (NodeImpl)node;
        NodeImpl nodeImpl2 = nodeImpl.previousSibling;
        NodeImpl nodeImpl3 = nodeImpl.nextSibling;
        if (nodeImpl2 != null) {
            nodeImpl2.nextSibling = nodeImpl3;
        }
        if (nodeImpl3 != null) {
            nodeImpl3.previousSibling = nodeImpl2;
        }
        if (this.firstChild == nodeImpl) {
            this.firstChild = nodeImpl3;
        }
        if (this.lastChild == nodeImpl) {
            this.lastChild = nodeImpl2;
        }
        nodeImpl.parent = null;
        nodeImpl.previousSibling = null;
        nodeImpl.nextSibling = null;
        --this.numChildren;
        return nodeImpl;
    }

    public Node appendChild(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(node);
        return this.insertBefore(node, null);
    }

    public boolean hasChildNodes() {
        return this.numChildren > 0;
    }

    public Node cloneNode(boolean bl) {
        return new NodeImpl(this, bl);
    }

    public void normalize() {
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() throws DOMException {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public void setPrefix(String string) {
    }

    public String getLocalName() {
        return this.nodeName;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public int getLength() {
        return this.numChildren;
    }

    public Node item(int n) {
        Node node;
        if (n < 0) {
            return null;
        }
        for (node = this.getFirstChild(); node != null && n-- > 0; node = node.getNextSibling()) {
        }
        return node;
    }

    public String toString() {
        return this.toString(Indent.DEFAULT_TAB);
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.allToString(stringBuffer, new Indent(0, string));
        return stringBuffer.toString();
    }

    protected void beginToString(StringBuffer stringBuffer, Indent indent) {
    }

    protected void endToString(StringBuffer stringBuffer, Indent indent) {
    }

    private void allToString(StringBuffer stringBuffer, Indent indent) {
        this.beginToString(stringBuffer, indent);
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ((NodeImpl)node).allToString(stringBuffer, indent);
        }
        this.endToString(stringBuffer, indent);
    }
}

