/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.enhydra.xml.AttrImpl;
import org.enhydra.xml.HashMapNamedNodeMap;
import org.enhydra.xml.Indent;
import org.enhydra.xml.NodeDOMException;
import org.enhydra.xml.NodeImpl;
import org.enhydra.xml.NodeListImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementImpl
extends NodeImpl
implements Element {
    protected HashMap attributes = null;

    public ElementImpl() {
        this.attributes = new HashMap();
        this.type = 1;
    }

    public ElementImpl(ElementImpl elementImpl) {
        super(elementImpl);
        this.attributes = elementImpl.attributes;
        this.type = 1;
    }

    public ElementImpl(Document document, String string) {
        super(document, string, (short)1);
        this.attributes = new HashMap();
    }

    protected ElementImpl(Document document, String string, short s, String string2) {
        super(document, string, s, string2);
    }

    public ElementImpl(Node node) {
        this(node, true);
    }

    public ElementImpl(Node node, boolean bl) {
        super(node, false);
        this.attributes = new HashMap();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                AttrImpl attrImpl = new AttrImpl((Attr)namedNodeMap.item(i));
                this.attributes.put(attrImpl.getName(), attrImpl);
            }
        }
        if (bl) {
            this.initNodeImplChildren(node);
        }
    }

    public static Element newInstance(Document document) {
        Element element = document.getDocumentElement();
        return new ElementImpl(element);
    }

    public Node insertBefore(Node node, Node node2) {
        super.insertBefore(node, node2);
        return node;
    }

    public Node replaceChild(Node node, Node node2) {
        super.replaceChild(node, node2);
        return node2;
    }

    public Node removeChild(Node node) {
        super.removeChild(node);
        return node;
    }

    public Node cloneNode(boolean bl) {
        return new ElementImpl(this, bl);
    }

    public String getTagName() {
        return this.nodeName;
    }

    public NamedNodeMap getAttributes() {
        return new HashMapNamedNodeMap(this.attributes);
    }

    public String getAttribute(String string) {
        Attr attr = this.getAttributeNode(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public String getAttributeNS(String string, String string2) {
        return this.getAttribute(string2);
    }

    public void setAttribute(String string, String string2) {
        this.attributes.put(string, new AttrImpl(this, string, string2));
    }

    public void setAttributeNS(String string, String string2, String string3) {
        this.setAttribute(string2, string3);
    }

    public void removeAttribute(String string) {
        if (this.type != 1) {
            throw new NodeDOMException(9, "Node doesn't have attributes");
        }
        this.removeAttribute(string, true);
    }

    private void removeAttribute(String string, boolean bl) {
        if (this.attributes.remove(string) != null) {
            return;
        }
        if (bl) {
            throw new NodeDOMException(8, "No such attribute!");
        }
    }

    public boolean hasAttributes() {
        return this.attributes.size() > 0;
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public void removeAttributeNS(String string, String string2) {
        this.removeAttribute(string2);
    }

    public Attr getAttributeNode(String string) {
        return (Attr)this.attributes.get(string);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return this.getAttributeNode(string2);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        AttrImpl attrImpl = attr instanceof AttrImpl ? (AttrImpl)attr : new AttrImpl(attr);
        this.attributes.put(attrImpl.getName(), attrImpl);
        return attrImpl;
    }

    public Attr setAttributeNodeNS(Attr attr) {
        return this.setAttributeNode(attr);
    }

    public Attr removeAttributeNode(Attr attr) {
        this.removeAttribute(attr.getName());
        return attr;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.hasAttribute(string2);
    }

    public NodeList getElementsByTagName(String string) {
        ArrayList arrayList = new ArrayList();
        this.getElementsByTagName(string, arrayList);
        return new NodeListImpl(arrayList);
    }

    private void getElementsByTagName(String string, List list) {
        if (this.nodeName.equals(string)) {
            list.add(this);
        }
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            ((ElementImpl)node).getElementsByTagName(string, list);
        }
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return this.getElementsByTagName(string2);
    }

    public boolean hasElementChildNodes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    protected void beginToString(StringBuffer stringBuffer, Indent indent) {
        stringBuffer.append("\n" + indent + "<" + this.nodeName);
        Iterator iterator = this.attributes.values().iterator();
        while (iterator.hasNext()) {
            Attr attr = (Attr)iterator.next();
            stringBuffer.append(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
        }
        stringBuffer.append(">");
        indent.increment();
    }

    protected void endToString(StringBuffer stringBuffer, Indent indent) {
        indent.decrement();
        if (this.hasElementChildNodes()) {
            stringBuffer.append("\n" + indent + "</" + this.nodeName + ">");
        } else {
            stringBuffer.append("</" + this.nodeName + ">");
        }
    }
}

