/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.util;

import com.lutris.util.KeywordParser;
import com.lutris.util.KeywordValueException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class KeywordValueTable
implements Serializable {
    private Hashtable hashTable = new Hashtable();

    private synchronized KeywordValueTable findSection(String[] stringArray, boolean bl, int n) throws KeywordValueException {
        if (n == stringArray.length - 1) {
            return this;
        }
        Object object = this.hashTable.get(stringArray[n]);
        if (object != null) {
            if (!(object instanceof KeywordValueTable)) {
                if (!bl) {
                    String string = "keyword specifies a non-leaf component that is not a KeywordValueTable: " + KeywordParser.join(stringArray) + " (component #" + n + ")";
                    throw new KeywordValueException(string);
                }
                object = this.newSection();
                this.hashTable.put(stringArray[n], object);
            }
        } else {
            if (!bl) {
                return null;
            }
            object = this.newSection();
            this.hashTable.put(stringArray[n], object);
        }
        return ((KeywordValueTable)object).findSection(stringArray, bl, n + 1);
    }

    protected KeywordValueTable newSection() {
        return new KeywordValueTable();
    }

    public synchronized Object get(String string) throws KeywordValueException {
        String[] stringArray = KeywordParser.parse(string);
        KeywordValueTable keywordValueTable = this.findSection(stringArray, false, 0);
        if (keywordValueTable == null) {
            return null;
        }
        return keywordValueTable.hashTable.get(stringArray[stringArray.length - 1]);
    }

    public synchronized Object get(String string, Object object) throws KeywordValueException {
        Object object2;
        String[] stringArray = KeywordParser.parse(string);
        KeywordValueTable keywordValueTable = this.findSection(stringArray, false, 0);
        if (keywordValueTable == null) {
            object2 = object;
        } else {
            object2 = keywordValueTable.hashTable.get(stringArray[stringArray.length - 1]);
            if (object2 == null) {
                object2 = object;
            }
        }
        return object2;
    }

    public synchronized String getString(String string) throws KeywordValueException {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public synchronized String getString(String string, String string2) throws KeywordValueException {
        Object object = this.get(string);
        if (object == null) {
            return string2;
        }
        return object.toString();
    }

    public synchronized KeywordValueTable getSection(String string) throws KeywordValueException {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        if (!(object instanceof KeywordValueTable)) {
            String string2 = "Value of field \"" + string + " is not a KeywordValueTable; it is " + object.getClass().getName();
            throw new KeywordValueException(string2);
        }
        return (KeywordValueTable)object;
    }

    public synchronized void set(String string, Object object) throws KeywordValueException {
        String[] stringArray = KeywordParser.parse(string);
        KeywordValueTable keywordValueTable = this.findSection(stringArray, true, 0);
        keywordValueTable.hashTable.put(stringArray[stringArray.length - 1], object);
    }

    public synchronized void setDefault(String string, Object object) throws KeywordValueException {
        if (!this.containsKey(string)) {
            this.set(string, object);
        }
    }

    public synchronized boolean containsKey(String string) throws KeywordValueException {
        String[] stringArray = KeywordParser.parse(string);
        KeywordValueTable keywordValueTable = this.findSection(stringArray, false, 0);
        if (keywordValueTable == null) {
            return false;
        }
        return keywordValueTable.hashTable.containsKey(stringArray[stringArray.length - 1]);
    }

    public synchronized String[] keys() {
        Enumeration enumeration = this.hashTable.keys();
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public synchronized String[] leafKeys() {
        String[] stringArray;
        Enumeration enumeration = this.hashTable.keys();
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements()) {
            stringArray = (String[])enumeration.nextElement();
            Object v = this.hashTable.get(stringArray);
            if (v instanceof KeywordValueTable) {
                String[] stringArray2 = ((KeywordValueTable)v).leafKeys();
                for (int i = 0; i < stringArray2.length; ++i) {
                    vector.addElement(KeywordParser.concat((String)stringArray, stringArray2[i]));
                }
                continue;
            }
            vector.addElement(stringArray);
        }
        stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public synchronized void remove(String string) throws KeywordValueException {
        String[] stringArray = KeywordParser.parse(string);
        KeywordValueTable keywordValueTable = this.findSection(stringArray, false, 0);
        if (keywordValueTable != null) {
            keywordValueTable.hashTable.remove(stringArray[stringArray.length - 1]);
        }
    }

    public synchronized String toString() {
        return this.hashTable.toString();
    }

    public synchronized String toHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.hashTable.keys();
        stringBuffer.append("<UL>\n");
        Vector vector = new Vector();
        if (!enumeration.hasMoreElements()) {
            return "";
        }
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.hashTable.get(string);
            stringBuffer.append("<LI> <TT>");
            stringBuffer.append(string);
            stringBuffer.append(": </TT>");
            stringBuffer.append(this.formatFieldAsHtml(v));
            stringBuffer.append("\n");
        }
        stringBuffer.append("</UL>\n");
        return stringBuffer.toString();
    }

    private String formatArrayAsHtml(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<OL START=0>\n");
        for (int i = 0; i < Array.getLength(object); ++i) {
            stringBuffer.append("<LI>");
            stringBuffer.append(this.formatFieldAsHtml(Array.get(object, i)));
            stringBuffer.append("\n");
        }
        stringBuffer.append("</OL>\n");
        return stringBuffer.toString();
    }

    private String formatObjectAsHtml(Object object) {
        String string;
        if (object instanceof String) {
            string = object.toString();
        } else if (object instanceof Integer) {
            string = "<I><FONT SIZE=-1>(Integer)</FONT></I>" + object.toString();
        } else if (object instanceof Boolean) {
            string = "<I><FONT SIZE=-1>(Boolean)</FONT></I>" + object.toString();
        } else if (object instanceof Double) {
            string = "<I><FONT SIZE=-1>(Double)</FONT></I>" + object.toString();
        } else if (object instanceof Long) {
            string = "<I><FONT SIZE=-1>(Long)</FONT></I>" + object.toString();
        } else if (object instanceof Short) {
            string = "<I><FONT SIZE=-1>(Short)</FONT></I>" + object.toString();
        } else if (object instanceof Float) {
            string = "<I><FONT SIZE=-1>(Float)</FONT></I>" + object.toString();
        } else if (object instanceof Character) {
            string = "<I><FONT SIZE=-1>(Character)</FONT></I>" + object.toString();
        } else {
            try {
                Class<?> clazz = object.getClass();
                Method method = clazz.getMethod("toHtml", null);
                string = new String("<I><FONT SIZE=-1>(Object)" + method.invoke(object, null) + "</FONT></I>");
            }
            catch (Exception exception) {
                string = "<I><FONT SIZE=-1>(Object)</FONT></I>";
            }
        }
        return string;
    }

    private String formatFieldAsHtml(Object object) {
        String string = object instanceof KeywordValueTable ? ((KeywordValueTable)object).toHtml() : (object.getClass().isArray() ? this.formatArrayAsHtml(object) : this.formatObjectAsHtml(object));
        return string;
    }
}

