/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.util;

import com.lutris.util.KeywordValueException;
import java.text.MessageFormat;
import java.util.StringTokenizer;

public class KeywordParser {
    private static String separator = ".";

    private static String parseComponent(StringTokenizer stringTokenizer, int n, String string) throws KeywordValueException {
        String string2;
        boolean bl;
        String string3 = stringTokenizer.nextToken();
        if (string3.equals(separator) && n == 0) {
            String string4 = "keyword should not start with a {0} separator: \"{1} \"";
            String string5 = MessageFormat.format(string4, separator, string);
            throw new KeywordValueException(string5);
        }
        boolean bl2 = bl = string3.length() > 0;
        if (bl) {
            if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
                bl = false;
            }
            for (int i = 1; i < string3.length(); ++i) {
                if (Character.isJavaIdentifierPart(string3.charAt(i))) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            String string6 = "keyword component must be a legal Java identifier component \"" + string3 + "\": \"" + string + "\"";
            throw new KeywordValueException(string6);
        }
        if (stringTokenizer.hasMoreTokens() && !(string2 = stringTokenizer.nextToken()).equals(separator)) {
            String string7 = "keyword component separator must be a single '" + separator + "', got \"" + string2 + "\": " + string + "\"";
            throw new KeywordValueException(string7);
        }
        return string3;
    }

    public static String[] parse(String string) throws KeywordValueException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, separator, true);
        int n = stringTokenizer.countTokens();
        if (n % 2 != 1) {
            String string2 = "keyword component must be single word or words separated by '" + separator + "': \"" + string + "\"";
            throw new KeywordValueException(string2);
        }
        int n2 = n / 2 + 1;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = KeywordParser.parseComponent(stringTokenizer, i, string);
        }
        return stringArray;
    }

    public static String join(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(separator);
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String concat(String string, String string2) {
        return string + separator + string2;
    }
}

