/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.util;

import com.lutris.util.ConfigException;
import com.lutris.util.ConfigFile;
import com.lutris.util.ConfigParserConstants;
import com.lutris.util.ConfigParserTokenManager;
import com.lutris.util.KeywordValueException;
import com.lutris.util.ParseException;
import com.lutris.util.SimpleCharStream;
import com.lutris.util.Token;
import com.lutris.util.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.enhydra.util.ConfigFileInterface;

public class ConfigParser
implements ConfigParserConstants {
    private String comments = "";
    private ConfigFileInterface configFile = null;
    public ConfigParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[16];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] stringArray) throws ParseException, ConfigException {
        ConfigParser configParser = new ConfigParser(System.in);
        ConfigFile configFile = new ConfigFile();
        configParser.process(configFile);
        configFile.write(System.out);
    }

    public void process(ConfigFileInterface configFileInterface) throws ParseException, ConfigException {
        this.configFile = configFileInterface;
        try {
            try {
                this.ParseConfigFile();
            }
            catch (TokenMgrError tokenMgrError) {
                throw this.generateParseException();
            }
        }
        catch (ParseException parseException) {
            System.err.println("Syntax error in config file at line " + parseException.currentToken.next.beginLine + ", column " + parseException.currentToken.next.beginColumn + ".");
            throw parseException;
        }
    }

    private static final boolean isodigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    private static final boolean isxdigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public final void ParseConfigFile() throws ParseException, ConfigException {
        block4: {
            boolean bl;
            do {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 0: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block4;
                    }
                }
            } while (!(bl = this.ConfigEntry()));
            return;
        }
    }

    public final boolean ConfigEntry() throws ParseException, ConfigException {
        Token token;
        Object var5_1 = null;
        Vector vector = null;
        boolean bl = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                token = this.jj_consume_token(5);
                this.comments = this.comments + token.toString();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                token = this.jj_consume_token(8);
                this.comments = this.comments + token.toString();
                break;
            }
            case 6: {
                token = this.jj_consume_token(6);
                this.comments = this.comments + token.toString();
                break;
            }
            case 4: {
                Token token2 = this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                block15 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        bl = this.arraySpec();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                this.jj_consume_token(5);
                                break block15;
                            }
                        }
                        this.jj_la1[3] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                    }
                }
                this.jj_consume_token(15);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 10: {
                        vector = this.ValueList();
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                this.jj_consume_token(8);
                if (vector == null) {
                    try {
                        if (bl) {
                            this.configFile.addEntry(token2.image, new String[0], this.comments);
                        }
                        this.configFile.addEntry(token2.image, "", this.comments);
                    }
                    catch (KeywordValueException keywordValueException) {
                        throw new ConfigException("Key " + token2.image + " is not valid.");
                    }
                } else {
                    Enumeration enumeration = vector.elements();
                    String[] stringArray = new String[vector.size()];
                    int n = stringArray.length - 1;
                    while (enumeration.hasMoreElements()) {
                        stringArray[n--] = (String)enumeration.nextElement();
                    }
                    try {
                        if (bl) {
                            this.configFile.addEntry(token2.image, stringArray, this.comments);
                        } else {
                            if (stringArray.length != 1) {
                                throw new ConfigException("Key " + token2.image + " is not a list.  Use " + token2.image + "[]");
                            }
                            this.configFile.addEntry(token2.image, stringArray[0], this.comments);
                        }
                    }
                    catch (KeywordValueException keywordValueException) {
                        throw new ConfigException("Key " + token2.image + " is not valid.");
                    }
                }
                this.comments = "";
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                try {
                    this.configFile.addEntry("ConfigFileTrailingComment", (String[])null, this.comments);
                }
                catch (KeywordValueException keywordValueException) {
                    System.err.println("ConfigFile unable to add entry for ConfigFileTrailingComment.");
                }
                this.comments = "";
                return true;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return false;
    }

    public final Vector ValueList() throws ParseException {
        String string = null;
        Vector vector = null;
        string = this.Value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                vector = this.ValueList();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        if (vector == null) {
            vector = new Vector();
            vector.addElement(string);
        } else {
            vector.addElement(string);
        }
        return vector;
    }

    public final String Value() throws ParseException {
        String string = "";
        String string2 = "";
        string = this.ValueFragment();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                string2 = this.Value();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        return string + string2;
    }

    public final String ValueFragment() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                String string = this.QuotedString();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                return string;
            }
            case 10: {
                Token token = this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                return token.image;
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean arraySpec() throws ParseException {
        String string = "";
        String string2 = "";
        this.jj_consume_token(1);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(2);
        return true;
    }

    public final String QuotedString() throws ParseException {
        Token token = this.jj_consume_token(9);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = token.image.toCharArray();
        block18: for (int i = 1; i < cArray.length - 1; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    int n;
                    String string;
                    switch (cArray[i + 1]) {
                        case 'n': {
                            stringBuffer.append("\n");
                            ++i;
                            continue block18;
                        }
                        case 't': {
                            stringBuffer.append("\t");
                            ++i;
                            continue block18;
                        }
                        case 'b': {
                            stringBuffer.append("\b");
                            ++i;
                            continue block18;
                        }
                        case 'r': {
                            stringBuffer.append("\r");
                            ++i;
                            continue block18;
                        }
                        case 'f': {
                            stringBuffer.append("\f");
                            ++i;
                            continue block18;
                        }
                        case 'u': {
                            if (cArray.length - i >= 6 && ConfigParser.isxdigit(cArray[i + 2]) && ConfigParser.isxdigit(cArray[i + 3]) && ConfigParser.isxdigit(cArray[i + 4]) && ConfigParser.isxdigit(cArray[i + 5])) {
                                try {
                                    string = new String(cArray, i + 2, 4);
                                    n = Integer.parseInt(string, 16);
                                    stringBuffer.append((char)n);
                                    i += 5;
                                }
                                catch (Throwable throwable) {
                                    stringBuffer.append(cArray[i + 1]);
                                    ++i;
                                }
                                continue block18;
                            }
                            stringBuffer.append(cArray[i + 1]);
                            ++i;
                            continue block18;
                        }
                        case 'x': {
                            if (cArray.length - i >= 4 && ConfigParser.isxdigit(cArray[i + 2]) && ConfigParser.isxdigit(cArray[i + 3])) {
                                try {
                                    string = new String(cArray, i + 2, 2);
                                    n = Integer.parseInt(string, 16);
                                    stringBuffer.append((char)n);
                                    i += 3;
                                }
                                catch (Throwable throwable) {
                                    stringBuffer.append(cArray[i + 1]);
                                    ++i;
                                }
                                continue block18;
                            }
                            stringBuffer.append(cArray[i + 1]);
                            ++i;
                            continue block18;
                        }
                    }
                    if (cArray.length - i >= 4 && ConfigParser.isodigit(cArray[i + 1]) && ConfigParser.isodigit(cArray[i + 2]) && ConfigParser.isodigit(cArray[i + 3])) {
                        try {
                            string = new String(cArray, i + 1, 3);
                            n = Integer.parseInt(string, 8);
                            stringBuffer.append((char)n);
                            i += 3;
                        }
                        catch (Throwable throwable) {
                            stringBuffer.append(cArray[i + 1]);
                            ++i;
                        }
                        continue block18;
                    }
                    stringBuffer.append(cArray[i + 1]);
                    ++i;
                    continue block18;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{369, 32, 32, 32, 2, 32, 1536, 337, 32, 8192, 32, 4096, 32, 32, 1536, 32};
    }

    public ConfigParser(InputStream inputStream) {
        this.jj_input_stream = new SimpleCharStream(inputStream, 1, 1);
        this.token_source = new ConfigParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream inputStream) {
        this.jj_input_stream.ReInit(inputStream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigParser(Reader reader) {
        this.jj_input_stream = new SimpleCharStream(reader, 1, 1);
        this.token_source = new ConfigParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader reader) {
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigParser(ConfigParserTokenManager configParserTokenManager) {
        this.token_source = configParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ConfigParserTokenManager configParserTokenManager) {
        this.token_source = configParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.removeAllElements();
        boolean[] blArray = new boolean[16];
        for (n2 = 0; n2 < 16; ++n2) {
            blArray[n2] = false;
        }
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) == 0) continue;
                blArray[n] = true;
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.elementAt(n);
        }
        return new ParseException(this.token, nArrayArray, ConfigParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ConfigParser.jj_la1_0();
    }
}

