/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.util;

import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.ConfigParser;
import com.lutris.util.KeywordValueException;
import com.lutris.util.KeywordValueTable;
import com.lutris.util.ParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.enhydra.util.ConfigFileInterface;

public class ConfigFile
implements ConfigFileInterface {
    private Config config;
    private Vector order;
    private Hashtable comments;
    private File file = null;
    public static final String TRAILING_COMMENT = "ConfigFileTrailingComment";
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ConfigFile() {
        this.config = new Config();
        this.order = new Vector();
        this.comments = new Hashtable();
    }

    public ConfigFile(InputStream inputStream) throws ConfigException {
        this.config = new Config();
        this.order = new Vector();
        this.comments = new Hashtable();
        ConfigParser configParser = new ConfigParser(inputStream);
        try {
            configParser.process(this);
        }
        catch (ParseException parseException) {
            throw new ConfigException(2, parseException.getMessage());
        }
    }

    public ConfigFile(File file) throws ConfigException, IOException {
        this(new FileInputStream(file));
        this.file = file;
        this.config.setConfigFile(this);
    }

    public ConfigFile(KeywordValueTable keywordValueTable) throws ConfigException {
        this.config = new Config(keywordValueTable);
        this.order = new Vector();
        this.comments = new Hashtable();
    }

    public Config getConfig() {
        return this.config;
    }

    public String getComment(String string) {
        return (String)this.comments.get(string);
    }

    public void addEntry(String string, String[] stringArray, String string2) throws KeywordValueException {
        if (!string.equals(TRAILING_COMMENT)) {
            this.config.set(string, stringArray);
            if (!this.order.contains(string)) {
                this.order.addElement(string);
            }
        }
        this.comments.put(string, string2);
    }

    public void addEntry(String string, String string2, String string3) throws KeywordValueException {
        if (!string.equals(TRAILING_COMMENT)) {
            this.config.set(string, string2);
            if (!this.order.contains(string)) {
                this.order.addElement(string);
            }
        }
        this.comments.put(string, string3);
    }

    public void removeEntry(String string) throws KeywordValueException {
        if (!string.equals(TRAILING_COMMENT)) {
            this.config.remove(string);
            this.order.removeElement(string);
        }
        this.comments.remove(string);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void write() throws IOException, FileNotFoundException {
        if (this.file == null) {
            throw new FileNotFoundException("No file associated with this object");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this.file);
        this.write(fileOutputStream);
        fileOutputStream.close();
    }

    public void write(OutputStream outputStream) {
        String[] stringArray;
        Object object;
        String string;
        String string2;
        int n;
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        boolean bl = false;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray2 = this.config.leafKeys();
        for (n = 0; n < stringArray2.length; ++n) {
            hashtable.put(stringArray2[n], "X");
        }
        for (n = 0; n < this.order.size(); ++n) {
            string2 = (String)this.order.elementAt(n);
            string = (String)this.comments.get(string2);
            bl = false;
            try {
                object = this.config.get(string2);
                if (object == null) continue;
                bl = object.getClass().isArray();
                if (bl) {
                    Object[] objectArray = (Object[])object;
                    if (objectArray.length > 0 && objectArray[0] instanceof String) {
                        stringArray = (String[])object;
                    } else {
                        stringArray = new String[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            stringArray[i] = objectArray[i].toString();
                        }
                    }
                } else {
                    stringArray = new String[1];
                    stringArray[0] = object instanceof String ? (String)object : object.toString();
                }
            }
            catch (KeywordValueException keywordValueException) {
                stringArray = null;
            }
            if (stringArray == null || stringArray.length == 0) {
                if (string != null && !string.equals("")) {
                    if (string.endsWith("\n")) {
                        printWriter.print(string);
                    } else {
                        printWriter.println(string);
                    }
                }
                printWriter.print(string2);
                if (bl) {
                    printWriter.print("[]");
                }
                printWriter.println(" =");
            } else {
                if (string != null && !string.equals("")) {
                    if (string.endsWith("\n")) {
                        printWriter.print(string);
                    } else {
                        printWriter.println(string);
                    }
                }
                if (bl) {
                    printWriter.print(string2 + "[] = " + ConfigFile.quoteStr(stringArray[0]));
                } else {
                    printWriter.print(string2 + " = " + ConfigFile.quoteStr(stringArray[0]));
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    printWriter.print(", " + ConfigFile.quoteStr(stringArray[i]));
                }
                printWriter.println();
            }
            hashtable.remove(string2);
        }
        string = (String)this.comments.get(TRAILING_COMMENT);
        if (string != null && !string.equals("")) {
            if (string.endsWith("\n")) {
                printWriter.print(string);
            } else {
                printWriter.println(string);
            }
        }
        hashtable.remove(TRAILING_COMMENT);
        n = 0;
        object = "";
        while (n != stringArray2.length) {
            int n2;
            string2 = stringArray2[n];
            ++n;
            if (hashtable.get(string2) == null) continue;
            bl = false;
            if (!string2.startsWith((String)object)) {
                printWriter.println("");
            }
            if ((n2 = string2.indexOf(46)) == -1) {
                n2 = string2.length();
            }
            object = string2.substring(0, n2);
            try {
                Object object2 = this.config.get(string2);
                if (object2 == null) continue;
                bl = object2.getClass().isArray();
                if (bl) {
                    Object[] objectArray = (Object[])object2;
                    if (objectArray[0] instanceof String) {
                        stringArray = (String[])object2;
                    } else {
                        stringArray = new String[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            stringArray[i] = objectArray[i].toString();
                        }
                    }
                } else {
                    stringArray = new String[1];
                    stringArray[0] = object2 instanceof String ? (String)object2 : object2.toString();
                }
            }
            catch (KeywordValueException keywordValueException) {
                stringArray = null;
            }
            if (stringArray == null || stringArray.length == 0) {
                printWriter.println(string2 + " =");
                continue;
            }
            if (bl) {
                printWriter.print(string2 + "[] = " + ConfigFile.quoteStr(stringArray[0]));
            } else {
                printWriter.print(string2 + " = " + ConfigFile.quoteStr(stringArray[0]));
            }
            for (int i = 1; i < stringArray.length; ++i) {
                printWriter.print(", " + ConfigFile.quoteStr(stringArray[i]));
            }
            printWriter.println();
        }
    }

    private boolean containsWhiteSpace(String string) {
        if (string.indexOf(" ") != -1) {
            return true;
        }
        return string.indexOf("\t") != -1;
    }

    private static final String quoteStr(String string) {
        if (string == null || string.length() < 1) {
            return "";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block9: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    bl = true;
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\b': {
                    bl = true;
                    stringBuffer.append("\\b");
                    continue block9;
                }
                case '\r': {
                    bl = true;
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\f': {
                    bl = true;
                    stringBuffer.append("\\f");
                    continue block9;
                }
                case '\"': {
                    bl = true;
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    bl = true;
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case '\t': 
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    bl = true;
                    stringBuffer.append(cArray[i]);
                    continue block9;
                }
                default: {
                    char c;
                    if (cArray[i] < ' ' || cArray[i] == '\u007f') {
                        bl = true;
                        c = cArray[i];
                        stringBuffer.append('\\');
                        stringBuffer.append(digits[(c & 0xC0) >> 6]);
                        stringBuffer.append(digits[(c & 0x38) >> 3]);
                        stringBuffer.append(digits[c & 7]);
                        continue block9;
                    }
                    if (cArray[i] > '\u007f') {
                        bl = true;
                        c = cArray[i];
                        stringBuffer.append("\\u");
                        stringBuffer.append(digits[(c & 0xF000) >> 12]);
                        stringBuffer.append(digits[(c & 0xF00) >> 8]);
                        stringBuffer.append(digits[(c & 0xF0) >> 4]);
                        stringBuffer.append(digits[c & 0xF]);
                        continue block9;
                    }
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        if (bl) {
            return "\"" + stringBuffer.toString() + "\"";
        }
        return stringBuffer.toString();
    }
}

