/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.util;

import com.lutris.util.ConfigException;
import com.lutris.util.FatalExceptionError;
import com.lutris.util.KeywordValueException;
import com.lutris.util.KeywordValueTable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.enhydra.util.ConfigFileInterface;

public class Config
extends KeywordValueTable {
    private static final int GET_ALL = -1;
    private ConfigFileInterface configFile = null;

    public Config() {
    }

    public Config(KeywordValueTable keywordValueTable) {
        String[] stringArray = keywordValueTable.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                this.set(stringArray[i], keywordValueTable.get(stringArray[i]));
                continue;
            }
            catch (KeywordValueException keywordValueException) {
                throw new FatalExceptionError(keywordValueException);
            }
        }
    }

    public Config(KeywordValueTable keywordValueTable, ConfigFileInterface configFileInterface) {
        this(keywordValueTable);
        this.configFile = configFileInterface;
    }

    public Config(ConfigFileInterface configFileInterface) {
        this();
        this.configFile = configFileInterface;
    }

    public Config getClonedConfig() throws KeywordValueException {
        Config config = this.getClonedConfigParams();
        ConfigFileInterface configFileInterface = null;
        Class<?> clazz = this.getConfigFile().getClass();
        String string = clazz.getName();
        Class[] classArray = new Class[1];
        Constructor<?> constructor = null;
        Object[] objectArray = new Object[1];
        try {
            classArray[0] = Class.forName("com.lutris.util.Config");
            constructor = clazz.getConstructor(classArray);
            objectArray[0] = this;
            configFileInterface = (ConfigFileInterface)constructor.newInstance(objectArray);
            configFileInterface.setFile(this.getConfigFile().getFile());
            config.setConfigFile(configFileInterface);
        }
        catch (Exception exception) {
            config.setConfigFile(configFileInterface);
        }
        return config;
    }

    private Config getClonedConfigParams() throws KeywordValueException {
        Config config = new Config();
        String[] stringArray = this.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.get(stringArray[i]);
            if (object instanceof String) {
                config.set(new String(stringArray[i]), new String((String)object));
                continue;
            }
            if (object instanceof KeywordValueTable) {
                Config config2 = new Config((KeywordValueTable)object).getClonedConfigParams();
                config.set(new String(stringArray[i]), config2);
                continue;
            }
            if (object instanceof Config) {
                Config config3 = ((Config)object).getClonedConfigParams();
                config.set(new String(stringArray[i]), config3);
                continue;
            }
            if (!object.getClass().isArray()) continue;
            int n = Array.getLength(object);
            String[] stringArray2 = new String[n];
            for (int j = 0; j < n; ++j) {
                stringArray2[j] = new String(Array.get(object, j).toString());
            }
            config.set(new String(stringArray[i]), stringArray2);
        }
        return config;
    }

    public Hashtable allConfigParams(String string) throws KeywordValueException {
        String[] stringArray = this.keys();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object = this.get(stringArray[i]);
            String string2 = string != null && string.length() > 0 ? string + "__" + stringArray[i] : stringArray[i];
            if (object instanceof String) {
                hashtable.put(string2, (String)object);
                continue;
            }
            if (object instanceof KeywordValueTable) {
                hashtable.putAll(((Config)object).allConfigParams(string2));
                continue;
            }
            if (object instanceof Config) {
                hashtable.putAll(((Config)object).allConfigParams(string2));
                continue;
            }
            if (!object.getClass().isArray()) continue;
            int n = Array.getLength(object);
            for (int j = 0; j < n; ++j) {
                hashtable.put(string2 + "__" + j, Array.get(object, j).toString());
            }
        }
        return hashtable;
    }

    public void importConfig(Config config) throws KeywordValueException {
        int n;
        String[] stringArray = this.keys();
        String[] stringArray2 = config.keys();
        for (n = 0; n < stringArray2.length; ++n) {
            this.set(stringArray2[n], config.get(stringArray2[n]));
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (config.containsKey(stringArray[n])) continue;
            this.remove(stringArray2[n]);
        }
    }

    protected KeywordValueTable newSection() {
        return new Config(this.configFile);
    }

    public ConfigFileInterface getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(ConfigFileInterface configFileInterface) {
        this.configFile = configFileInterface;
    }

    public synchronized Config getConfig(String string) throws KeywordValueException {
        return (Config)this.getSection(string);
    }

    public synchronized KeywordValueTable getSection(String string) throws KeywordValueException {
        KeywordValueTable keywordValueTable = super.getSection(string);
        if (keywordValueTable == null) {
            return null;
        }
        if (keywordValueTable instanceof Config) {
            return keywordValueTable;
        }
        return new Config(keywordValueTable, this.configFile);
    }

    public boolean containsKey(String string) {
        boolean bl = false;
        try {
            bl = super.containsKey(string);
        }
        catch (KeywordValueException keywordValueException) {
            bl = false;
        }
        return bl;
    }

    public int containsCount(String string) throws ConfigException {
        Object object = null;
        try {
            object = this.get(string);
            if (object == null) {
                return -1;
            }
            return Array.getLength(object);
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException(keywordValueException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (object == null) {
                return -1;
            }
            return 1;
        }
    }

    public boolean isArray(String string) throws ConfigException {
        Object object = null;
        try {
            object = this.get(string);
            if (object == null) {
                throw new ConfigException("Key \"" + string + "\" not found.");
            }
            Array.getLength(object);
            return true;
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException(keywordValueException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private final long[] getLongsInternal(String string, int n) throws ConfigException {
        Object object;
        try {
            object = this.get(string);
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException(keywordValueException.getMessage());
        }
        if (object == null) {
            throw new ConfigException(1, "Key \"" + string + "\" not found in configuration.");
        }
        long[] lArray = null;
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            lArray = new long[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    lArray[i] = Long.parseLong(Array.get(object, i).toString());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new ConfigException("Element " + i + " is not a long.");
                }
            }
        } else {
            lArray = new long[1];
            try {
                lArray[0] = Long.parseLong(object.toString());
            }
            catch (Throwable throwable) {
                throw new ConfigException("Element 0 is not a long.");
            }
        }
        if (n != -1 && lArray.length != n) {
            throw new ConfigException(3, "Key \"" + string + "\" has " + lArray.length + " elements. (expected " + n + ")");
        }
        return lArray;
    }

    public long getLong(String string) throws ConfigException {
        return this.getLongsInternal(string, 1)[0];
    }

    public long getLong(String string, long l) throws ConfigException {
        try {
            return this.getLongsInternal(string, 1)[0];
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return l;
        }
    }

    public long[] getLongs(String string) throws ConfigException {
        return this.getLongsInternal(string, -1);
    }

    public long[] getLongs(String string, long[] lArray) throws ConfigException {
        try {
            return this.getLongsInternal(string, -1);
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return lArray;
        }
    }

    private final int[] getIntsInternal(String string, int n) throws ConfigException {
        Object object;
        try {
            object = this.get(string);
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException(keywordValueException.getMessage());
        }
        if (object == null) {
            throw new ConfigException(1, "Key \"" + string + "\" not found in configuration.");
        }
        int[] nArray = null;
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    nArray[i] = Integer.parseInt(Array.get(object, i).toString());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new ConfigException("Element " + i + " is not an integer.");
                }
            }
        } else {
            nArray = new int[1];
            try {
                nArray[0] = Integer.parseInt(object.toString());
            }
            catch (Throwable throwable) {
                throw new ConfigException("Element 0 is not an integer.");
            }
        }
        if (n != -1 && nArray.length != n) {
            throw new ConfigException(3, "Key \"" + string + "\" has " + nArray.length + " elements. (expected " + n + ")");
        }
        return nArray;
    }

    public int getInt(String string) throws ConfigException {
        return this.getIntsInternal(string, 1)[0];
    }

    public int getInt(String string, int n) throws ConfigException {
        try {
            return this.getIntsInternal(string, 1)[0];
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return n;
        }
    }

    public int[] getInts(String string) throws ConfigException {
        return this.getIntsInternal(string, -1);
    }

    public int[] getInts(String string, int[] nArray) throws ConfigException {
        try {
            return this.getIntsInternal(string, -1);
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return nArray;
        }
    }

    private final String[] getStringsInternal(String string, int n) throws ConfigException {
        Object object;
        try {
            object = this.get(string);
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException(keywordValueException.getMessage());
        }
        if (object == null) {
            throw new ConfigException(1, "Key \"" + string + "\" not found in configuration.");
        }
        String[] stringArray = null;
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    stringArray[i] = Array.get(object, i).toString();
                    continue;
                }
                catch (Throwable throwable) {
                    throw new ConfigException("Element " + i + " is not a String.");
                }
            }
        } else {
            stringArray = new String[1];
            try {
                stringArray[0] = object.toString();
            }
            catch (Throwable throwable) {
                throw new ConfigException("Element 0 is not a String.");
            }
        }
        if (n != -1 && stringArray.length != n) {
            throw new ConfigException(3, "Key \"" + string + "\" has " + stringArray.length + " elements. (expected " + n + ")");
        }
        return stringArray;
    }

    public String getString(String string) throws ConfigException {
        return this.getStringsInternal(string, 1)[0];
    }

    public String getString(String string, String string2) throws ConfigException {
        try {
            return this.getStringsInternal(string, 1)[0];
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return string2;
        }
    }

    public String[] getStrings(String string) throws ConfigException {
        return this.getStringsInternal(string, -1);
    }

    public String[] getStrings(String string, String[] stringArray) throws ConfigException {
        try {
            return this.getStringsInternal(string, -1);
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return stringArray;
        }
    }

    private final boolean[] getBooleansInternal(String string, int n) throws ConfigException {
        Object object;
        try {
            object = this.get(string);
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException(keywordValueException.getMessage());
        }
        if (object == null) {
            throw new ConfigException(1, "Key \"" + string + "\" not found in configuration.");
        }
        boolean[] blArray = null;
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            blArray = new boolean[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    blArray[i] = Boolean.valueOf(Array.get(object, i).toString().toLowerCase());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new ConfigException("Element " + i + " is not a boolean.");
                }
            }
        } else {
            blArray = new boolean[1];
            try {
                blArray[0] = Boolean.valueOf(object.toString().toLowerCase());
            }
            catch (Throwable throwable) {
                throw new ConfigException("Element 0 is not a boolean.");
            }
        }
        if (n != -1 && blArray.length != n) {
            throw new ConfigException(3, "Key \"" + string + "\" has " + blArray.length + " elements. (expected " + n + ")");
        }
        return blArray;
    }

    public boolean getBoolean(String string) throws ConfigException {
        return this.getBooleansInternal(string, 1)[0];
    }

    public boolean getBoolean(String string, boolean bl) throws ConfigException {
        try {
            return this.getBooleansInternal(string, 1)[0];
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return bl;
        }
    }

    public boolean[] getBooleans(String string) throws ConfigException {
        return this.getBooleansInternal(string, -1);
    }

    public boolean[] getBooleans(String string, boolean[] blArray) throws ConfigException {
        try {
            return this.getBooleansInternal(string, -1);
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return blArray;
        }
    }

    private final double[] getDoublesInternal(String string, int n) throws ConfigException {
        Object object;
        try {
            object = this.get(string);
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException(keywordValueException.getMessage());
        }
        if (object == null) {
            throw new ConfigException(1, "Key \"" + string + "\" not found in configuration.");
        }
        double[] dArray = null;
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                try {
                    dArray[i] = Double.valueOf(Array.get(object, i).toString());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new ConfigException("Element " + i + " is not a double.");
                }
            }
        } else {
            dArray = new double[1];
            try {
                dArray[0] = Double.valueOf(object.toString());
            }
            catch (Throwable throwable) {
                throw new ConfigException("Element 0 is not a long.");
            }
        }
        if (n != -1 && dArray.length != n) {
            throw new ConfigException(3, "Key \"" + string + "\" has " + dArray.length + " elements. (expected " + n + ")");
        }
        return dArray;
    }

    public double getDouble(String string) throws ConfigException {
        return this.getDoublesInternal(string, 1)[0];
    }

    public double getDouble(String string, double d) throws ConfigException {
        try {
            return this.getDoublesInternal(string, 1)[0];
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return d;
        }
    }

    public double[] getDoubles(String string) throws ConfigException {
        return this.getDoublesInternal(string, -1);
    }

    public double[] getDoubles(String string, double[] dArray) throws ConfigException {
        try {
            return this.getDoublesInternal(string, -1);
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return dArray;
        }
    }

    public Object getDataSource(String string) throws ConfigException {
        Object object;
        try {
            object = this.get(string);
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException(keywordValueException.getMessage());
        }
        if (object == null) {
            throw new ConfigException(1, "Key \"" + string + "\" not found in configuration.");
        }
        Object object2 = null;
        if (object.getClass().isArray()) {
            throw new ConfigException("The value is an array. The method returns a single DataStruct Object.");
        }
        try {
            object2 = object;
        }
        catch (Throwable throwable) {
            throw new ConfigException("Element is not a DataSource.");
        }
        return object2;
    }

    public Object getDataSource(String string, Object object) throws ConfigException {
        try {
            return this.getDataSource(string);
        }
        catch (ConfigException configException) {
            if (configException.reason != 1) {
                throw configException;
            }
            return object;
        }
    }
}

