/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging.tests;

import com.lutris.logging.LogChannel;
import com.lutris.logging.LogWriter;
import com.lutris.logging.Logger;
import com.lutris.logging.StandardLogger;
import java.io.File;
import java.io.IOException;

public class LoggerTests {
    private static void makeException(String string, int n) throws Exception {
        if (n == 0) {
            throw new Exception(string);
        }
        LoggerTests.makeException(string, n - 1);
    }

    private static void doSomeLogging(String string, String[] stringArray) {
        LogChannel logChannel = Logger.getCentralLogger().getChannel(string);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            logChannel.write(stringArray[i], "msg #" + n++);
            try {
                LoggerTests.makeException("exception " + n, 4);
            }
            catch (Exception exception) {
                logChannel.write(stringArray[i], "exception #" + n++, (Throwable)exception);
            }
            int n2 = logChannel.getLevel(stringArray[i]);
            logChannel.write(n2, "msg #" + n++);
            try {
                LoggerTests.makeException("exception " + n, 5);
            }
            catch (Exception exception) {
                logChannel.write(n2, "exception #" + n++, (Throwable)exception);
            }
            logChannel.write(n2, "multi-line\nmessage\nnumber " + n++);
        }
    }

    private static void writerTest(String string, String string2) {
        LogChannel logChannel = Logger.getCentralLogger().getChannel(string);
        LogWriter logWriter = logChannel.getLogWriter(string2);
        logWriter.write("start LogWriter test");
        logWriter.println("@1 - println");
        logWriter.print("@2 - print1 ");
        logWriter.print("@3 - print2 ");
        logWriter.print(10);
        logWriter.print(" ");
        logWriter.print("@4 - print3 ");
        logWriter.println();
        logWriter.print("@5 - flush ");
        logWriter.flush();
        logWriter.println("@6 - after flush");
    }

    public static void main(String[] stringArray) throws IOException {
        StandardLogger standardLogger = new StandardLogger(true);
        String[] stringArray2 = new String[]{"A_LEVEL", "ALERT", "WARNING", "ERROR", "OFF"};
        String[] stringArray3 = new String[]{"A_LEVEL", "ALERT", "WARNING", "ERROR"};
        String[] stringArray4 = new String[]{"WARNING", "ERROR"};
        standardLogger.configure(new File("logs/test.log"), stringArray3, stringArray4);
        LoggerTests.doSomeLogging("fac1", stringArray2);
        LoggerTests.doSomeLogging("fac2", stringArray2);
        LoggerTests.writerTest("fac1", "ALERT");
    }
}

