/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.LogChannel;
import com.lutris.logging.Logger;
import com.lutris.logging.StandardLogChannel;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.ConfigFile;
import com.lutris.util.KeywordValueException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class StandardLogger
extends Logger {
    private static final String LOG_SECTION = "Server";
    private static final String LOG_FILE = "LogFile";
    private static final String LOG_TO_FILE = "LogToFile";
    private static final String LOG_TO_STDERR = "LogToStderr";
    private Hashtable levelNumbers = new Hashtable();
    protected String[] levelNames = new String[34];
    protected int numLevels = 0;
    protected boolean[] enabledLevelFlags = null;
    protected boolean[] logFileLevelFlags = null;
    protected boolean[] stderrLevelFlags = null;
    File activeLogFile;
    PrintWriter logFileStream;
    PrintWriter stderrStream;
    private Hashtable logChannels = new Hashtable();

    public StandardLogger(boolean bl) {
        int n;
        for (n = 0; n <= 17; ++n) {
            String string = standardLevelNames[n];
            this.levelNumbers.put(string, new Integer(n));
            this.levelNames[n] = string;
        }
        this.numLevels = n;
        if (bl) {
            centralLogger = this;
        }
    }

    private int getMaxLevel(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.getLevel(stringArray[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private boolean[] getLevelStateArray(String[] stringArray, int n) {
        boolean[] blArray = new boolean[n + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            blArray[this.getLevel((String)stringArray[i])] = true;
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File switchLogFile(File file) throws IOException {
        PrintWriter printWriter = this.logFileStream;
        File file2 = this.activeLogFile;
        FileOutputStream fileOutputStream = new FileOutputStream(file.getPath(), true);
        this.logFileStream = new PrintWriter(fileOutputStream, false);
        this.activeLogFile = file;
        if (printWriter != null) {
            PrintWriter printWriter2 = printWriter;
            synchronized (printWriter2) {
                printWriter.close();
            }
        }
        return file2;
    }

    public synchronized void configure(File file, String[] stringArray, String[] stringArray2) throws IOException {
        int n;
        if (file.getParent() != null) {
            new File(file.getParent()).mkdirs();
        }
        this.switchLogFile(file);
        this.stderrStream = new PrintWriter(System.err, false);
        int n2 = this.enabledLevelFlags != null ? this.enabledLevelFlags.length - 1 : 17;
        int n3 = this.getMaxLevel(stringArray);
        if (n3 > n2) {
            n2 = n3;
        }
        if ((n3 = this.getMaxLevel(stringArray2)) > n2) {
            n2 = n3;
        }
        this.logFileLevelFlags = this.getLevelStateArray(stringArray, n2);
        this.stderrLevelFlags = this.getLevelStateArray(stringArray2, n2);
        this.enabledLevelFlags = new boolean[n2 + 1];
        for (n = 0; n < this.logFileLevelFlags.length; ++n) {
            if (!this.logFileLevelFlags[n]) continue;
            this.enabledLevelFlags[n] = true;
        }
        for (n = 0; n < this.stderrLevelFlags.length; ++n) {
            if (!this.stderrLevelFlags[n]) continue;
            this.enabledLevelFlags[n] = true;
        }
    }

    private synchronized StandardLogChannel createChannel(String string) {
        StandardLogChannel standardLogChannel = (StandardLogChannel)this.logChannels.get(string);
        if (standardLogChannel == null) {
            standardLogChannel = new StandardLogChannel(string, this);
            this.logChannels.put(string, standardLogChannel);
        }
        return standardLogChannel;
    }

    public LogChannel getChannel(String string) {
        StandardLogChannel standardLogChannel = (StandardLogChannel)this.logChannels.get(string);
        if (standardLogChannel == null) {
            standardLogChannel = this.createChannel(string);
        }
        return standardLogChannel;
    }

    private synchronized Integer createLevel(String string) {
        Integer n = (Integer)this.levelNumbers.get(string);
        if (n == null) {
            n = new Integer(this.numLevels);
            this.levelNames[this.numLevels] = string;
            this.levelNumbers.put(string, n);
            ++this.numLevels;
        }
        return n;
    }

    public synchronized int getLevel(String string) {
        Integer n = (Integer)this.levelNumbers.get(string);
        if (n == null) {
            n = this.createLevel(string);
        }
        return n;
    }

    public String getLevelName(int n) {
        if (n >= 0 && n < this.numLevels) {
            return this.levelNames[n];
        }
        return null;
    }

    public void configure(String string) throws ConfigException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ConfigFile configFile = new ConfigFile(fileInputStream);
            Config config = configFile.getConfig();
            fileInputStream.close();
            Config config2 = (Config)config.getSection(LOG_SECTION);
            this.configure(config2);
        }
        catch (KeywordValueException keywordValueException) {
            throw new ConfigException("Error parsing configuration for logger.", keywordValueException);
        }
        catch (IOException iOException) {
            throw new ConfigException("Error configuring logger.", iOException);
        }
    }

    public void configure(Config config) throws ConfigException {
        if (config == null) {
            throw new ConfigException("Cannot configure logger. Config is null.");
        }
        String string = null;
        string = config.getString(LOG_FILE);
        String[] stringArray = null;
        stringArray = config.getStrings(LOG_TO_FILE);
        String[] stringArray2 = null;
        stringArray2 = config.getStrings(LOG_TO_STDERR);
        File file = new File(string);
        try {
            this.configure(file, stringArray, stringArray2);
        }
        catch (IOException iOException) {
            throw new ConfigException("Error configuring logger.", iOException);
        }
    }
}

