/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.LogChannel;
import com.lutris.logging.LogWriter;
import com.lutris.logging.StandardLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StandardLogChannel
implements LogChannel {
    private String facility;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private StandardLogger logger;

    protected StandardLogChannel(String string, StandardLogger standardLogger) {
        this.facility = string;
        this.logger = standardLogger;
    }

    public int getLevel(String string) {
        return this.logger.getLevel(string);
    }

    public LogWriter getLogWriter(String string) {
        return new LogWriter((LogChannel)this, string);
    }

    public LogWriter getLogWriter(int n) {
        return new LogWriter((LogChannel)this, n);
    }

    public boolean isEnabled(int n) {
        boolean[] blArray = this.logger.enabledLevelFlags;
        return blArray != null && n >= 0 && n < blArray.length && blArray[n];
    }

    public boolean isEnabled(String string) {
        return this.isEnabled(this.logger.getLevel(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(PrintWriter printWriter, Date date, int n, String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            dateFormatter.format(date, stringBuffer, new FieldPosition(1));
            stringBuffer.append(": ");
            stringBuffer.append(this.facility);
            stringBuffer.append(',');
            stringBuffer.append(this.logger.levelNames[n]);
            int n2 = 0;
            PrintWriter printWriter2 = printWriter;
            synchronized (printWriter2) {
                while (n2 < string.length()) {
                    printWriter.print(stringBuffer);
                    if (n2 == 0) {
                        printWriter.print(": ");
                    } else {
                        printWriter.print("+ ");
                    }
                    int n3 = string.indexOf(10, n2);
                    if (n3 < 0) {
                        n3 = string.length();
                    }
                    printWriter.write(string, n2, n3 - n2);
                    printWriter.println();
                    n2 = n3 + 1;
                }
                printWriter.flush();
            }
        }
        catch (Throwable throwable) {
            System.err.println("StandardLogChannel.doWrite ignored exception:");
            throwable.printStackTrace();
        }
    }

    public void write(int n, String string) {
        if (this.isEnabled(n)) {
            Date date = new Date();
            if (this.logger.logFileLevelFlags[n]) {
                this.doWrite(this.logger.logFileStream, date, n, string);
            }
            if (this.logger.stderrLevelFlags[n]) {
                this.doWrite(this.logger.stderrStream, date, n, string);
            }
        }
    }

    public synchronized void write(String string, String string2) {
        this.write(this.getLevel(string), string2);
    }

    public synchronized void write(int n, String string, Throwable throwable) {
        if (this.isEnabled(n)) {
            Date date = new Date();
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringWriter.flush();
            String string2 = string + ":" + " " + throwable.getMessage() + '\n' + stringWriter;
            if (this.logger.logFileLevelFlags[n]) {
                this.doWrite(this.logger.logFileStream, date, n, string2);
            }
            if (this.logger.stderrLevelFlags[n]) {
                this.doWrite(this.logger.stderrStream, date, n, string2);
            }
        }
    }

    public synchronized void write(String string, String string2, Throwable throwable) {
        this.write(this.getLevel(string), string2, throwable);
    }
}

