/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.ChannelWriter;
import com.lutris.logging.LogChannel;
import java.io.PrintWriter;
import java.io.Writer;

public class LogWriter
extends PrintWriter {
    private LogChannel channel;
    private int level;
    private boolean enabled;

    protected LogWriter(LogChannel logChannel, String string) {
        this(logChannel, logChannel.getLevel(string));
    }

    protected LogWriter(LogChannel logChannel, int n) {
        super((Writer)new ChannelWriter(logChannel, n), true);
        this.channel = logChannel;
        this.level = n;
        this.enabled = logChannel.isEnabled(this.level);
    }

    public LogChannel getChannel() {
        return this.channel;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void println(String string, Throwable throwable) {
        if (this.enabled) {
            this.flush();
            this.channel.write(this.level, string, throwable);
        }
    }
}

