/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.Log4jLogChannel;
import com.lutris.logging.LogChannel;
import com.lutris.logging.Logger;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4jLogger
extends Logger {
    private Hashtable levelNumbers = new Hashtable();
    protected String[] levelNames = new String[34];
    protected int numLevels = 0;
    protected boolean[] enabledLevelFlags = null;
    protected boolean[] logFileLevelFlags = null;
    protected boolean[] stderrLevelFlags = null;
    File activeLogFile;
    PrintWriter logFileStream;
    PrintWriter stderrStream;
    private Hashtable logChannels = new Hashtable();
    static String separatorLine = "";

    public Log4jLogger(boolean bl) {
        int n;
        for (n = 0; n <= 17; ++n) {
            String string = standardLevelNames[n];
            this.levelNumbers.put(string, new Integer(n));
            this.levelNames[n] = string;
        }
        this.numLevels = n;
        if (bl) {
            centralLogger = this;
        }
    }

    private int getMaxLevel(String[] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.getLevel(stringArray[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private boolean[] getLevelStateArray(String[] stringArray, int n) {
        boolean[] blArray = new boolean[n + 1];
        for (int i = 0; i < stringArray.length; ++i) {
            blArray[this.getLevel((String)stringArray[i])] = true;
        }
        return blArray;
    }

    public synchronized void configure(String string) throws ConfigException {
        try {
            DOMConfigurator.configure((String)string);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ConfigException("Cannot configure Log4jLogger:", factoryConfigurationError);
        }
    }

    private static void configureLogger() {
        BasicConfigurator.configure();
        org.apache.log4j.Logger logger = org.apache.log4j.Logger.getRootLogger();
        logger.removeAllAppenders();
        LoggerRepository loggerRepository = logger.getLoggerRepository();
        loggerRepository.setThreshold(Level.INFO);
        RollingFileAppender rollingFileAppender = null;
        RollingFileAppender rollingFileAppender2 = null;
        ConsoleAppender consoleAppender = null;
        String string = System.getProperty("enhydra.home") + File.separator + "logs" + File.separator;
        String string2 = string + "multiserver.log";
        String string3 = string + "access.log";
        try {
            rollingFileAppender = new RollingFileAppender((Layout)new PatternLayout("%d{ISO8601}: [%t], %C(1) %p, %c: %m%n"), string2);
            rollingFileAppender2 = new RollingFileAppender((Layout)new PatternLayout("%m%n"), string3);
            consoleAppender = new ConsoleAppender((Layout)new PatternLayout("%d{ISO8601}: [%t], %C(1) %p, %c: %m%n"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        logger.addAppender(rollingFileAppender);
        org.apache.log4j.Logger logger2 = org.apache.log4j.Logger.getLogger((String)"REQUEST");
        logger2.setAdditivity(false);
        logger2.addAppender(rollingFileAppender2);
        org.apache.log4j.Logger logger3 = org.apache.log4j.Logger.getLogger((String)"SysOut");
        logger3.setAdditivity(false);
        logger3.addAppender(consoleAppender);
    }

    private synchronized Log4jLogChannel createChannel(String string) {
        Log4jLogChannel log4jLogChannel = (Log4jLogChannel)this.logChannels.get(string);
        if (log4jLogChannel == null) {
            log4jLogChannel = new Log4jLogChannel(string, org.apache.log4j.Logger.getLogger((String)string));
            this.logChannels.put(string, log4jLogChannel);
        }
        return log4jLogChannel;
    }

    public LogChannel getChannel(String string) {
        Log4jLogChannel log4jLogChannel = (Log4jLogChannel)this.logChannels.get(string);
        if (log4jLogChannel == null) {
            log4jLogChannel = this.createChannel(string);
        }
        return log4jLogChannel;
    }

    private synchronized Integer createLevel(String string) {
        Integer n = (Integer)this.levelNumbers.get(string);
        if (n == null) {
            n = new Integer(this.numLevels);
            this.levelNames[this.numLevels] = string;
            this.levelNumbers.put(string, n);
            ++this.numLevels;
        }
        return n;
    }

    public synchronized int getLevel(String string) {
        Integer n = (Integer)this.levelNumbers.get(string);
        if (n == null) {
            n = this.createLevel(string);
        }
        return n;
    }

    public String getLevelName(int n) {
        if (n >= 0 && n < this.numLevels) {
            return this.levelNames[n];
        }
        return null;
    }

    public void configure(Config config) throws ConfigException {
        String string = null;
        if (config.containsKey("Log4j")) {
            string = config.getString("Log4j");
        } else if (null != config.getConfigFile()) {
            string = config.getConfigFile().getFile().getParent();
            if (null != string) {
                string = string + File.separator + "log4j.xml";
            }
        } else {
            throw new ConfigException("Cannot configure logger. Config file is null.");
        }
        if (config.containsKey("SeparatorLine")) {
            separatorLine = config.getString("SeparatorLine");
        }
        this.configure(string);
    }
}

