/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.logging.LogChannel;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public abstract class Resource {
    protected String name = null;
    protected ClassPathEntry location = null;
    protected long size = -1L;
    protected long lastModifiedTime = -1L;
    protected boolean loggingEnabled = false;
    protected LogChannel logChannel;
    protected int logLevel;

    protected Resource(String string, ClassPathEntry classPathEntry, LogChannel logChannel) throws NullPointerException {
        this.logChannel = logChannel;
        if (this.logChannel != null) {
            this.logLevel = this.logChannel.getLevel("CLASSLOAD");
            this.loggingEnabled = this.logChannel.isEnabled(this.logLevel);
        }
        if (string == null || classPathEntry == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.location = classPathEntry;
    }

    public String getName() {
        return this.name;
    }

    public ClassPathEntry getLocation() {
        return this.location;
    }

    public String toString() {
        return "[" + this.location + "][" + this.name + "]";
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getTime() {
        return this.lastModifiedTime;
    }

    public abstract long getCurrentLastModifiedTime() throws FileNotFoundException;

    public boolean hasBeenModified() throws FileNotFoundException {
        long l = this.getCurrentLastModifiedTime();
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "hasBeenModified: " + this.getName() + ": current time=" + l + ", last time=" + this.lastModifiedTime);
        }
        return l > this.lastModifiedTime;
    }

    private byte[] getBytesKnowSize(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[(int)this.size];
        int n2 = 0;
        while ((long)n2 < this.size && inputStream.available() != 0 && (n = inputStream.read(byArray, n2, (int)this.size - n2)) != -1) {
            n2 += n;
        }
        if ((long)n2 != this.size) {
            throw new IOException("Read of resource expected " + this.size + " bytes, got " + n2 + " bytes");
        }
        return byArray;
    }

    private byte[] getBytesUnknowSize(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[10240];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while (inputStream.available() != 0 && (n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            throw new IOException("Null InputStream for resource, " + this);
        }
        try {
            if (this.size < 0L) {
                byte[] byArray = this.getBytesUnknowSize(inputStream);
                return byArray;
            }
            byte[] byArray = this.getBytesKnowSize(inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public abstract InputStream getInputStream() throws IOException;

    public boolean equals(Resource resource) {
        return this.name.equals(resource.getName()) && this.location.equals(resource.getLocation()) && this.size == resource.getSize() && this.lastModifiedTime == resource.getLastModifiedTime();
    }
}

