/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RemoteZipResource
extends Resource {
    URL zipFileURL = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RemoteZipResource(String string, ClassPathEntry classPathEntry, LogChannel logChannel) throws FileNotFoundException {
        super(string, classPathEntry, logChannel);
        this.zipFileURL = classPathEntry.getURL();
        if (this.zipFileURL == null) {
            String string2 = "The URL for location, " + classPathEntry + ", is null";
            this.logChannel.write(this.logLevel, string2);
            throw new FileNotFoundException(string2);
        }
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = this.getZipInputStream();
            if (zipInputStream == null) {
                String string3 = "URL \"" + this.zipFileURL + "\" does not exist, " + "can not be reached, or is not a zip file; or the " + "resource \"" + string + "\" is not in the zip file";
                this.logChannel.write(this.logLevel, string3);
                throw new FileNotFoundException(string3);
            }
            Object var7_7 = null;
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                String string4 = iOException.toString() + ": URL zip file \"" + this.zipFileURL + "\" is corrupt or the connection died";
                this.logChannel.write(this.logLevel, string4);
                throw new FatalExceptionError(new IOException(string4));
            }
        }
        try {
            zipInputStream.close();
            return;
        }
        catch (IOException iOException) {
            String string5 = iOException.toString() + ": URL zip file \"" + this.zipFileURL + "\" is corrupt or the connection died";
            this.logChannel.write(this.logLevel, string5);
            throw new FatalExceptionError(new IOException(string5));
        }
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.getZipInputStream();
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "URL zip file \"" + this.zipFileURL + "\" has disappeared or can no longer be reached; or the " + "resource \"" + this.name + "\" is no longer in the zip file";
            this.logChannel.write(this.logLevel, string);
            throw new FatalExceptionError(new FileNotFoundException(string));
        }
    }

    private ZipInputStream getZipInputStream() throws FileNotFoundException {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(this.zipFileURL.openStream());
            while (zipInputStream.available() > 0) {
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null) {
                    this.logChannel.write(this.logLevel, "Null zip entry.");
                    throw new IOException();
                }
                if (zipEntry.getName().equals(this.name)) {
                    this.size = zipEntry.getSize();
                    this.lastModifiedTime = zipEntry.getTime();
                    return zipInputStream;
                }
                zipInputStream.closeEntry();
            }
        }
        catch (IOException iOException) {
            String string = "URL, " + this.zipFileURL + ", does not exist, " + "can not be reached, is not a zip file, or the resource, " + this.name + ", is not in the zip file";
            this.logChannel.write(this.logLevel, string);
            throw new FileNotFoundException(string);
        }
        return null;
    }

    public long getCurrentLastModifiedTime() {
        return -1L;
    }
}

