/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class RemoteDirResource
extends Resource {
    private URL url = null;

    private RemoteDirResource(String string, ClassPathEntry classPathEntry, LogChannel logChannel) throws FileNotFoundException {
        super(string, classPathEntry, logChannel);
        URLConnection uRLConnection;
        URL uRL = classPathEntry.getURL();
        if (uRL == null) {
            throw new FileNotFoundException("The URL for location, " + classPathEntry + ", is null");
        }
        try {
            this.url = new URL(uRL.toString() + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException("The URL can not be created from the name " + string + ", and location " + uRL + ": " + malformedURLException.getMessage());
        }
        try {
            uRLConnection = this.url.openConnection();
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("URL, " + this.url + ", does not exist or can not be reached");
        }
        this.size = uRLConnection.getContentLength();
        this.lastModifiedTime = uRLConnection.getLastModified();
    }

    public InputStream getInputStream() throws IOException {
        return this.url.openStream();
    }

    public long getCurrentLastModifiedTime() {
        return -1L;
    }
}

