/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPath;
import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiClassLoader
extends ClassLoader {
    private Hashtable loadedClasses = new Hashtable();
    private ClassPath classPath;
    public static final String LOG_LEVEL = "CLASSLOAD";
    private boolean loggingEnabled = false;
    private LogChannel logChannel;
    private int logLevel;
    private Vector filters = null;
    private ClassLoader parentClassLoader;
    private ClassLoader secondaryClassLoader;
    private static ClassLoader sysClassLoader;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static ClassLoader getSystemClassLoader() {
        return sysClassLoader;
    }

    public MultiClassLoader(ClassLoader classLoader, ClassLoader classLoader2, LogChannel logChannel) {
        this.classPath = new ClassPath(logChannel);
        this.setParent(classLoader);
        this.secondaryClassLoader = classLoader2;
        this.logChannel = logChannel;
        if (this.logChannel != null) {
            this.logLevel = this.logChannel.getLevel(LOG_LEVEL);
            this.loggingEnabled = this.logChannel.isEnabled(this.logLevel);
        }
    }

    public MultiClassLoader(LogChannel logChannel) {
        this(null, MultiClassLoader.getSystemClassLoader(), logChannel);
    }

    public MultiClassLoader(String string, LogChannel logChannel) {
        this(new String[]{string}, logChannel);
    }

    public MultiClassLoader(String[] stringArray, LogChannel logChannel) {
        this(logChannel);
        this.setClassPath(stringArray);
    }

    public MultiClassLoader(File file, LogChannel logChannel) {
        this(new File[]{file}, logChannel);
    }

    public MultiClassLoader(File[] fileArray, LogChannel logChannel) {
        this(logChannel);
        this.setClassPath(fileArray);
    }

    public MultiClassLoader(URL uRL, LogChannel logChannel) {
        this(new URL[]{uRL}, logChannel);
    }

    public MultiClassLoader(URL[] uRLArray, LogChannel logChannel) {
        this(logChannel);
        this.setClassPath(uRLArray);
    }

    public void setClassPath(String string) {
        this.setClassPath(new String[]{string});
    }

    public synchronized void setClassPath(String[] stringArray) {
        this.classPath.set(stringArray);
    }

    public void setClassPath(File file) {
        this.setClassPath(new File[]{file});
    }

    public synchronized void setClassPath(File[] fileArray) {
        this.classPath.set(fileArray);
    }

    public void setClassPath(URL uRL) {
        this.setClassPath(new URL[]{uRL});
    }

    public synchronized void setClassPath(URL[] uRLArray) {
        this.classPath.set(uRLArray);
    }

    public void addClassPath(String string) {
        this.addClassPath(new String[]{string});
    }

    public synchronized void addClassPath(String[] stringArray) {
        this.classPath.add(stringArray);
    }

    public void addClassPath(File file) {
        this.addClassPath(new File[]{file});
    }

    public synchronized void addClassPath(File[] fileArray) {
        this.classPath.add(fileArray);
    }

    public void addClassPath(URL uRL) {
        this.addClassPath(new URL[]{uRL});
    }

    public synchronized void addClassPath(URL[] uRLArray) {
        this.classPath.add(uRLArray);
    }

    public synchronized void clearClassPath() {
        this.classPath.clear();
    }

    public URL[] getClassPath() {
        int n = this.classPath.getLength();
        URL[] uRLArray = new URL[n];
        Enumeration enumeration = this.classPath.getPath();
        for (int i = 0; i < n; ++i) {
            ClassPathEntry classPathEntry = (ClassPathEntry)enumeration.nextElement();
            uRLArray[i] = classPathEntry.getURL();
        }
        return uRLArray;
    }

    public static String[] parseClassPath(String string) {
        String string2 = System.getProperty("path.separator");
        if (string2 == null) {
            throw new NullPointerException("path.separator property not defined");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static URL[] getSystemClassPath() {
        String string = System.getProperty("java.class.path");
        if (string == null) {
            string = "";
        }
        String[] stringArray = MultiClassLoader.parseClassPath(string);
        Vector<URL> vector = new Vector<URL>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                vector.addElement(new URL("file", "", stringArray[i]));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Object[] objectArray = new URL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setParent(ClassLoader classLoader) {
        this.parentClassLoader = null != classLoader ? classLoader : MultiClassLoader.getSystemClassLoader();
    }

    public ClassLoader getSecondary() {
        return this.secondaryClassLoader;
    }

    public void setSecondary(ClassLoader classLoader) {
        this.secondaryClassLoader = classLoader;
    }

    public LogChannel getLogChannel() {
        return this.logChannel;
    }

    public synchronized void addClassFilter(ClassFilter classFilter) {
        if (this.filters == null) {
            this.filters = new Vector();
        }
        this.filters.addElement(classFilter);
    }

    private int checkFilters(String string) {
        int n = 1;
        if (string.startsWith("java.lang.")) {
            n = 2;
        } else if (this.filters != null) {
            int n2 = this.filters.size();
            for (int i = 0; i < n2 && (n = ((ClassFilter)this.filters.elementAt(i)).loadCheck(string)) == 1; ++i) {
            }
        }
        if (n != 1 && this.loggingEnabled) {
            String string2 = "";
            switch (n) {
                case 2: {
                    string2 = "Filter disallows loading by this classloader: ";
                    break;
                }
                case 3: {
                    string2 = "Filter allows loading by this classloader: ";
                    break;
                }
                case 4: {
                    string2 = "Filter requires loading by this classloader: ";
                }
            }
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, string2 + string);
            }
        }
        return n;
    }

    private ClassResource checkForLoadedClass(String string) {
        ClassResource classResource = (ClassResource)this.loadedClasses.get(string);
        if (classResource != null && this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "loadClass already loaded: " + string);
        }
        return classResource;
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        return this.loadClassResource(string, bl).getClassObj();
    }

    private void logClassLoadFailure(String string, Throwable throwable) {
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "load of class failed: " + string, throwable);
        }
    }

    private void logReadFailure(String string, Throwable throwable) {
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "read of resource failed: " + string, throwable);
        }
    }

    private ClassResource loadClassResource(String string, boolean bl) throws ClassNotFoundException {
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "loadClass: " + string);
        }
        try {
            ClassResource classResource = this.checkForLoadedClass(string);
            if (classResource == null) {
                classResource = this.doLoadClass(string);
                if (bl) {
                    this.resolveClass(classResource.getClassObj());
                }
            }
            return classResource;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logClassLoadFailure(string, classNotFoundException);
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            this.logClassLoadFailure(string, iOException);
            throw new ClassNotFoundException(iOException.getClass().getName() + ": " + iOException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            this.logClassLoadFailure(string, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            this.logClassLoadFailure(string, error);
            throw error;
        }
    }

    public Resource getClassResource(String string) throws ClassNotFoundException {
        ClassResource classResource = this.checkForLoadedClass(string);
        if (classResource == null) {
            throw new ClassNotFoundException("Class \"" + string + "\" is not loaded by this class loader");
        }
        return classResource.getResource();
    }

    private ClassResource loadClassOther(String string, ClassLoader classLoader, String string2) {
        ClassResource classResource;
        block6: {
            classResource = null;
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "checking " + string2 + " class loader: " + string);
            }
            try {
                if (classLoader instanceof MultiClassLoader) {
                    classResource = ((MultiClassLoader)classLoader).loadClassResource(string, false);
                } else {
                    Class<?> clazz = classLoader.loadClass(string);
                    classResource = new ClassResource(clazz, null);
                }
                if (this.loggingEnabled) {
                    this.logChannel.write(this.logLevel, "class loaded by: " + string2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.loggingEnabled) break block6;
                this.logChannel.write(this.logLevel, "class not loaded by " + string2 + ": " + classNotFoundException.getClass().getName() + ": " + classNotFoundException.getMessage());
            }
        }
        return classResource;
    }

    private ClassResource loadClassHere(String string) throws IOException {
        String string2;
        Resource resource;
        ClassResource classResource = null;
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "checking MultiClassLoader: " + string);
        }
        if ((resource = this.getResourceObject(string2 = string.replace('.', '/').concat(".class"))) != null) {
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Class.forName(string, true, ClassLoader.getSystemClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    byte[] byArray = resource.getBytes();
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                }
            }
            classResource = new ClassResource(clazz, resource);
            this.loadedClasses.put(string, classResource);
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "class loaded by MultiClassLoader: " + string);
            }
        }
        if (classResource == null && this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "class not loaded by MultiClassLoader: " + string);
        }
        return classResource;
    }

    private synchronized ClassResource doLoadClass(String string) throws ClassNotFoundException, IOException {
        ClassResource classResource = this.checkForLoadedClass(string);
        if (classResource != null) {
            return classResource;
        }
        int n = this.checkFilters(string);
        if (this.parentClassLoader != null && n != 3 && n != 4 && (classResource = this.loadClassOther(string, this.parentClassLoader, "parent")) != null) {
            return classResource;
        }
        if ((n == 1 || n == 3 || n == 4) && (classResource = this.loadClassHere(string)) != null) {
            return classResource;
        }
        if (this.secondaryClassLoader != null && n != 4 && (classResource = this.loadClassOther(string, this.secondaryClassLoader, "secondary")) != null) {
            return classResource;
        }
        throw new ClassNotFoundException(string);
    }

    public URL getResource(String string) {
        Resource resource = this.getResourceObject(string);
        if (resource != null) {
            ClassPathEntry classPathEntry = resource.getLocation();
            try {
                return new URL(classPathEntry.getURL() + resource.getName());
            }
            catch (MalformedURLException malformedURLException) {
                if (this.loggingEnabled) {
                    this.logChannel.write(this.logLevel, "getResource not returned due to exception: " + string, (Throwable)malformedURLException);
                }
                return null;
            }
        }
        return null;
    }

    public Resource getResourceObject(String string) {
        Resource resource;
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "getResource loading: " + string);
        }
        try {
            resource = this.classPath.getResource(string);
            if (this.loggingEnabled) {
                if (resource == null) {
                    this.logChannel.write(this.logLevel, "getResource not found: " + string);
                } else {
                    this.logChannel.write(this.logLevel, "getResource finished: " + string);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.logReadFailure(string, runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            this.logReadFailure(string, error);
            throw error;
        }
        return resource;
    }

    public Resource getResourceAsIs(String string) {
        return this.getResourceObject(string);
    }

    public InputStream getResourceAsStream(String string) {
        Resource resource = this.getResourceObject(string);
        if (resource != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException iOException) {
                this.logReadFailure(string, iOException);
                return null;
            }
        }
        return null;
    }

    public byte[] getResourceAsByteArray(String string) {
        Resource resource = this.getResourceObject(string);
        if (resource != null) {
            try {
                return resource.getBytes();
            }
            catch (IOException iOException) {
                this.logReadFailure(string, iOException);
                return null;
            }
        }
        return null;
    }

    public boolean shouldReload() {
        Enumeration enumeration = this.loadedClasses.elements();
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "Checking for out-of-date classes");
        }
        while (enumeration.hasMoreElements()) {
            boolean bl;
            try {
                bl = ((ClassResource)enumeration.nextElement()).getResource().hasBeenModified();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.loggingEnabled) {
                    this.logChannel.write(this.logLevel, "File for loaded class can no longer be accessed", (Throwable)fileNotFoundException);
                }
                bl = true;
            }
            if (!bl) continue;
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "Loaded classes have been modified");
            }
            return true;
        }
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "Loaded classes have not been modified");
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Method method = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MultiClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getMethod("getSystemClassLoader", new Class[0]);
            sysClassLoader = (ClassLoader)method.invoke((Object)(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = MultiClassLoader.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader), new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            sysClassLoader = new SysClassLoader();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new FatalExceptionError(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FatalExceptionError(illegalAccessException);
        }
    }

    static class SysClassLoader
    extends ClassLoader {
        SysClassLoader() {
        }

        public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
            Class<?> clazz = this.findSystemClass(string);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        public URL getResource(String string) {
            return SysClassLoader.getSystemResource(string);
        }

        public InputStream getResourceAsStream(String string) {
            return SysClassLoader.getSystemResourceAsStream(string);
        }
    }

    public class ClassResource {
        private Class classObj;
        private Resource resource;

        public ClassResource(Class clazz, Resource resource) {
            this.classObj = clazz;
            this.resource = resource;
        }

        public Class getClassObj() {
            return this.classObj;
        }

        public Resource getResource() {
            return this.resource;
        }
    }

    public static interface ClassFilter {
        public static final int NORMAL_LOAD = 1;
        public static final int DONT_LOAD = 2;
        public static final int CAN_LOAD = 3;
        public static final int MUST_LOAD = 4;

        public int loadCheck(String var1);
    }
}

