/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LocalZipResource
extends Resource {
    private ZipEntry zipEntry = null;

    protected LocalZipResource(String string, ClassPathEntry classPathEntry, LogChannel logChannel) throws FileNotFoundException {
        super(string, classPathEntry, logChannel);
        ZipFile zipFile = classPathEntry.getZipFile();
        if (zipFile == null) {
            throw new FileNotFoundException("There is no zip file associated with resource: " + classPathEntry);
        }
        try {
            this.zipEntry = zipFile.getEntry(string);
            if (this.zipEntry == null) {
                throw new FileNotFoundException("Entry, " + string + ", does not exist in zip " + "file, " + zipFile);
            }
            this.size = this.zipEntry.getSize();
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Entry, " + string + ", does not exist in zip file, " + zipFile + ", or is " + "corrupt: " + iOException.getMessage());
        }
    }

    public InputStream getInputStream() throws IOException {
        ZipFile zipFile = this.location.getZipFile();
        if (zipFile == null) {
            throw new FatalExceptionError(new IOException("Failed to get zip file for location, should not be able to get here without a zip file"));
        }
        return zipFile.getInputStream(this.zipEntry);
    }

    public long getCurrentLastModifiedTime() throws FileNotFoundException {
        this.lastModifiedTime = this.zipEntry.getTime();
        return this.lastModifiedTime;
    }
}

