/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class LocalDirResource
extends Resource {
    private File file = null;

    protected LocalDirResource(String string, ClassPathEntry classPathEntry, LogChannel logChannel) throws FileNotFoundException {
        super(string, classPathEntry, logChannel);
        String string2 = classPathEntry.getName();
        if (string2 == null) {
            throw new FileNotFoundException("The name for location, " + classPathEntry + ", is null");
        }
        this.file = new File(string2, string);
        if (!this.file.exists() || !this.file.canRead()) {
            File file = this.file;
            this.file = null;
            throw new FileNotFoundException("File, " + file.getAbsolutePath() + ", does not exist or does not " + "have read permission");
        }
        String string3 = null;
        String string4 = null;
        try {
            string4 = new File(string2).getCanonicalPath();
        }
        catch (IOException iOException) {
            this.file = null;
            throw new FileNotFoundException("Classpath Directory " + string2 + " cannot be resolved: " + iOException.toString());
        }
        try {
            string3 = this.file.getCanonicalPath();
        }
        catch (IOException iOException) {
            File file = this.file;
            this.file = null;
            throw new FileNotFoundException("File " + file.getAbsolutePath() + " cannot be resolved: " + iOException.toString());
        }
        if (!string3.startsWith(string4)) {
            File file = this.file;
            this.file = null;
            throw new FileNotFoundException("File, " + file + " does not live under " + string2);
        }
        this.size = this.file.length();
        this.lastModifiedTime = this.file.lastModified();
    }

    public InputStream getInputStream() throws IOException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FatalExceptionError(fileNotFoundException);
        }
    }

    public long getCurrentLastModifiedTime() throws FileNotFoundException {
        return this.file.lastModified();
    }

    public File getFile() {
        return this.file;
    }
}

