/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.LocalDirResource;
import com.lutris.classloader.LocalZipResource;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipFile;

public class ClassPathEntry {
    private URL entryURL = null;
    private ZipFile zipFile = null;
    private boolean loggingEnabled = false;
    private LogChannel logChannel;
    private int logLevel;
    private boolean isZipFile;

    public ClassPathEntry(String string, LogChannel logChannel) {
        this(ClassPathEntry.convertEntryToURL(string), logChannel);
    }

    public ClassPathEntry(File file, LogChannel logChannel) {
        this(ClassPathEntry.convertEntryToURL(file), logChannel);
    }

    public ClassPathEntry(URL uRL, LogChannel logChannel) {
        try {
            this.logChannel = logChannel;
            if (this.logChannel != null) {
                this.logLevel = this.logChannel.getLevel("CLASSLOAD");
                this.loggingEnabled = this.logChannel.isEnabled(this.logLevel);
            }
            this.entryURL = new URL(ClassPathEntry.cleanUpURL(uRL).toString());
        }
        catch (MalformedURLException malformedURLException) {
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "Illegal class path entry: " + uRL);
            }
            this.entryURL = null;
        }
        this.initIsZipFile();
    }

    public URL getURL() {
        return this.entryURL;
    }

    public String getName() {
        return this.entryURL.getFile();
    }

    public String getLocation() {
        if (this.entryURL.getPort() != -1) {
            return this.entryURL.getProtocol() + "://" + this.entryURL.getHost() + ":" + this.entryURL.getPort() + "/";
        }
        return this.entryURL.getProtocol() + "://" + this.entryURL.getHost() + "/";
    }

    public String toString() {
        if (this.entryURL != null) {
            return this.entryURL.toString();
        }
        return "null";
    }

    public Resource getResource(String string) {
        string = ClassPathEntry.convertSlashes(string);
        Resource resource = null;
        try {
            if (this.isDirectory() && this.isLocal()) {
                resource = new LocalDirResource(string, this, this.logChannel);
            } else if (this.isZipFile() && this.isLocal()) {
                resource = new LocalZipResource(string, this, this.logChannel);
            } else if (this.isDirectory() && this.isRemote()) {
                if (this.loggingEnabled) {
                    this.logChannel.write(this.logLevel, "Cannot get remote directory resource.");
                }
                resource = null;
            } else if (this.isZipFile() && this.isRemote()) {
                if (this.loggingEnabled) {
                    this.logChannel.write(this.logLevel, "Cannot get remote jar file resource.");
                }
                resource = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "File not found: " + string + ": " + fileNotFoundException.getClass().getName() + ": " + fileNotFoundException.getMessage());
            }
            resource = null;
        }
        return resource;
    }

    public boolean isZipFile() {
        return this.isZipFile;
    }

    private void initIsZipFile() {
        this.isZipFile = this.toString().endsWith(".jar") || this.toString().endsWith(".zip");
    }

    public boolean isDirectory() {
        return !this.isZipFile();
    }

    public boolean isLocal() {
        String string = this.entryURL.getHost();
        return string.equals("") || string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1");
    }

    public boolean isRemote() {
        return !this.isLocal();
    }

    public boolean equals(Object object) {
        if (object instanceof ClassPathEntry) {
            return this.entryURL.equals(((ClassPathEntry)object).getURL());
        }
        return false;
    }

    public ZipFile getZipFile() {
        if (this.zipFile == null) {
            return this.doGetZipFile();
        }
        return this.zipFile;
    }

    private synchronized ZipFile doGetZipFile() {
        if (this.zipFile == null) {
            if (this.isZipFile() && this.isLocal()) {
                try {
                    this.zipFile = new ZipFile(this.getName());
                }
                catch (IOException iOException) {
                    if (this.loggingEnabled) {
                        this.logChannel.write(this.logLevel, "Cannot create zip file " + this.getName() + ".", (Throwable)iOException);
                    }
                    this.zipFile = null;
                }
            } else {
                this.zipFile = null;
            }
        }
        return this.zipFile;
    }

    private static URL cleanUpURL(URL uRL) {
        URL uRL2 = null;
        try {
            String string = uRL.toString();
            uRL2 = !(string.endsWith("/") || string.endsWith(".jar") || string.endsWith(".zip")) ? new URL(ClassPathEntry.convertSlashes(uRL.toString() + "/")) : new URL(ClassPathEntry.convertSlashes(uRL.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = null;
        }
        return uRL2;
    }

    private static URL convertEntryToURL(Object object) {
        if (object instanceof URL) {
            return (URL)object;
        }
        if (object instanceof String) {
            return ClassPathEntry.convertEntryToURL((String)object);
        }
        if (object instanceof File) {
            return ClassPathEntry.convertEntryToURL(object.toString());
        }
        return null;
    }

    private static URL convertEntryToURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                String string2 = new File(string).getAbsolutePath();
                string2 = string2.replace(File.separatorChar, '/');
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                return new URL("file://" + string2);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static String convertSlashes(String string) {
        string.replace(File.separatorChar, '/');
        return string.replace('\\', '/');
    }
}

