/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

class ClassPath {
    private Vector classPath = new Vector();
    private boolean loggingEnabled = false;
    private LogChannel logChannel;
    private int logLevel;

    public ClassPath(LogChannel logChannel) {
        this((Vector)null, logChannel);
    }

    public ClassPath(String[] stringArray, LogChannel logChannel) {
        this(ClassPath.convertArrayToVector(stringArray, logChannel), logChannel);
    }

    public ClassPath(File[] fileArray, LogChannel logChannel) {
        this(ClassPath.convertArrayToVector(fileArray, logChannel), logChannel);
    }

    public ClassPath(URL[] uRLArray, LogChannel logChannel) {
        this(ClassPath.convertArrayToVector(uRLArray, logChannel), logChannel);
    }

    private ClassPath(Vector vector, LogChannel logChannel) {
        this.set(vector);
        this.logChannel = logChannel;
        if (this.logChannel != null) {
            this.logLevel = this.logChannel.getLevel("CLASSLOAD");
            this.loggingEnabled = this.logChannel.isEnabled(this.logLevel);
        }
    }

    public void set(String[] stringArray) {
        this.set(ClassPath.convertArrayToVector(stringArray, this.logChannel));
    }

    public void set(File[] fileArray) {
        this.set(ClassPath.convertArrayToVector(fileArray, this.logChannel));
    }

    public void set(URL[] uRLArray) {
        this.set(ClassPath.convertArrayToVector(uRLArray, this.logChannel));
    }

    public void add(String[] stringArray) {
        this.add(ClassPath.convertArrayToVector(stringArray, this.logChannel));
    }

    public void add(File[] fileArray) {
        this.add(ClassPath.convertArrayToVector(fileArray, this.logChannel));
    }

    public void add(URL[] uRLArray) {
        this.add(ClassPath.convertArrayToVector(uRLArray, this.logChannel));
    }

    public void clear() {
        this.classPath.removeAllElements();
    }

    public int getLength() {
        return this.classPath.size();
    }

    public Enumeration getPath() {
        return this.classPath.elements();
    }

    public Resource getResource(String string) {
        if (string == null) {
            throw new NullPointerException("Null resource name passed to getResource() for class path, " + this);
        }
        Resource resource = null;
        for (int i = 0; i < this.classPath.size(); ++i) {
            ClassPathEntry classPathEntry = null;
            classPathEntry = (ClassPathEntry)this.classPath.elementAt(i);
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "  checking: \"" + classPathEntry.getName() + "\"");
            }
            if ((resource = classPathEntry.getResource(string)) == null) continue;
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "  found: " + string);
            }
            return resource;
        }
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "  not found: " + string);
        }
        return null;
    }

    private void set(Vector vector) {
        this.classPath.removeAllElements();
        this.add(vector);
    }

    private void add(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.classPath.insertElementAt(vector.elementAt(i), i);
            }
        }
    }

    private static Vector convertArrayToVector(Object[] objectArray, LogChannel logChannel) {
        if (objectArray != null) {
            Vector<ClassPathEntry> vector = new Vector<ClassPathEntry>();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                ClassPathEntry classPathEntry = null;
                if (object instanceof String) {
                    classPathEntry = new ClassPathEntry((String)object, logChannel);
                } else if (object instanceof File) {
                    classPathEntry = new ClassPathEntry((File)object, logChannel);
                } else if (object instanceof URL) {
                    classPathEntry = new ClassPathEntry((URL)object, logChannel);
                } else {
                    throw new FatalExceptionError(new ClassCastException("Type, " + object.getClass() + ", is not supported. " + "Expecting a String, File, or URL."));
                }
                if (classPathEntry == null || vector.contains(classPathEntry)) continue;
                vector.addElement(classPathEntry);
            }
            return vector;
        }
        return null;
    }
}

