/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.standard;

import com.lutris.appserver.server.sql.ConnectionAllocator;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.ExtendedConnectionAllocator;
import com.lutris.appserver.server.sql.ExtendedDBConnection;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import org.enhydra.dods.Common;
import org.enhydra.dods.DODS;

public class StandardDBConnection
implements ExtendedDBConnection {
    protected Connection connection;
    protected String url;
    protected String user;
    protected String password;
    protected int id = nextId++;
    protected static int nextId = 0;
    protected Hashtable preparedStmtCache = new Hashtable();
    protected Statement currentStmt = null;
    protected ConnectionAllocator connectionAllocator;
    protected boolean logging;
    protected int generation;
    protected boolean closed = false;
    protected boolean dropConnection = false;
    protected boolean dropped = false;
    protected boolean reset = true;
    protected boolean allocated = false;
    protected int maxPreparedStmts;
    protected int connectionUsageCounter = 0;
    protected long connectionEnterPoolTime = -1L;
    public long curtime = 0L;

    public StandardDBConnection(ConnectionAllocator connectionAllocatorObj, String url, String user, String password, int maxPreparedStatements, boolean logging, int generation) throws SQLException {
        this.connectionAllocator = connectionAllocatorObj;
        this.url = url;
        this.user = user;
        this.password = password;
        this.logging = logging;
        this.generation = generation;
        this.connection = DriverManager.getConnection(url, user, password);
        this.currentStmt = this.connection.createStatement();
        if (maxPreparedStatements < 0) {
            this.maxPreparedStmts = this.connection.getMetaData().getMaxStatements() - 1;
            if (this.maxPreparedStmts == 0) {
                this.maxPreparedStmts = 1;
            }
            if (this.maxPreparedStmts < 0) {
                this.maxPreparedStmts = 256;
            }
        } else {
            this.maxPreparedStmts = maxPreparedStatements;
        }
        this.logDebug("DBConnection[" + this.id + "]: " + url + "\nNew connection allocated.\n");
        this.connectionEnterPoolTime = System.currentTimeMillis();
    }

    public synchronized void allocate() throws SQLException {
        this.logDebug("allocate");
        try {
            this.closedCheck();
            this.reset();
        }
        catch (SQLException e) {
            this.handleException(e);
            if (this.dropConnection) {
                this.drop();
            } else {
                this.release();
            }
            throw e;
        }
        this.reset = false;
        this.allocated = true;
    }

    protected void resetCheck() throws SQLException {
        this.logDebug("resetCheck()");
        if (!this.reset) {
            throw new SQLException("DBConnection.reset() was not called after the previous operation completed");
        }
    }

    protected void allocatedCheck() throws SQLException {
        this.logDebug("allocatedCheck()");
        if (!this.allocated) {
            throw new SQLException("attempt to access connection which was released.");
        }
    }

    protected void closedCheck() throws SQLException {
        this.logDebug("closedCheck()");
        if (this.closed || this.getConnection().isClosed()) {
            throw new SQLException("attempt to access a closed connection.");
        }
    }

    public void validate() throws SQLException {
        this.logDebug("validate()");
        this.allocatedCheck();
        this.closedCheck();
    }

    public synchronized void reset() throws SQLException {
        SQLException saveExcept;
        block7: {
            block6: {
                saveExcept = null;
                if (this.reset) {
                    return;
                }
                this.logDebug("reset");
                try {
                    this.connection.clearWarnings();
                }
                catch (SQLException except) {
                    if (saveExcept != null) break block6;
                    saveExcept = except;
                }
            }
            try {
                this.connection.setAutoCommit(false);
            }
            catch (SQLException except) {
                if (saveExcept != null) break block7;
                saveExcept = except;
            }
        }
        this.reset = true;
        if (saveExcept != null) {
            throw saveExcept;
        }
    }

    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        return this._prepareStatement(sql, -100, -100, false);
    }

    private synchronized PreparedStatement _prepareStatement(String sql, int iResultSetType, int iResultSetConcurrency, boolean tuned) throws SQLException {
        PreparedStatement preparedStmt = null;
        String mapKey = sql + "=+=+" + iResultSetType + "=+=+" + iResultSetConcurrency + "=+=+";
        if (tuned) {
            mapKey = mapKey + "tuned";
        }
        this.logDebug("Prepare statement: " + sql);
        this.validate();
        boolean selectQuery = sql.trim().toLowerCase().startsWith("select");
        if (this.maxPreparedStmts > 0 && !selectQuery) {
            preparedStmt = (PreparedStatement)this.preparedStmtCache.get(mapKey);
            if (preparedStmt != null && !preparedStmt.getConnection().isClosed()) {
                preparedStmt.clearParameters();
            } else {
                if (this.preparedStmtCache.size() >= this.maxPreparedStmts) {
                    String key = (String)this.preparedStmtCache.keys().nextElement();
                    ((PreparedStatement)this.preparedStmtCache.remove(key)).close();
                }
                preparedStmt = this.getNewPrepStatemet(sql, iResultSetType, iResultSetConcurrency, tuned);
                this.preparedStmtCache.put(mapKey, preparedStmt);
            }
        } else {
            preparedStmt = this.getNewPrepStatemet(sql, iResultSetType, iResultSetConcurrency, tuned);
        }
        return preparedStmt;
    }

    private PreparedStatement getNewPrepStatemet(String sql, int iResultSetType, int iResultSetConcurrency, boolean tuned) throws SQLException {
        PreparedStatement preparedStmt = !tuned ? (this.getResultSetType() == -1 || this.getResultSetConcurrency() == -1 ? this.connection.prepareStatement(sql) : this.connection.prepareStatement(sql, this.getResultSetType(), this.getResultSetConcurrency())) : this.connection.prepareStatement(sql, iResultSetType, iResultSetConcurrency);
        return preparedStmt;
    }

    public synchronized PreparedStatement prepareStatement(String sql, int iResultSetType, int iResultSetConcurrency) throws SQLException {
        return this._prepareStatement(sql, iResultSetType, iResultSetConcurrency, true);
    }

    protected int getResultSetType() {
        int resultSetType;
        try {
            resultSetType = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getResultSetType();
        }
        catch (DatabaseManagerException e) {
            DODS.getLogChannel().write(7, "Error unknown logical database. Using default value for 'resultSetType' parameter");
            resultSetType = -1;
        }
        return resultSetType;
    }

    protected int getResultSetConcurrency() {
        int resultSetConcurrency;
        try {
            resultSetConcurrency = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getResultSetConcurrency();
        }
        catch (DatabaseManagerException e) {
            DODS.getLogChannel().write(7, "Error unknown logical database. Using default value for 'resultSetConcurrency' parameter");
            resultSetConcurrency = -1;
        }
        return resultSetConcurrency;
    }

    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    public synchronized ResultSet executeQuery(PreparedStatement preparedStmt, String msg) throws SQLException {
        this.logDebug("Execute prepared statement: " + msg, preparedStmt);
        this.validate();
        return preparedStmt.executeQuery();
    }

    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        this.logDebug(sql);
        this.validate();
        return this.currentStmt.executeQuery(sql);
    }

    public synchronized int executeUpdate(String sql) throws SQLException {
        this.logDebug(sql);
        this.validate();
        return this.currentStmt.executeUpdate(sql);
    }

    public int executeUpdate(PreparedStatement preparedStmt, String msg) throws SQLException {
        this.logDebug("Execute prepared statement: " + msg, preparedStmt);
        this.validate();
        return preparedStmt.executeUpdate();
    }

    public synchronized boolean execute(String sql) throws SQLException {
        this.logDebug("execute: " + sql);
        this.validate();
        return this.currentStmt.execute(sql);
    }

    public void warningCheck(ResultSet resultSet) throws SQLException {
        this.logDebug("warningCheck()");
        SQLWarning warning = resultSet.getWarnings();
        if (warning != null) {
            throw warning;
        }
    }

    public synchronized void release() {
        if (this.allocated) {
            this.logDebug("release");
            this.allocated = false;
            if (this.dropConnection) {
                this.drop();
            }
            if (!this.dropped) {
                this.connectionAllocator.release((DBConnection)this);
            }
        }
    }

    protected synchronized void drop() {
        if (!this.dropped) {
            this.close();
            this.logDebug("drop");
            this.connectionAllocator.drop((DBConnection)this);
            this.dropped = true;
            this.logDebug("DBConnection[" + this.id + "]: " + this.url + "Connection has been dropped from the connection allocator.");
        }
    }

    public synchronized boolean handleException(SQLException sqlExcept) {
        String sqlState = sqlExcept.getSQLState();
        this.logDebug("handleException: " + sqlExcept.getMessage());
        if (sqlExcept.getErrorCode() != 11111111) {
            if (!this.dropConnection) {
                this.logDebug("DBConnection[" + this.id + "]: " + this.url + "\nScheduled to be dropped from connection allocator." + "\nUnable to handle exception: \"" + sqlExcept.toString() + " \nErrorCode : " + sqlExcept.getErrorCode() + " \nSQLState : " + sqlExcept.getSQLState() + "\"\n");
                this.dropConnection = true;
            }
            return false;
        }
        return true;
    }

    public int getGeneration() {
        return this.generation;
    }

    public synchronized void close() {
        if (!this.closed) {
            this.logDebug("close");
            boolean closeStmts = true;
            Enumeration e = this.preparedStmtCache.keys();
            while (e.hasMoreElements() && closeStmts) {
                String key = (String)e.nextElement();
                try {
                    ((PreparedStatement)this.preparedStmtCache.remove(key)).close();
                }
                catch (SQLException except) {
                    closeStmts = false;
                    this.logDebug("DBConnection[" + this.id + "]: " + this.url + "\nUnable to close statements.  Continuing....\n");
                }
            }
            if (closeStmts) {
                try {
                    if (this.currentStmt != null) {
                        this.currentStmt.close();
                    }
                }
                catch (Exception except) {
                    closeStmts = false;
                }
                this.currentStmt = null;
            }
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logDebug("DBConnection[" + this.id + "]: " + this.url + "\nConnection has been closed.\n");
        }
        this.closed = true;
        this.connection = null;
    }

    public void setAutoCommit(boolean on) throws SQLException {
        this.validate();
        if (Common.isChangeAutocommitEnabled((String)this.getDatabaseName())) {
            this.logDebug("set autocommit: " + on);
            this.connection.setAutoCommit(on);
        } else {
            this.logDebug("set autocommit is disabled, can't change to value :" + on);
        }
    }

    public void commit() throws SQLException {
        this.validate();
        this.logDebug("commit");
        this.connection.commit();
    }

    public void rollback() throws SQLException {
        this.validate();
        this.logDebug("rollback");
        this.connection.rollback();
    }

    protected void logDebug(String str) {
        if (this.logging) {
            DODS.getLogChannel().write(7, "\nDBConnection[" + this.id + "]:" + str + "\n");
        }
    }

    protected void logDebug(String str, Statement stmt) {
        if (this.logging) {
            DODS.getLogChannel().write(7, "\nDBConnection[" + this.id + "]:" + str + "\n" + "SQL: " + stmt.toString());
        }
    }

    public void incrRequestCount() {
        ((ExtendedConnectionAllocator)this.connectionAllocator).IncrementRequesteCount();
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isMarkedForDrop() {
        return this.dropConnection;
    }

    public String getDatabaseName() {
        return this.connectionAllocator.getDatabaseName();
    }

    public int getConnectionUsageCounter() {
        return this.connectionUsageCounter;
    }

    public void setConnectionUsageCounter(int i) {
        this.connectionUsageCounter = i;
    }

    public boolean isDroped() {
        return this.dropped;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setConnectionEnterPoolTime(long i) {
        this.connectionEnterPoolTime = i;
    }

    public long getConnectionEnterPoolTime() {
        return this.connectionEnterPoolTime;
    }

    public int getMaxPreparedStmts() {
        return this.maxPreparedStmts;
    }
}

