/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.standard;

import com.lutris.appserver.server.sql.AbstractDBConnectionFactory;
import com.lutris.appserver.server.sql.ConnectionAllocator;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.ExtendedConnectionAllocator;
import com.lutris.appserver.server.sql.ExtendedDBConnection;
import com.lutris.appserver.server.sql.LogicalDatabase;
import com.lutris.appserver.server.sql.StandardDBConnectionFactory;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.KeywordValueException;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.enhydra.dods.DODS;

public class StandardConnectionAllocator
implements ExtendedConnectionAllocator {
    protected LogicalDatabase logicalDatabase = null;
    protected String url;
    protected String user;
    protected String password;
    protected String shutDownStr;
    private int maxPoolSize;
    private int currentPoolSize;
    private int biggestPoolSize;
    private Date biggestPoolDate;
    protected long numRequests;
    private ConnectionPool allocatePool;
    private long connectionIdileTimeout = -1L;
    private ConnectionPool releasePool;
    private int requestCounter = 0;
    private int waitCounter = 0;
    private CountMonitor waitConnectionMonitor;
    private Object allocateMonitor;
    private Object releaseMonitor;
    protected int maxWaitingConnections;
    protected int initWaitingConnections;
    private int maxConnectionUsages = -1;
    protected boolean sqlLogging;
    private int timeOut;
    protected int queryTimeOut;
    protected int transactionTimeOut;
    protected int maxPreparedStatements;
    protected int generation = 1;
    private AbstractDBConnectionFactory dbConnectionFactory = null;
    private String dbConnectionFactoryName = null;

    private AbstractDBConnectionFactory createDBConnectionFactory(String factoryName) {
        Class<?> connectionFactoryClass = null;
        Object connectionFactoryConstructor = null;
        Class[] methodTypes = new Class[]{};
        Object[] methodArgs = new Object[]{};
        StandardDBConnectionFactory factory = null;
        if (factoryName != null) {
            try {
                connectionFactoryClass = Class.forName(factoryName);
                factory = (AbstractDBConnectionFactory)connectionFactoryClass.newInstance();
            }
            catch (Exception e) {
                DODS.getLogChannel().write(6, "Faild to make Connection Factory :" + factoryName + " creating StandardDBConnectionFactory insted");
                factory = null;
            }
        }
        if (factoryName == null || factory == null) {
            factory = new StandardDBConnectionFactory();
        }
        return factory;
    }

    protected DBConnection createConnection() throws SQLException {
        DBConnection dbConnection = this.dbConnectionFactory.createConnection((ConnectionAllocator)this, this.url, this.user, this.password, this.maxPreparedStatements, this.sqlLogging, this.generation);
        return dbConnection;
    }

    public StandardConnectionAllocator(LogicalDatabase logicalDatabase, Config conConfig) throws ConfigException {
        this.logicalDatabase = logicalDatabase;
        try {
            this.url = conConfig.getString("Url");
            this.user = conConfig.getString("User");
            this.password = conConfig.getString("Password");
            this.timeOut = conConfig.getInt("AllocationTimeout", 1000);
            this.maxPoolSize = conConfig.getInt("MaxPoolSize", 0);
            this.sqlLogging = conConfig.getBoolean("Logging", false);
            this.queryTimeOut = conConfig.getInt("QueryTimeout", 0);
            this.shutDownStr = conConfig.getString("ShutDownString", null);
            this.transactionTimeOut = conConfig.getInt("TransactionTimeout", 0);
            this.maxPreparedStatements = conConfig.getInt("MaxPreparedStatements", -1);
            this.maxConnectionUsages = conConfig.getInt("MaxConnectionUsages", -1);
            this.maxWaitingConnections = conConfig.getInt("MaxWaitingConnections", Integer.MAX_VALUE);
            this.initWaitingConnections = conConfig.getInt("InitConnectionsPoolSize", -1);
            this.connectionIdileTimeout = conConfig.getLong("ConnectionIdleTimeout", -1L);
            this.dbConnectionFactoryName = conConfig.getString("ConnectionFactory", null);
            this.dbConnectionFactory = this.createDBConnectionFactory(this.dbConnectionFactoryName);
        }
        catch (KeywordValueException except) {
            throw new ConfigException("Bad DatabaseManager.DB." + logicalDatabase.getName() + ".Connection section defined in config file.");
        }
        this.currentPoolSize = 0;
        this.allocatePool = new ConnectionPool();
        this.releasePool = new ConnectionPool();
        this.waitConnectionMonitor = new CountMonitor(this.maxPoolSize);
        this.allocateMonitor = new Object();
        this.releaseMonitor = new Object();
        this.biggestPoolSize = 0;
        this.biggestPoolDate = new Date();
        this.numRequests = 0L;
        try {
            this.initConnectionPool(this.initWaitingConnections);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void initConnectionPool(int initWaitingConnections) throws SQLException {
        if (initWaitingConnections > this.maxPoolSize) {
            initWaitingConnections = this.maxPoolSize;
        }
        if (initWaitingConnections > 0) {
            for (int i = 1; i <= initWaitingConnections; ++i) {
                DBConnection newConnection = this.createConnection();
                if (newConnection.getConnection().isClosed()) continue;
                if (this.maxConnectionUsages > 0) {
                    ((ExtendedDBConnection)newConnection).setConnectionUsageCounter(this.maxConnectionUsages);
                } else {
                    ((ExtendedDBConnection)newConnection).setConnectionUsageCounter(Integer.MAX_VALUE);
                }
                this.allocatePool.pool.addLast(newConnection);
                ++this.currentPoolSize;
                this.waitConnectionMonitor.countNotify(initWaitingConnections);
                if (this.currentPoolSize <= this.biggestPoolSize) continue;
                this.biggestPoolSize = this.currentPoolSize;
                this.biggestPoolDate = new Date();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBConnection allocate() throws SQLException {
        boolean createNewConn = true;
        boolean connected = false;
        ExtendedDBConnection conn = null;
        long enterWaitTime = 0L;
        long timeToWait = -1L;
        boolean newConn = false;
        if (this.timeOut > 0) {
            timeToWait = this.timeOut;
        }
        while (conn == null) {
            connected = false;
            newConn = false;
            Object object = this.allocateMonitor;
            synchronized (object) {
                if (this.allocatePool.pool.isEmpty()) {
                    this.switchPools();
                }
                if (this.allocatePool.pool.isEmpty() && createNewConn && (this.currentPoolSize < this.maxPoolSize || this.maxPoolSize <= 0)) {
                    try {
                        conn = this.createConnection();
                        if (this.maxConnectionUsages > 0) {
                            conn.setConnectionUsageCounter(this.maxConnectionUsages);
                        } else {
                            conn.setConnectionUsageCounter(Integer.MAX_VALUE);
                        }
                        ++this.currentPoolSize;
                        newConn = true;
                        if (this.currentPoolSize > this.biggestPoolSize) {
                            this.biggestPoolSize = this.currentPoolSize;
                            this.biggestPoolDate = new Date();
                        }
                    }
                    catch (SQLException e) {
                        conn = null;
                        if (this.currentPoolSize > 0) {
                            DODS.getLogChannel().write(6, "ConnectionAllocator: failed to allocate a new connection due to" + e.toString() + "Error code: " + e.getErrorCode() + "\n" + "SQLState: " + e.getSQLState() + "\n" + "\nCurrent pool size is: " + this.currentPoolSize + "\nMaximum configured pool size is now " + this.maxPoolSize + "\nContinuing...\n");
                            createNewConn = false;
                        }
                        DODS.getLogChannel().write(0, "ConnectionAllocator: failed to allocate a new connection\nThe connection pool is empty!\n" + e.toString() + "Error code: " + e.getErrorCode() + "\n" + "SQLState: " + e.getSQLState() + "\n" + "\nCurrent pool size is: " + this.currentPoolSize + "\nMaximum configured pool size is now " + this.maxPoolSize + "\nContinuing...\n");
                        throw e;
                    }
                }
                try {
                    if (conn == null) {
                        conn = (ExtendedDBConnection)this.allocatePool.pool.removeFirst();
                    }
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                if (conn != null) {
                    connected = true;
                    if (this.maxConnectionUsages > 0) {
                        int connUsages = conn.getConnectionUsageCounter();
                        if (connUsages > 0) {
                            conn.setConnectionUsageCounter(--connUsages);
                        } else {
                            conn.close();
                            --this.currentPoolSize;
                            DODS.getLogChannel().write(7, "ConnectionAllocator: connection closed due to usage counter. currentPoolSize=" + this.currentPoolSize + "\n");
                            conn = null;
                        }
                    }
                    if (conn != null && (conn.isDroped() || conn.getConnection().isClosed() || conn.getGeneration() < this.generation || conn.isMarkedForDrop())) {
                        conn.close();
                        --this.currentPoolSize;
                        DODS.getLogChannel().write(7, "ConnectionAllocator: Inactiv connection closed due allocate() operation. Geting new one. currentPoolSize=" + this.currentPoolSize + "\n");
                        conn = null;
                    }
                    if (conn != null && this.connectionIdileTimeout > 0L && System.currentTimeMillis() - conn.getConnectionEnterPoolTime() > this.connectionIdileTimeout) {
                        conn.close();
                        --this.currentPoolSize;
                        DODS.getLogChannel().write(7, "ConnectionAllocator: Connection closed due allocate() operation - long connection idile time. Geting new one. currentPoolSize=" + this.currentPoolSize + "\n");
                        conn = null;
                    }
                }
            }
            if (conn != null) continue;
            try {
                if (timeToWait == 0L) {
                    DODS.getLogChannel().write(0, "ConnectionAllocator:allocation of a new connection timed out.Possible dead lock avoided.");
                    String msg = "Connections are currently unavailable.\nPossible dead lock avoided.";
                    throw new SQLException(msg);
                }
                if (timeToWait > 0L) {
                    timeToWait = this.waitConnectionMonitor.countWait(timeToWait);
                    continue;
                }
                this.waitConnectionMonitor.countWait();
            }
            catch (InterruptedException intEx) {}
        }
        conn.allocate();
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchPools() {
        Object object = this.releaseMonitor;
        synchronized (object) {
            if (this.releasePool.pool.size() > this.allocatePool.pool.size()) {
                LinkedList tmp = this.allocatePool.pool;
                this.allocatePool.pool = this.releasePool.pool;
                this.releasePool.pool = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(DBConnection dbConnection) {
        if (dbConnection != null) {
            int releaseSize = 0;
            Object object = this.releaseMonitor;
            synchronized (object) {
                if (this.connectionIdileTimeout > 0L) {
                    ((ExtendedDBConnection)dbConnection).setConnectionEnterPoolTime(System.currentTimeMillis());
                }
                this.releasePool.pool.addLast(dbConnection);
                releaseSize = this.releasePool.pool.size();
            }
            this.waitConnectionMonitor.countNotify(releaseSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DBConnection dbConnection) {
        int releasedCounter = 1;
        LinkedList<DBConnection> newAllocatePool = new LinkedList<DBConnection>();
        LinkedList newReleasePool = new LinkedList();
        Object object = this.allocateMonitor;
        synchronized (object) {
            DBConnection connect;
            LinkedList tmpPool;
            if (this.generation <= dbConnection.getGeneration()) {
                ++this.generation;
            }
            Object object2 = this.releaseMonitor;
            synchronized (object2) {
                tmpPool = this.releasePool.pool;
                this.releasePool.pool = newReleasePool;
            }
            try {
                while (!tmpPool.isEmpty()) {
                    connect = (DBConnection)tmpPool.removeFirst();
                    if (connect.getGeneration() < this.generation) {
                        connect.close();
                        ++releasedCounter;
                        --this.currentPoolSize;
                        continue;
                    }
                    newAllocatePool.addLast(connect);
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            try {
                while (!this.allocatePool.pool.isEmpty()) {
                    connect = (DBConnection)this.allocatePool.pool.removeFirst();
                    if (connect.getGeneration() < this.generation) {
                        connect.close();
                        ++releasedCounter;
                        --this.currentPoolSize;
                        continue;
                    }
                    newAllocatePool.addLast(connect);
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
            this.allocatePool.pool = newAllocatePool;
            dbConnection.close();
            --this.currentPoolSize;
        }
        for (int i = 0; i < releasedCounter; ++i) {
            this.waitConnectionMonitor.countNotify(releasedCounter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropAllNow() {
        if (this.shutDownStr != null) {
            try {
                DBConnection tmpConn = this.allocate();
                tmpConn.execute(this.shutDownStr);
                tmpConn.release();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        Object object = this.releaseMonitor;
        synchronized (object) {
            Object object2 = this.allocateMonitor;
            synchronized (object2) {
                try {
                    while (!this.allocatePool.pool.isEmpty()) {
                        DBConnection connect = (DBConnection)this.allocatePool.pool.removeFirst();
                        connect.close();
                        --this.currentPoolSize;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            try {
                while (!this.releasePool.pool.isEmpty()) {
                    DBConnection connect = (DBConnection)this.releasePool.pool.removeFirst();
                    connect.close();
                    --this.currentPoolSize;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
    }

    public int getActiveCount() {
        return this.currentPoolSize;
    }

    public int getMaxCount() {
        return this.biggestPoolSize;
    }

    public Date getMaxCountDate() {
        return this.biggestPoolDate;
    }

    public void resetMaxCount() {
        this.biggestPoolSize = this.currentPoolSize;
        this.biggestPoolDate = new Date();
    }

    public long getRequestCount() {
        return this.numRequests;
    }

    protected void finalize() {
        this.dropAllNow();
    }

    public String getDatabaseName() {
        return this.logicalDatabase.getName();
    }

    public void IncrementRequesteCount() {
        ++this.numRequests;
    }

    class CountMonitor {
        int waitCounter = 0;
        int notifyCounter = 0;
        int maxPoolSize = 0;

        public CountMonitor(int pSize) {
            this.maxPoolSize = pSize;
        }

        public synchronized void countNotify(int maxNotify) {
            if (this.maxPoolSize == 0 && this.waitCounter <= 0) {
                this.notifyCounter = this.notifyCounter < maxNotify ? ++this.notifyCounter : maxNotify;
            } else if (this.notifyCounter < this.maxPoolSize && this.waitCounter <= 0) {
                this.notifyCounter = this.notifyCounter < maxNotify ? ++this.notifyCounter : maxNotify;
            }
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void countWait() throws InterruptedException {
            int countX3;
            block8: {
                if (this.notifyCounter > 0) {
                    --this.notifyCounter;
                    if (this.waitCounter <= 0 || this.notifyCounter <= 0) return;
                    int countX2 = this.waitCounter;
                    if (this.waitCounter > this.notifyCounter) {
                        countX2 = this.notifyCounter;
                    }
                    for (int i = 0; i < countX2; ++i) {
                        this.notify();
                    }
                    return;
                }
                ++this.waitCounter;
                try {
                    this.wait();
                    Object var4_3 = null;
                    --this.waitCounter;
                    if (this.waitCounter <= 0 || this.notifyCounter <= 0) return;
                    countX3 = this.waitCounter;
                    if (this.waitCounter <= this.notifyCounter) break block8;
                    countX3 = this.notifyCounter;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    --this.waitCounter;
                    if (this.waitCounter <= 0 || this.notifyCounter <= 0) throw throwable;
                    int countX3 = this.waitCounter;
                    if (this.waitCounter > this.notifyCounter) {
                        countX3 = this.notifyCounter;
                    }
                    for (int i = 0; i < countX3; ++i) {
                        this.notify();
                        --this.notifyCounter;
                    }
                    throw throwable;
                }
            }
            for (int i = 0; i < countX3; ++i) {
                this.notify();
                --this.notifyCounter;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public synchronized long countWait(long timeout) throws InterruptedException {
            long ret = timeout;
            if (this.notifyCounter > 0) {
                --this.notifyCounter;
                if (this.waitCounter <= 0 || this.notifyCounter <= 0) return ret;
                int countX = this.waitCounter;
                if (this.waitCounter > this.notifyCounter) {
                    countX = this.notifyCounter;
                }
                for (int i = 0; i < countX; --this.notifyCounter, ++i) {
                    this.notify();
                }
                return ret;
            }
            ret = System.currentTimeMillis();
            ++this.waitCounter;
            try {
                try {
                    this.wait(timeout);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var8_7 = null;
                    --this.waitCounter;
                    ret = timeout - (System.currentTimeMillis() - ret);
                    if (ret < 0L) {
                        ret = 0L;
                    }
                    if (this.notifyCounter > 0 && ret > 0L) {
                        --this.notifyCounter;
                    }
                    if (this.waitCounter <= 0 || this.notifyCounter <= 0) return ret;
                    int countX = this.waitCounter;
                    if (this.waitCounter > this.notifyCounter) {
                        countX = this.notifyCounter;
                    }
                    for (int i = 0; i < countX; --this.notifyCounter, ++i) {
                        this.notify();
                    }
                    return ret;
                }
                Object var8_6 = null;
                --this.waitCounter;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                --this.waitCounter;
                ret = timeout - (System.currentTimeMillis() - ret);
                if (ret < 0L) {
                    ret = 0L;
                }
                if (this.notifyCounter > 0 && ret > 0L) {
                    --this.notifyCounter;
                }
                if (this.waitCounter <= 0 || this.notifyCounter <= 0) throw throwable;
                int countX = this.waitCounter;
                if (this.waitCounter > this.notifyCounter) {
                    countX = this.notifyCounter;
                }
                for (int i = 0; i < countX; --this.notifyCounter, ++i) {
                    this.notify();
                }
                throw throwable;
            }
            ret = timeout - (System.currentTimeMillis() - ret);
            if (ret < 0L) {
                ret = 0L;
            }
            if (this.notifyCounter > 0 && ret > 0L) {
                --this.notifyCounter;
            }
            if (this.waitCounter <= 0 || this.notifyCounter <= 0) return ret;
            int countX = this.waitCounter;
            if (this.waitCounter > this.notifyCounter) {
                countX = this.notifyCounter;
            }
            for (int i = 0; i < countX; --this.notifyCounter, ++i) {
                this.notify();
            }
            return ret;
        }
    }

    class ConnectionPool {
        int dropCount = 0;
        LinkedList pool = new LinkedList();
    }
}

