/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.io.Serializable;
import org.enhydra.shark.xpdl.XMLUtil;

public abstract class XMLElement
implements Serializable,
Cloneable {
    private String name;
    private boolean isRequired = false;
    protected String value;
    protected boolean isReadOnly = false;
    protected XMLElement parent;

    public XMLElement(XMLElement parent, boolean isRequired) {
        this.parent = parent;
        this.isRequired = isRequired;
        this.name = this.getClass().getName();
        this.name = XMLUtil.getShortClassName(this.name);
        this.value = new String();
    }

    public XMLElement(XMLElement parent, String name, boolean isRequired) {
        this.parent = parent;
        this.name = name;
        this.isRequired = isRequired;
        this.value = new String();
    }

    public void setReadOnly(boolean ro) {
        this.isReadOnly = ro;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isEmpty() {
        return this.value == null || this.value.trim().length() <= 0;
    }

    public void setValue(String v) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        this.value = v;
    }

    public String toValue() {
        return this.value;
    }

    public String toName() {
        return this.name;
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public void setParent(XMLElement el) {
        this.parent = el;
    }

    public Object clone() {
        XMLElement d = null;
        try {
            d = (XMLElement)super.clone();
            d.name = new String(this.name);
            d.value = new String(this.value);
            d.isRequired = this.isRequired;
            d.isReadOnly = this.isReadOnly;
            d.parent = this.parent;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex.toString());
        }
        return d;
    }

    public boolean equals(Object e) {
        if (this == e) {
            return true;
        }
        if (e != null && e instanceof XMLElement && e.getClass().equals(this.getClass())) {
            XMLElement el = (XMLElement)e;
            return this.name.equals(el.name) && this.value.equals(el.value) && this.isRequired == el.isRequired;
        }
        return false;
    }
}

