/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.ArrayList;
import java.util.Iterator;
import org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLEmptyChoiceElement;

public abstract class XMLComplexChoice
extends XMLElement {
    protected ArrayList choices;
    protected XMLElement choosen;
    protected transient boolean cachesInitialized = false;

    public XMLComplexChoice(XMLComplexElement parent, String name, boolean isRequired) {
        super(parent, name, isRequired);
        this.fillChoices();
    }

    public void setValue(String v) {
        throw new RuntimeException("Can't set value for this type of element!");
    }

    public void setReadOnly(boolean ro) {
        super.setReadOnly(ro);
        for (int i = 0; i < this.choices.size(); ++i) {
            ((XMLElement)this.choices.get(i)).setReadOnly(ro);
        }
    }

    public void initCaches() {
        if (!this.isReadOnly) {
            throw new RuntimeException("Caches can be initialized only in read-only mode!");
        }
        this.clearCaches();
        Iterator it = this.choices.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement)it.next();
            if (el instanceof XMLBaseForCollectionAndComplex) {
                ((XMLBaseForCollectionAndComplex)el).initCaches();
                continue;
            }
            if (!(el instanceof XMLComplexChoice)) continue;
            ((XMLComplexChoice)el).initCaches();
        }
        this.cachesInitialized = true;
    }

    public void clearCaches() {
        Iterator it = this.choices.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement)it.next();
            if (el instanceof XMLBaseForCollectionAndComplex) {
                ((XMLBaseForCollectionAndComplex)el).clearCaches();
                continue;
            }
            if (!(el instanceof XMLComplexChoice)) continue;
            ((XMLComplexChoice)el).clearCaches();
        }
        this.cachesInitialized = false;
    }

    public boolean isEmpty() {
        return this.choosen instanceof XMLEmptyChoiceElement;
    }

    public ArrayList getChoices() {
        return this.choices;
    }

    public XMLElement getChoosen() {
        return this.choosen;
    }

    public void setChoosen(XMLElement ch) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        if (!this.choices.contains(ch)) {
            throw new RuntimeException("Incorrect value! The possible values are: " + this.choices);
        }
        this.choosen = ch;
    }

    protected abstract void fillChoices();

    public Object clone() {
        XMLComplexChoice d = (XMLComplexChoice)super.clone();
        d.choices = new ArrayList();
        d.choosen = null;
        d.cachesInitialized = false;
        Iterator it = this.choices.iterator();
        while (it.hasNext()) {
            XMLElement c = (XMLElement)it.next();
            XMLElement cloned = (XMLElement)c.clone();
            d.choices.add(cloned);
            cloned.setParent(d);
            if (d.choosen != null || !this.choosen.equals(c)) continue;
            d.choosen = cloned;
        }
        return d;
    }

    public boolean equals(Object e) {
        boolean equals = super.equals(e);
        if (equals) {
            XMLComplexChoice el = (XMLComplexChoice)e;
            return this.choices.equals(el.choices) && this.choosen.equals(el.choosen);
        }
        return false;
    }
}

