/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.enhydra.shark.xpdl.XMLElement;

public class XMLAttribute
extends XMLElement {
    protected ArrayList choices;

    public XMLAttribute(XMLElement parent, String name, boolean isRequired) {
        super(parent, name, isRequired);
    }

    public XMLAttribute(XMLElement parent, String name, boolean isRequired, String[] choices, int choosenIndex) {
        super(parent, name, isRequired);
        this.choices = new ArrayList<String>(Arrays.asList(choices));
        this.value = choices[choosenIndex];
    }

    public void setValue(String v) {
        if (this.choices != null && !this.choices.contains(v)) {
            throw new RuntimeException("Incorrect value! Possible values are: " + this.choices);
        }
        super.setValue(v);
    }

    public ArrayList getChoices() {
        return this.choices;
    }

    public Object clone() {
        XMLAttribute d = (XMLAttribute)super.clone();
        if (this.choices != null) {
            d.choices = new ArrayList();
            Iterator it = this.choices.iterator();
            while (it.hasNext()) {
                d.choices.add(new String(it.next().toString()));
            }
        }
        return d;
    }

    public boolean equals(Object e) {
        boolean equals = super.equals(e);
        if (equals) {
            XMLAttribute el = (XMLAttribute)e;
            return this.choices == null ? el.choices == null : this.choices.equals(el.choices);
        }
        return false;
    }
}

