/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.Vector;

public class GraphChecker {
    private boolean[][] mat;
    private boolean[][] tempMat;
    private int dim = 0;

    private boolean isLinked(int srcNode, int dstNode) {
        return this.mat[srcNode][dstNode];
    }

    private void link(int srcNode, int dstNode) {
        this.mat[srcNode][dstNode] = true;
    }

    private void unlink(int srcNode, int dstNode) {
        this.mat[srcNode][dstNode] = false;
    }

    private void unlinkParents(int node) {
        for (int i = 0; i < this.dim; ++i) {
            this.unlink(i, node);
        }
    }

    private void unlinkChildren(int node) {
        for (int i = 0; i < this.dim; ++i) {
            this.unlink(node, i);
        }
    }

    private Integer node(int index) {
        return new Integer(index);
    }

    private int index(Integer node) {
        return node;
    }

    private int indexAt(Vector nodeSet, int pos) {
        return this.index((Integer)nodeSet.elementAt(pos));
    }

    private boolean isInSet(Vector nodeSet, int nodeIndex) {
        for (int i = 0; i < nodeSet.size(); ++i) {
            if (nodeIndex != this.indexAt(nodeSet, i)) continue;
            return true;
        }
        return false;
    }

    private boolean isGraphEmpty() {
        boolean link = false;
        for (int i = 0; i < this.dim; ++i) {
            for (int j = 0; j < this.dim; ++j) {
                link = link || this.isLinked(i, j);
            }
        }
        return !link;
    }

    private boolean isJoin(int node) {
        int parentCount = 0;
        for (int i = 0; i < this.dim; ++i) {
            if (!this.isLinked(i, node)) continue;
            ++parentCount;
        }
        return parentCount > 1;
    }

    private boolean isSplit(int node) {
        int childCount = 0;
        for (int i = 0; i < this.dim; ++i) {
            if (!this.isLinked(node, i)) continue;
            ++childCount;
        }
        return childCount > 1;
    }

    private boolean isIsolated(int node) {
        return !this.hasChild(node) || !this.hasParent(node);
    }

    private boolean hasChild(int node) {
        boolean child = false;
        for (int i = 0; i < this.dim; ++i) {
            child = child || this.isLinked(node, i);
        }
        return child;
    }

    private boolean hasParent(int node) {
        boolean parent = false;
        for (int i = 0; i < this.dim; ++i) {
            parent = parent || this.isLinked(i, node);
        }
        return parent;
    }

    public GraphChecker(boolean[][] matParam) {
        this.tempMat = matParam;
        this.dim = this.tempMat.length;
        this.mat = new boolean[this.dim][this.dim];
        for (int x = 0; x < this.dim; ++x) {
            for (int y = 0; y < this.dim; ++y) {
                this.mat[x][y] = this.tempMat[x][y];
            }
        }
    }

    private void undo() {
        for (int x = 0; x < this.dim; ++x) {
            for (int y = 0; y < this.dim; ++y) {
                this.mat[x][y] = this.tempMat[x][y];
            }
        }
    }

    public boolean isGraphCyclic() {
        boolean ret = false;
        boolean changed = true;
        this.undo();
        while (changed) {
            changed = false;
            for (int i = 0; i < this.dim; ++i) {
                if (this.hasChild(i) && this.hasParent(i)) continue;
                if (this.hasChild(i)) {
                    this.unlinkChildren(i);
                    changed = true;
                }
                if (!this.hasParent(i)) continue;
                this.unlinkParents(i);
                changed = true;
            }
        }
        ret = !this.isGraphEmpty();
        this.undo();
        return ret;
    }

    public int[] getCyclicNodes() {
        this.undo();
        boolean ret = false;
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < this.dim; ++i) {
                if (this.hasChild(i) && this.hasParent(i)) continue;
                if (this.hasChild(i)) {
                    this.unlinkChildren(i);
                    changed = true;
                }
                if (!this.hasParent(i)) continue;
                this.unlinkParents(i);
                changed = true;
            }
        }
        if (!this.isGraphEmpty()) {
            int nodeCount = 0;
            for (int i = 0; i < this.dim; ++i) {
                if (this.isIsolated(i)) continue;
                ++nodeCount;
            }
            int[] nodeArray = new int[nodeCount];
            int index = 0;
            for (int i = 0; i < this.dim; ++i) {
                if (this.isIsolated(i)) continue;
                nodeArray[index++] = i;
            }
            this.undo();
            return nodeArray;
        }
        this.undo();
        return null;
    }

    public int getJoinIndex(int nodeX) {
        this.undo();
        if (!this.isGraphCyclic()) {
            this.undo();
            if (this.isSplit(nodeX)) {
                Vector<Integer> workingSet = new Vector<Integer>();
                for (int i = 0; i < this.dim; ++i) {
                    if (!this.isLinked(nodeX, i)) continue;
                    this.unlink(nodeX, i);
                    workingSet.addElement(this.node(i));
                }
                boolean changed = true;
                while (changed) {
                    int actual;
                    int j;
                    changed = false;
                    Vector<Integer> tempSet = new Vector<Integer>();
                    for (j = workingSet.size() - 1; j >= 0; --j) {
                        actual = this.indexAt(workingSet, j);
                        if (!this.hasParent(actual) || this.isInSet(tempSet, actual)) continue;
                        tempSet.addElement(this.node(actual));
                        workingSet.remove(j);
                    }
                    if (workingSet.size() == 1 && tempSet.size() == 0) {
                        return this.indexAt(workingSet, 0);
                    }
                    for (j = 0; j < workingSet.size(); ++j) {
                        actual = this.indexAt(workingSet, j);
                        boolean actualChanged = false;
                        for (int k = 0; k < this.dim; ++k) {
                            if (!this.isLinked(actual, k)) continue;
                            this.unlink(actual, k);
                            changed = true;
                            actualChanged = true;
                            if (this.isInSet(tempSet, k)) continue;
                            tempSet.addElement(this.node(k));
                        }
                        if (actualChanged || this.isInSet(tempSet, actual)) continue;
                        tempSet.addElement(this.node(actual));
                    }
                    workingSet = tempSet;
                }
            }
            return -1;
        }
        return -1;
    }
}

