/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl.elements;

import java.util.ArrayList;
import java.util.Iterator;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.XMLCollection;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Application;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;

public class ExtendedAttributes
extends XMLCollection {
    public transient SequencedHashMap eaMap;
    protected String extAttribsString;

    public ExtendedAttributes(XMLComplexElement parent) {
        super(parent, false);
    }

    public XMLElement generateNewElement() {
        return new ExtendedAttribute(this);
    }

    public ExtendedAttribute getFirstExtendedAttributeForName(String name) {
        ExtendedAttribute ea = null;
        ArrayList l = this.getElementsForName(name);
        if (l != null && l.size() > 0) {
            ea = (ExtendedAttribute)l.get(0);
        }
        return ea;
    }

    public void initCaches() {
        super.initCaches();
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute)it.next();
            String eaName = ea.getName();
            ArrayList<ExtendedAttribute> l = (ArrayList<ExtendedAttribute>)this.eaMap.get((Object)eaName);
            if (l == null) {
                l = new ArrayList<ExtendedAttribute>();
            }
            l.add(ea);
            this.eaMap.put((Object)eaName, l);
        }
        if (this.parent instanceof Application) {
            this.getExtendedAttributesString();
        }
    }

    public void initExtAttribString() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        if (this.size() > 0) {
            try {
                this.extAttribsString = XMLUtil.stringifyExtendedAttributes(this);
            }
            catch (Throwable thr) {
                throw new RuntimeException("Can't stringify extended attributes!");
            }
        } else {
            this.extAttribsString = "";
        }
    }

    public void clearExtAttribString() {
        this.extAttribsString = null;
    }

    public String getExtendedAttributesString() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        if (this.extAttribsString == null) {
            this.initExtAttribString();
        }
        return this.extAttribsString;
    }

    public void clearCaches() {
        this.eaMap = new SequencedHashMap();
        super.clearCaches();
    }

    public void clear() {
        if (this.eaMap != null) {
            this.eaMap.clear();
        }
        super.clear();
    }

    public boolean containsElement(String name) {
        if (this.isReadOnly && this.cachesInitialized) {
            return this.eaMap.containsKey((Object)name);
        }
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute)it.next();
            if (!ea.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(String val) {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute)it.next();
            if (!ea.getVValue().equals(val)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getElementsForName(String name) {
        if (this.isReadOnly && this.cachesInitialized) {
            return (ArrayList)this.eaMap.get((Object)name);
        }
        ArrayList<ExtendedAttribute> l = new ArrayList<ExtendedAttribute>();
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            ExtendedAttribute ea = (ExtendedAttribute)it.next();
            if (!ea.getName().equals(name)) continue;
            l.add(ea);
        }
        return l;
    }

    public Object clone() {
        ExtendedAttributes d = (ExtendedAttributes)super.clone();
        d.extAttribsString = this.extAttribsString;
        return d;
    }
}

