/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl.elements;

import java.util.HashMap;
import java.util.Map;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.BasicType;
import org.enhydra.shark.xpdl.elements.DataTypes;
import org.enhydra.shark.xpdl.elements.DeclaredType;
import org.enhydra.shark.xpdl.elements.ExternalReference;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.TypeDeclaration;

public class DataType
extends XMLComplexElement {
    private static Map basicTypesMap = new HashMap();
    protected transient String javaType;

    public DataType(XMLComplexElement parent) {
        super(parent, true);
    }

    protected void fillStructure() {
        DataTypes refDataTypes = new DataTypes(this);
        this.add(refDataTypes);
    }

    public void initCaches() {
        super.initCaches();
        this.javaType = DataType.getChoosenType(this.getDataTypes(), XMLUtil.getPackage(this));
    }

    public void clearCaches() {
        this.javaType = null;
        super.clearCaches();
    }

    public String getJavaType() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.javaType;
    }

    private static String getChoosenType(DataTypes types, Package pkg) {
        XMLElement choosenType = types.getChoosen();
        if (choosenType instanceof BasicType) {
            String subTypeName = ((BasicType)choosenType).getType();
            if (basicTypesMap.containsKey(subTypeName)) {
                return (String)basicTypesMap.get(subTypeName);
            }
        } else {
            if (choosenType instanceof DeclaredType) {
                TypeDeclaration td = pkg.getTypeDeclaration(((DeclaredType)choosenType).getId());
                DataTypes dtypes = td.getDataTypes();
                return DataType.getChoosenType(dtypes, pkg);
            }
            if (choosenType instanceof ExternalReference) {
                return ((ExternalReference)choosenType).getLocation();
            }
        }
        return "java.lang.Object";
    }

    public DataTypes getDataTypes() {
        return (DataTypes)this.get("Type");
    }

    static {
        basicTypesMap.put("BOOLEAN", "java.lang.Boolean");
        basicTypesMap.put("STRING", "java.lang.String");
        basicTypesMap.put("INTEGER", "java.lang.Long");
        basicTypesMap.put("FLOAT", "java.lang.Double");
        basicTypesMap.put("DATETIME", "java.util.Date");
    }
}

