/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl.elements;

import java.util.ArrayList;
import java.util.Iterator;
import org.enhydra.shark.xpdl.XMLAttribute;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLElement;
import org.enhydra.shark.xpdl.XMLUtil;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.ActivitySet;
import org.enhydra.shark.xpdl.elements.ActivityTypes;
import org.enhydra.shark.xpdl.elements.Condition;
import org.enhydra.shark.xpdl.elements.Deadlines;
import org.enhydra.shark.xpdl.elements.Description;
import org.enhydra.shark.xpdl.elements.Documentation;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.enhydra.shark.xpdl.elements.FinishMode;
import org.enhydra.shark.xpdl.elements.Icon;
import org.enhydra.shark.xpdl.elements.Implementation;
import org.enhydra.shark.xpdl.elements.Limit;
import org.enhydra.shark.xpdl.elements.Performer;
import org.enhydra.shark.xpdl.elements.Priority;
import org.enhydra.shark.xpdl.elements.Route;
import org.enhydra.shark.xpdl.elements.SimulationInformation;
import org.enhydra.shark.xpdl.elements.StartMode;
import org.enhydra.shark.xpdl.elements.SubFlow;
import org.enhydra.shark.xpdl.elements.Tools;
import org.enhydra.shark.xpdl.elements.Transition;
import org.enhydra.shark.xpdl.elements.TransitionRef;
import org.enhydra.shark.xpdl.elements.TransitionRestriction;
import org.enhydra.shark.xpdl.elements.TransitionRestrictions;
import org.enhydra.shark.xpdl.elements.Transitions;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class Activity
extends XMLCollectionElement {
    protected transient ArrayList outgoingTransitions;
    protected transient ArrayList incomingTransitions;
    protected transient ArrayList exceptionalOutgoingTransitions;
    protected transient ArrayList nonExceptionalOutgoingTransitions;

    public Activity(Activities acts) {
        super(acts, true);
    }

    protected void fillStructure() {
        XMLAttribute attrName = new XMLAttribute(this, "Name", false);
        Description refDescription = new Description(this);
        Limit refLimit = new Limit(this);
        ActivityTypes refType = new ActivityTypes(this);
        Performer refPerformer = new Performer(this);
        StartMode refStartMode = new StartMode(this);
        FinishMode refFinishMode = new FinishMode(this);
        Priority refPriority = new Priority(this);
        Deadlines refDeadlines = new Deadlines(this);
        SimulationInformation refSimulationInformation = new SimulationInformation(this);
        Icon refIcon = new Icon(this);
        Documentation refDocumentation = new Documentation(this);
        TransitionRestrictions refTransitionRestrictions = new TransitionRestrictions(this);
        ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);
        super.fillStructure();
        this.add(attrName);
        this.add(refDescription);
        this.add(refLimit);
        this.add(refType);
        this.add(refPerformer);
        this.add(refStartMode);
        this.add(refFinishMode);
        this.add(refPriority);
        this.add(refDeadlines);
        this.add(refSimulationInformation);
        this.add(refIcon);
        this.add(refDocumentation);
        this.add(refTransitionRestrictions);
        this.add(refExtendedAttributes);
    }

    public void initCaches() {
        super.initCaches();
        Transitions ts = this.getParent().getParent() instanceof WorkflowProcess ? ((WorkflowProcess)this.getParent().getParent()).getTransitions() : ((ActivitySet)this.getParent().getParent()).getTransitions();
        TransitionRestrictions trs = this.getTransitionRestrictions();
        ArrayList trefs = null;
        trefs = trs.size() > 0 ? ((TransitionRestriction)trs.get(0)).getSplit().getTransitionRefs().toElements() : new ArrayList();
        Iterator it = trefs.iterator();
        while (it.hasNext()) {
            TransitionRef tref = (TransitionRef)it.next();
            Transition t = ts.getTransition(tref.getId());
            this.outgoingTransitions.add(t);
            this.putTransitionInTheRightList(t);
        }
        it = ts.toElements().iterator();
        while (it.hasNext()) {
            Transition t = (Transition)it.next();
            if (!this.outgoingTransitions.contains(t) && t.getFrom().equals(this.getId())) {
                this.outgoingTransitions.add(t);
                this.putTransitionInTheRightList(t);
            }
            if (!t.getTo().equals(this.getId())) continue;
            this.incomingTransitions.add(t);
        }
    }

    public void clearCaches() {
        this.clearInternalCaches();
        super.clearCaches();
    }

    protected void clearInternalCaches() {
        this.outgoingTransitions = new ArrayList();
        this.incomingTransitions = new ArrayList();
        this.exceptionalOutgoingTransitions = new ArrayList();
        this.nonExceptionalOutgoingTransitions = new ArrayList();
    }

    protected void putTransitionInTheRightList(Transition t) {
        Condition condition = t.getCondition();
        String condType = condition.getType();
        if (condType.equals("EXCEPTION") || condType.equals("DEFAULTEXCEPTION")) {
            this.exceptionalOutgoingTransitions.add(t);
        } else {
            this.nonExceptionalOutgoingTransitions.add(t);
        }
    }

    public ArrayList getOutgoingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.outgoingTransitions;
    }

    public ArrayList getIncomingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.incomingTransitions;
    }

    public ArrayList getNonExceptionalOutgoingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.nonExceptionalOutgoingTransitions;
    }

    public ArrayList getExceptionalOutgoingTransitions() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.exceptionalOutgoingTransitions;
    }

    public boolean isAndTypeSplit() {
        return XMLUtil.isANDTypeSplitOrJoin(this, 0);
    }

    public boolean isAndTypeJoin() {
        return XMLUtil.isANDTypeSplitOrJoin(this, 1);
    }

    public int getActivityStartMode() {
        return XMLUtil.getStartMode(this);
    }

    public int getActivityFinishMode() {
        return XMLUtil.getFinishMode(this);
    }

    public int getActivityType() {
        XMLElement ch = this.getActivityTypes().getChoosen();
        if (ch instanceof Route) {
            return 0;
        }
        if (ch instanceof Implementation) {
            if ((ch = ((Implementation)ch).getImplementationTypes().getChoosen()) instanceof Tools) {
                return 2;
            }
            if (ch instanceof SubFlow) {
                return 3;
            }
            return 1;
        }
        return 4;
    }

    public boolean isSubflowSynchronous() {
        if (this.getActivityType() != 3) {
            throw new RuntimeException("The activity type is not SubFlow!");
        }
        return XMLUtil.isSubflowSynchronous(this);
    }

    public String getName() {
        return this.get("Name").toValue();
    }

    public void setName(String name) {
        this.set("Name", name);
    }

    public Deadlines getDeadlines() {
        return (Deadlines)this.get("Deadlines");
    }

    public String getDescription() {
        return this.get("Description").toValue();
    }

    public void setDescription(String description) {
        this.set("Description", description);
    }

    public String getDocumentation() {
        return this.get("Documentation").toValue();
    }

    public void setDocumentation(String documentation) {
        this.set("Documentation", documentation);
    }

    public ExtendedAttributes getExtendedAttributes() {
        return (ExtendedAttributes)this.get("ExtendedAttributes");
    }

    public FinishMode getFinishMode() {
        return (FinishMode)this.get("FinishMode");
    }

    public String getIcon() {
        return this.get("Icon").toValue();
    }

    public void setIcon(String icon) {
        this.set("Icon", icon);
    }

    public String getLimit() {
        return this.get("Limit").toValue();
    }

    public void setLimit(String limit) {
        this.set("Limit", limit);
    }

    public String getPerformer() {
        return this.get("Performer").toValue();
    }

    public void setPerformer(String performer) {
        this.set("Performer", performer);
    }

    public String getPriority() {
        return this.get("Priority").toValue();
    }

    public void setPriority(String priority) {
        this.set("Priority", priority);
    }

    public SimulationInformation getSimulationInformation() {
        return (SimulationInformation)this.get("SimulationInformation");
    }

    public StartMode getStartMode() {
        return (StartMode)this.get("StartMode");
    }

    public TransitionRestrictions getTransitionRestrictions() {
        return (TransitionRestrictions)this.get("TransitionRestrictions");
    }

    public ActivityTypes getActivityTypes() {
        return (ActivityTypes)this.get("Type");
    }
}

