/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.ArrayList;
import java.util.Iterator;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.XMLAttribute;
import org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.shark.xpdl.XMLElement;

public abstract class XMLComplexElement
extends XMLBaseForCollectionAndComplex {
    public XMLComplexElement(XMLElement parent, boolean isRequired) {
        super(parent, isRequired);
        this.fillStructure();
    }

    protected void add(XMLElement el) {
        this.elements.add(el);
        this.elementMap.put((Object)el.toName(), (Object)el);
    }

    protected boolean add(int no, XMLElement el) {
        if (no < 0 || no > this.size()) {
            return false;
        }
        this.elements.add(no, el);
        this.elementMap.put((Object)el.toName(), (Object)el);
        return true;
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement)it.next();
            isEmpty = isEmpty && el.isEmpty();
        }
        isEmpty = isEmpty && this.value.trim().length() == 0;
        return isEmpty;
    }

    public ArrayList getXMLElements() {
        ArrayList els = new ArrayList();
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Object el = it.next();
            if (el instanceof XMLAttribute) continue;
            els.add(el);
        }
        return els;
    }

    public ArrayList getXMLAttributes() {
        ArrayList attribs = new ArrayList();
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Object el = it.next();
            if (!(el instanceof XMLAttribute)) continue;
            attribs.add(el);
        }
        return attribs;
    }

    public void set(String name, String value) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't change element from read only structure!");
        }
        XMLElement el = this.get(name);
        if (el == null) {
            throw new RuntimeException("No such element!");
        }
        el.setValue(value);
    }

    public boolean set(int no, String value) {
        if (no < 0 || no >= this.size()) {
            return false;
        }
        if (this.isReadOnly) {
            throw new RuntimeException("Can't change element from read only structure!");
        }
        XMLElement el = this.get(no);
        el.setValue(value);
        return true;
    }

    public XMLElement get(String name) {
        return (XMLElement)this.elementMap.get((Object)name);
    }

    public boolean containsName(String name) {
        return this.elementMap.containsKey((Object)name);
    }

    protected abstract void fillStructure();

    public Object clone() {
        XMLComplexElement d = (XMLComplexElement)super.clone();
        d.elements = new ArrayList();
        d.elementMap = new SequencedHashMap();
        d.cachesInitialized = false;
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement)it.next();
            XMLElement cl = (XMLElement)el.clone();
            cl.setParent(d);
            d.elements.add(cl);
            d.elementMap.put((Object)cl.toName(), (Object)cl);
        }
        return d;
    }
}

