/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.ArrayList;
import java.util.Iterator;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.shark.xpdl.XMLCollectionElement;
import org.enhydra.shark.xpdl.XMLComplexChoice;
import org.enhydra.shark.xpdl.XMLComplexElement;
import org.enhydra.shark.xpdl.XMLElement;

public abstract class XMLCollection
extends XMLBaseForCollectionAndComplex {
    public XMLCollection(XMLComplexElement parent, boolean isRequired) {
        super(parent, isRequired);
    }

    public XMLCollection(XMLComplexChoice parent, boolean isRequired) {
        super(parent, isRequired);
    }

    public void initCaches() {
        super.initCaches();
        if (this.elements.size() > 0 && this.elements.get(0) instanceof XMLCollectionElement) {
            this.elementMap.clear();
            Iterator it = this.elements.iterator();
            while (it.hasNext()) {
                XMLCollectionElement el = (XMLCollectionElement)it.next();
                this.elementMap.put((Object)el.getId(), (Object)el);
            }
        }
        this.cachesInitialized = true;
    }

    public void clearCaches() {
        super.clearCaches();
        this.elementMap.clear();
    }

    public void add(XMLElement el) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        this.elements.add(el);
    }

    public boolean add(int no, XMLElement el) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        if (no < 0 || no > this.size()) {
            return false;
        }
        this.elements.add(no, el);
        return true;
    }

    public int remove(XMLElement el) {
        return super.remove(el);
    }

    protected XMLElement remove(int no) {
        return super.remove(no);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public XMLCollectionElement getCollectionElement(String id) {
        if (this.isReadOnly && this.cachesInitialized) {
            return (XMLCollectionElement)this.elementMap.get((Object)id);
        }
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            XMLCollectionElement ce = (XMLCollectionElement)it.next();
            if (!ce.getId().equals(id)) continue;
            return ce;
        }
        return null;
    }

    public boolean containsElement(String id) {
        return this.getCollectionElement(id) != null;
    }

    public void clear() {
        this.elements.clear();
        this.elementMap.clear();
    }

    public abstract XMLElement generateNewElement();

    public Object clone() {
        XMLCollection d = (XMLCollection)super.clone();
        d.elements = new ArrayList();
        d.elementMap = new SequencedHashMap();
        d.cachesInitialized = false;
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            XMLElement el = (XMLElement)obj;
            XMLElement cl = (XMLElement)el.clone();
            cl.setParent(d);
            d.elements.add(cl);
        }
        return d;
    }
}

