/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.xpdl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.enhydra.shark.utilities.SequencedHashMap;
import org.enhydra.shark.xpdl.XMLComplexChoice;
import org.enhydra.shark.xpdl.XMLElement;

public abstract class XMLBaseForCollectionAndComplex
extends XMLElement {
    protected SequencedHashMap elementMap;
    protected ArrayList elements = new ArrayList();
    protected transient boolean cachesInitialized = false;

    public XMLBaseForCollectionAndComplex(XMLElement parent, boolean isRequired) {
        super(parent, isRequired);
        this.elementMap = new SequencedHashMap();
    }

    public void setValue(String v) {
        throw new RuntimeException("Can't set value for this type of element!");
    }

    public void setReadOnly(boolean ro) {
        super.setReadOnly(ro);
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement)it.next();
            el.setReadOnly(ro);
        }
        if (!ro) {
            this.clearCaches();
        }
    }

    public void initCaches() {
        if (!this.isReadOnly) {
            throw new RuntimeException("Caches can be initialized only in read-only mode!");
        }
        this.clearCaches();
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement)it.next();
            if (el instanceof XMLBaseForCollectionAndComplex) {
                ((XMLBaseForCollectionAndComplex)el).initCaches();
                continue;
            }
            if (!(el instanceof XMLComplexChoice)) continue;
            ((XMLComplexChoice)el).initCaches();
        }
        this.cachesInitialized = true;
    }

    public void clearCaches() {
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            XMLElement el = (XMLElement)it.next();
            if (el instanceof XMLBaseForCollectionAndComplex) {
                ((XMLBaseForCollectionAndComplex)el).clearCaches();
                continue;
            }
            if (!(el instanceof XMLComplexChoice)) continue;
            ((XMLComplexChoice)el).clearCaches();
        }
        this.cachesInitialized = false;
    }

    protected abstract void add(XMLElement var1);

    protected abstract boolean add(int var1, XMLElement var2);

    protected int remove(XMLElement el) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't remove element from read only structure!");
        }
        int ind = this.elements.indexOf(el);
        if (ind >= 0) {
            this.elements.remove(el);
            this.elementMap.remove((Object)el);
        }
        return ind;
    }

    protected XMLElement remove(int no) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't remove element from read only structure!");
        }
        if (no < 0 || no >= this.size()) {
            return null;
        }
        XMLElement el = (XMLElement)this.elements.remove(no);
        this.elementMap.remove((Object)el);
        return el;
    }

    public boolean contains(XMLElement el) {
        return this.elements.contains(el);
    }

    public XMLElement get(int no) {
        if (no < 0 || no >= this.size()) {
            return null;
        }
        return (XMLElement)this.elements.get(no);
    }

    public int size() {
        return this.elements.size();
    }

    public ArrayList toElements() {
        return new ArrayList(this.elements);
    }

    public SequencedHashMap toElementMap() {
        return new SequencedHashMap((Map)this.elementMap);
    }

    public boolean equals(Object e) {
        boolean equals = super.equals(e);
        if (equals) {
            XMLBaseForCollectionAndComplex el = (XMLBaseForCollectionAndComplex)e;
            return this.elements.equals(el.elements);
        }
        return false;
    }
}

