/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.wfxml.test;

import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.enhydra.shark.asap.types.CreateInstanceRq;
import org.enhydra.shark.asap.types.CreateInstanceRqContextData;
import org.enhydra.shark.asap.types.FactoryPropertiesGroup;
import org.enhydra.shark.asap.types.Request;
import org.enhydra.shark.asap.types.holders.CreateInstanceRsHolder;
import org.enhydra.shark.asap.types.holders.GetPropertiesRsHolder;
import org.enhydra.shark.asap.types.holders.ResponseHolder;
import org.enhydra.shark.wfxml.SharkWebServiceLocator;
import org.enhydra.shark.wfxml.WfXmlFactoryBindingStub;
import org.enhydra.shark.wfxml.WfXmlRegistryBindingStub;
import org.enhydra.shark.wfxml.types.GetDefinitionRq;
import org.enhydra.shark.wfxml.types.ListDefinitionsRq;
import org.enhydra.shark.wfxml.types.NewDefinitionRq;
import org.enhydra.shark.wfxml.types.NewDefinitionRqDefinition;
import org.enhydra.shark.wfxml.types.SetDefinitionRq;
import org.enhydra.shark.wfxml.types.SetDefinitionRqDefinition;
import org.enhydra.shark.wfxml.types.SetPropertiesRq;
import org.enhydra.shark.wfxml.types.holders.GetDefinitionRsHolder;
import org.enhydra.shark.wfxml.types.holders.ListDefinitionsRsHolder;
import org.enhydra.shark.wfxml.types.holders.NewDefinitionRsHolder;
import org.enhydra.shark.wfxml.types.holders.SetDefinitionRsHolder;
import org.enhydra.shark.wfxml.types.holders.SetPropertiesRsHolder;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CookbookTestCase
extends TestCase {
    private static SharkWebServiceLocator swsl = new SharkWebServiceLocator();
    private static URI ik;
    private static String targetService;
    public static final String TARGET_SERVICE = "asap.test.ts";
    public static final String DEFAULT_SERVICE = "http://vajat:8080/axis/services/wfxmlFactoryBinding";

    public CookbookTestCase(String name) {
        super(name);
        targetService = System.getProperty(TARGET_SERVICE, DEFAULT_SERVICE);
        System.err.println("asap.test.ts:" + targetService);
    }

    public void testLevel1CreateProcess() throws Exception {
        WfXmlFactoryBindingStub binding = this.getFactoryBinding();
        Request rqHead = new Request();
        CreateInstanceRq rqBody = new CreateInstanceRq();
        ResponseHolder rsHead = new ResponseHolder();
        CreateInstanceRsHolder rsBody = new CreateInstanceRsHolder();
        rqHead.setReceiverKey(new URI(swsl.getwfxmlFactoryBindingAddress()));
        rqBody.setObserverKey(new URI(swsl.getasapObserverBindingAddress()));
        rqBody.getObserverKey().setHost(InetAddress.getLocalHost().getHostName());
        rqBody.setStartImmediately(true);
        rqBody.setName("some fine name");
        MessageElement[] b = new MessageElement[2];
        b[0] = new MessageElement("", "P1");
        b[0].setValue("2");
        b[1] = new MessageElement("", "P2");
        b[1].setValue("1");
        rqBody.setContextData(new CreateInstanceRqContextData(b));
        binding.createInstance(rqHead, rqBody, rsHead, rsBody);
        ik = rsBody.value.getInstanceKey();
        System.out.println("InstanceKey is " + ik);
    }

    public void testLevel3factoryGetProperties() throws Exception {
        WfXmlFactoryBindingStub binding = this.getFactoryBinding();
        Request rqHead = new Request();
        String rqBody = "";
        ResponseHolder rsHead = new ResponseHolder();
        GetPropertiesRsHolder rsBody = new GetPropertiesRsHolder();
        rqHead.setReceiverKey(new URI(targetService));
        rqHead.setSenderKey(new URI("http://interop.i-flow.com/ASAPClient/ObserverService.asmx"));
        binding.getProperties(rqHead, rqBody, rsHead, rsBody);
        FactoryPropertiesGroup fpg = rsBody.value.getFactoryPropertiesGroup();
        System.err.println("Key=" + fpg.getKey());
        System.err.println("Name=" + fpg.getName());
        System.err.println("Subj=" + fpg.getSubject());
        System.err.println("desc=" + fpg.getDescription());
        System.err.println("cds=" + fpg.getContextDataSchema().get_any()[0].toString());
        System.err.println("rds=" + fpg.getResultDataSchema().get_any()[0].toString());
    }

    public void testRegistryNewDefinition() throws Exception {
        WfXmlRegistryBindingStub binding = this.getRegistryBinding();
        Request rqHead = new Request();
        NewDefinitionRq rqBody = new NewDefinitionRq();
        ResponseHolder rsHead = new ResponseHolder();
        NewDefinitionRsHolder rsBody = new NewDefinitionRsHolder();
        rqHead.setReceiverKey(new URI(targetService));
        rqBody.setProcessLanguage("XPDL");
        rqBody.setDefinition(new NewDefinitionRqDefinition());
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xpdl:Package Id=\"toTestNewDefinition\"              Name=\"Application Repository\"              xmlns=\"http://www.wfmc.org/2002/XPDL1.0\"              xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\"              xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"              xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">      <xpdl:PackageHeader>      <xpdl:XPDLVersion>1.0</xpdl:XPDLVersion>      <xpdl:Vendor>Together</xpdl:Vendor>      <xpdl:Created>13-03-2003</xpdl:Created>      <xpdl:Description>Application repository for modified WfMC example of business process</xpdl:Description>   </xpdl:PackageHeader>   <xpdl:RedefinableHeader PublicationStatus=\"RELEASED\"/>   <xpdl:ConformanceClass GraphConformance=\"NON_BLOCKED\"/>   <xpdl:Script Type=\"text/javascript\"/></xpdl:Package>";
        byte[] a = s.getBytes("UTF8");
        System.err.println("$$" + a.length);
        Document b = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(a));
        MessageElement main = this.convertToMessageElement(b.getFirstChild());
        rqBody.getDefinition().set_any(new MessageElement[]{main});
        binding.newDefinition(rqHead, rqBody, rsHead, rsBody);
    }

    public void testRegistryListDefinitions() throws Exception {
        WfXmlRegistryBindingStub binding = this.getRegistryBinding();
        Request rqHead = new Request();
        ListDefinitionsRq rqBody = new ListDefinitionsRq();
        ResponseHolder rsHead = new ResponseHolder();
        ListDefinitionsRsHolder rsBody = new ListDefinitionsRsHolder();
        rqHead.setReceiverKey(new URI(targetService));
        rqBody.setName("basic");
        rqBody.setStatus("1");
        binding.listDefinitions(rqHead, rqBody, rsHead, rsBody);
    }

    public void testRegistrySetPropeties() throws Exception {
        WfXmlRegistryBindingStub binding = this.getRegistryBinding();
        Request rqHead = new Request();
        SetPropertiesRq rqBody = new SetPropertiesRq();
        ResponseHolder rsHead = new ResponseHolder();
        SetPropertiesRsHolder rsBody = new SetPropertiesRsHolder();
        rqHead.setReceiverKey(new URI(targetService));
        rqBody.setKey(targetService);
        binding.setProperties(rqHead, rqBody, rsHead, rsBody);
    }

    public void testRegistryGetPropeties() throws Exception {
        WfXmlRegistryBindingStub binding = this.getRegistryBinding();
        Request rqHead = new Request();
        String rqBody = "";
        ResponseHolder rsHead = new ResponseHolder();
        org.enhydra.shark.wfxml.types.holders.GetPropertiesRsHolder rsBody = new org.enhydra.shark.wfxml.types.holders.GetPropertiesRsHolder();
        rqHead.setReceiverKey(new URI(targetService));
        binding.getProperties(rqHead, rqBody, rsHead, rsBody);
    }

    public void testFactoryGetDefinition() throws Exception {
        WfXmlFactoryBindingStub binding = this.getFactoryBinding();
        Request rqHead = new Request();
        GetDefinitionRq rqBody = new GetDefinitionRq();
        ResponseHolder rsHead = new ResponseHolder();
        GetDefinitionRsHolder rsBody = new GetDefinitionRsHolder();
        rqHead.setReceiverKey(new URI(targetService));
        rqHead.setSenderKey(new URI("http://interop.i-flow.com/ASAPClient/ObserverService.asmx"));
        rqBody.setProcessLanguage("XDPL");
        binding.getDefinition(rqHead, rqBody, rsHead, rsBody);
    }

    public void testFactorySetDefinition() throws Exception {
        WfXmlFactoryBindingStub binding = this.getFactoryBinding();
        Request rqHead = new Request();
        SetDefinitionRq rqBody = new SetDefinitionRq();
        ResponseHolder rsHead = new ResponseHolder();
        SetDefinitionRsHolder rsBody = new SetDefinitionRsHolder();
        rqHead.setReceiverKey(new URI(targetService));
        rqHead.setSenderKey(new URI("http://interop.i-flow.com/ASAPClient/ObserverService.asmx"));
        rqBody.setProcessLanguage("XPDL");
        rqBody.setDefinition(new SetDefinitionRqDefinition());
        String s = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xpdl:Package Id=\"Application_Repository\"              Name=\"Application Repository\"              xmlns=\"http://www.wfmc.org/2002/XPDL1.0\"              xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\"              xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"              xsi:schemaLocation=\"http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">      <xpdl:PackageHeader>      <xpdl:XPDLVersion>1.0</xpdl:XPDLVersion>      <xpdl:Vendor>Together</xpdl:Vendor>      <xpdl:Created>13-03-2003</xpdl:Created>      <xpdl:Description>Application repository for modified WfMC example of business process</xpdl:Description>   </xpdl:PackageHeader>   <xpdl:RedefinableHeader PublicationStatus=\"RELEASED\"/>   <xpdl:ConformanceClass GraphConformance=\"NON_BLOCKED\"/>   <xpdl:Script Type=\"text/javascript\"/></xpdl:Package>";
        byte[] a = s.getBytes("UTF8");
        System.err.println("$$" + a.length);
        Document b = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(a));
        MessageElement main = this.convertToMessageElement(b.getFirstChild());
        rqBody.getDefinition().set_any(new MessageElement[]{main});
        binding.setDefinition(rqHead, rqBody, rsHead, rsBody);
    }

    private MessageElement convertToMessageElement(Node node) throws SOAPException {
        NodeList children;
        if (3 == node.getNodeType()) {
            return new MessageElement((CharacterData)node);
        }
        MessageElement ret = new MessageElement(node.getNodeName(), "xpdl", "http://www.wfmc.org/2002/XPDL1.0");
        NamedNodeMap atts = node.getAttributes();
        if (null != atts) {
            for (int i = 0; i < atts.getLength(); ++i) {
                Node att = atts.item(i);
                ret.addAttribute("", att.getNodeName(), att.getNodeValue());
            }
        }
        if (null != (children = node.getChildNodes())) {
            for (int i = 0; i < children.getLength(); ++i) {
                MessageElement r = this.convertToMessageElement(children.item(i));
                if (null == r) continue;
                ret.addChild(r);
            }
        }
        return ret;
    }

    private WfXmlFactoryBindingStub getFactoryBinding() throws MalformedURLException {
        WfXmlFactoryBindingStub ret;
        try {
            ret = (WfXmlFactoryBindingStub)swsl.getwfxmlFactoryBinding(new URL(targetService));
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        CookbookTestCase.assertNotNull((String)"binding is null", (Object)ret);
        ret.setTimeout(60000);
        return ret;
    }

    private WfXmlRegistryBindingStub getRegistryBinding() throws MalformedURLException {
        WfXmlRegistryBindingStub ret;
        try {
            ret = (WfXmlRegistryBindingStub)swsl.getwfxmlRegistryBinding(new URL("http://vajat:8080/axis/services/wfxmlRegistryBinding"));
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        CookbookTestCase.assertNotNull((String)"binding is null", (Object)ret);
        ret.setTimeout(60000);
        return ret;
    }
}

