/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.wfxml;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.rmi.RemoteException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.enhydra.shark.Shark;
import org.enhydra.shark.asap.AsapBindingUtilitiesImpl;
import org.enhydra.shark.asap.AsapFactoryBindingImpl;
import org.enhydra.shark.asap.types.Request;
import org.enhydra.shark.asap.types.holders.ResponseHolder;
import org.enhydra.shark.wfxml.FactoryPortType;
import org.enhydra.shark.wfxml.SharkServiceImpl;
import org.enhydra.shark.wfxml.types.GetDefinitionRq;
import org.enhydra.shark.wfxml.types.GetDefinitionRs;
import org.enhydra.shark.wfxml.types.SetDefinitionRq;
import org.enhydra.shark.wfxml.types.SetDefinitionRs;
import org.enhydra.shark.wfxml.types.holders.GetDefinitionRsHolder;
import org.enhydra.shark.wfxml.types.holders.SetDefinitionRsHolder;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WfXmlFactoryBindingImpl
extends AsapFactoryBindingImpl
implements FactoryPortType {
    public void getDefinition(Request rqHead, GetDefinitionRq rqBody, ResponseHolder rsHead, GetDefinitionRsHolder rsBody) throws RemoteException {
        URI rqReceiverKey = AsapBindingUtilitiesImpl.turnHeads((Request)rqHead, (ResponseHolder)rsHead);
        rsBody.value = new GetDefinitionRs();
        try {
            byte[] a = Shark.getInstance().getAdminInterface().getPackageAdministration().getPackageContent(SharkServiceImpl.getAdminMiscUtilities().getProcessMgrPkgId(AsapBindingUtilitiesImpl.parseFactoryReceiverKey((URI)rqReceiverKey)));
            Document b = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(a));
            MessageElement main = this.convertToMessageElement(b.getFirstChild());
            rsBody.value.set_any(new MessageElement[]{main});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RemoteException(ex.getMessage());
        }
    }

    private MessageElement convertToMessageElement(Node node) throws SOAPException {
        NodeList children;
        if (3 == node.getNodeType()) {
            return new MessageElement((CharacterData)node);
        }
        MessageElement ret = new MessageElement(node.getNodeName(), "xpdl", "http://www.wfmc.org/2002/XPDL1.0");
        NamedNodeMap atts = node.getAttributes();
        if (null != atts) {
            for (int i = 0; i < atts.getLength(); ++i) {
                Node att = atts.item(i);
                ret.addAttribute("", att.getNodeName(), att.getNodeValue());
            }
        }
        if (null != (children = node.getChildNodes())) {
            for (int i = 0; i < children.getLength(); ++i) {
                MessageElement r = this.convertToMessageElement(children.item(i));
                if (null == r) continue;
                ret.addChild(r);
            }
        }
        return ret;
    }

    public void setDefinition(Request rqHead, SetDefinitionRq rqBody, ResponseHolder rsHead, SetDefinitionRsHolder rsBody) throws RemoteException {
        URI rqReceiverKey = AsapBindingUtilitiesImpl.turnHeads((Request)rqHead, (ResponseHolder)rsHead);
        rsBody.value = new SetDefinitionRs(rqBody.getDefinition().get_any());
        if (!"XPDL".equals(rqBody.getProcessLanguage())) {
            throw new RemoteException("Allowed value for process language is XPDL only!");
        }
        MessageElement m = rqBody.getDefinition().get_any()[0];
        String pkgId = m.getAttribute("Id");
        try {
            System.err.println("NAmiruSVI" + AsapBindingUtilitiesImpl.parseFactoryReceiverKey((URI)rqReceiverKey));
            System.err.println("NAmiruSVI" + pkgId);
            if (!AsapBindingUtilitiesImpl.parseFactoryReceiverKey((URI)rqReceiverKey).startsWith(pkgId)) {
                throw new RemoteException("Package Ids don't match, cannot continue.");
            }
            String relPath = "wfxml/" + System.currentTimeMillis() + ".xpdl";
            Document document = m.getAsDocument();
            DOMSource source = new DOMSource(document);
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, result);
            byte[] bytes = sw.toString().getBytes("UTF8");
            try {
                SharkServiceImpl.getRepositoryMgr().deletePackage(relPath);
            }
            catch (Exception _) {
                // empty catch block
            }
            SharkServiceImpl.getRepositoryMgr().uploadPackage(bytes, relPath);
            if (SharkServiceImpl.getPackageAdministration().isPackageOpened(pkgId)) {
                SharkServiceImpl.getPackageAdministration().updatePackage(pkgId, relPath);
            } else {
                SharkServiceImpl.getPackageAdministration().openPackage(relPath);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RemoteException(ex.getMessage());
        }
    }
}

