/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.asap.test;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.enhydra.shark.asap.AsapFactoryBindingStub;
import org.enhydra.shark.asap.AsapInstanceBindingStub;
import org.enhydra.shark.asap.SharkWebServiceLocator;
import org.enhydra.shark.asap.types.CreateInstanceRq;
import org.enhydra.shark.asap.types.CreateInstanceRqContextData;
import org.enhydra.shark.asap.types.InstancePropertiesGroup;
import org.enhydra.shark.asap.types.Request;
import org.enhydra.shark.asap.types.YesNoIfError;
import org.enhydra.shark.asap.types.holders.CreateInstanceRsHolder;
import org.enhydra.shark.asap.types.holders.GetPropertiesRsHolder;
import org.enhydra.shark.asap.types.holders.ResponseHolder;

public class CookbookTestCase
extends TestCase {
    private static SharkWebServiceLocator swsl = new SharkWebServiceLocator();
    private static URI ik;
    private static String targetService;
    public static final String TARGET_SERVICE = "asap.test.ts";
    public static final String DEFAULT_SERVICE = "http://vajat.prozone.co.yu:8080/axis/services/wfxmlFactoryBinding";

    public CookbookTestCase(String name) {
        super(name);
        targetService = System.getProperty(TARGET_SERVICE, DEFAULT_SERVICE);
        System.err.println("asap.test.ts:" + targetService);
    }

    public void testLevel1CreateProcess() throws Exception {
        AsapFactoryBindingStub binding = this.getFactroyBinding();
        Request rqHead = new Request();
        CreateInstanceRq rqBody = new CreateInstanceRq();
        ResponseHolder rsHead = new ResponseHolder();
        CreateInstanceRsHolder rsBody = new CreateInstanceRsHolder();
        rqHead.setReceiverKey(new URI(swsl.getasapFactoryBindingAddress()));
        rqHead.getReceiverKey().setQueryString("procDef=181&packageId=181");
        rqBody.setObserverKey(new URI(swsl.getasapObserverBindingAddress()));
        rqBody.getObserverKey().setHost(InetAddress.getLocalHost().getHostName());
        rqBody.setStartImmediately(true);
        MessageElement[] b = new MessageElement[2];
        b[0] = new MessageElement("", "product_code");
        b[0].setValue("52");
        b[1] = new MessageElement("", "product_quantity");
        b[1].setValue("69");
        rqBody.setContextData(new CreateInstanceRqContextData(b));
        binding.createInstance(rqHead, rqBody, rsHead, rsBody);
        ik = rsBody.value.getInstanceKey();
        System.out.println("InstanceKey is " + ik);
    }

    public void testLevel1GetPropsOfProcess() throws Exception {
        Thread.sleep(10000L);
        AsapInstanceBindingStub binding = this.getInstanceBinding(ik.toString());
        Request rqHead = new Request(null, ik, YesNoIfError.Yes, "");
        CreateInstanceRq rqBody = new CreateInstanceRq();
        ResponseHolder rsHead = new ResponseHolder();
        GetPropertiesRsHolder rsBody = new GetPropertiesRsHolder();
        binding.getProperties(rqHead, "", rsHead, rsBody);
        InstancePropertiesGroup props = rsBody.value.getInstancePropertiesGroup();
        System.err.println(props.getName());
        for (int i = 0; i < props.getResultData().get_any().length; ++i) {
            System.err.println(props.getResultData().get_any()[i].getName() + " = " + props.getResultData().get_any()[i].getValue());
        }
    }

    private AsapFactoryBindingStub getFactroyBinding() throws MalformedURLException {
        AsapFactoryBindingStub ret;
        try {
            ret = (AsapFactoryBindingStub)swsl.getasapFactoryBinding(new URL(targetService));
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        CookbookTestCase.assertNotNull((String)"binding is null", (Object)ret);
        ret.setTimeout(60000);
        return ret;
    }

    private AsapInstanceBindingStub getInstanceBinding(String s) throws MalformedURLException {
        AsapInstanceBindingStub ret;
        try {
            ret = (AsapInstanceBindingStub)swsl.getasapInstanceBinding(new URL(s));
        }
        catch (ServiceException jre) {
            if (jre.getLinkedCause() != null) {
                jre.getLinkedCause().printStackTrace();
            }
            throw new AssertionFailedError("JAX-RPC ServiceException caught: " + (Object)((Object)jre));
        }
        CookbookTestCase.assertNotNull((String)"binding is null", (Object)ret);
        ret.setTimeout(60000);
        return ret;
    }
}

