/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.asap;

import java.rmi.RemoteException;
import java.util.Map;
import javax.xml.rpc.holders.StringHolder;
import org.apache.axis.types.URI;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfRequester;
import org.enhydra.shark.asap.AsapBindingUtilitiesImpl;
import org.enhydra.shark.asap.InstancePortType;
import org.enhydra.shark.asap.RequesterImpl;
import org.enhydra.shark.asap.SharkServiceImpl;
import org.enhydra.shark.asap.types.ChangeStateRq;
import org.enhydra.shark.asap.types.ChangeStateRs;
import org.enhydra.shark.asap.types.ContextData;
import org.enhydra.shark.asap.types.GetPropertiesRs;
import org.enhydra.shark.asap.types.HistoryType;
import org.enhydra.shark.asap.types.InstancePropertiesGroup;
import org.enhydra.shark.asap.types.Observers;
import org.enhydra.shark.asap.types.Request;
import org.enhydra.shark.asap.types.ResultData;
import org.enhydra.shark.asap.types.SetPropertiesRq;
import org.enhydra.shark.asap.types.SetPropertiesRs;
import org.enhydra.shark.asap.types.SubscribeRq;
import org.enhydra.shark.asap.types.UnsubscribeRq;
import org.enhydra.shark.asap.types.holders.ChangeStateRsHolder;
import org.enhydra.shark.asap.types.holders.GetPropertiesRsHolder;
import org.enhydra.shark.asap.types.holders.ResponseHolder;
import org.enhydra.shark.asap.types.holders.SetPropertiesRsHolder;

public class AsapInstanceBindingImpl
implements InstancePortType {
    public void getProperties(Request rqHead, String rqBody, ResponseHolder rsHead, GetPropertiesRsHolder rsBody) throws RemoteException {
        try {
            URI rqReceiverKey = AsapBindingUtilitiesImpl.turnHeads(rqHead, rsHead);
            String procId = AsapBindingUtilitiesImpl.instanceURI2Id(rqReceiverKey);
            WfProcess p = SharkServiceImpl.getExecAdmin().getProcess(procId);
            RequesterImpl rr = (RequesterImpl)p.requester();
            Observers os = AsapBindingUtilitiesImpl.createObservers(rr.getObservers(rqReceiverKey));
            HistoryType ht = new HistoryType(AsapBindingUtilitiesImpl.extractEvents(p));
            InstancePropertiesGroup iProps = new InstancePropertiesGroup();
            iProps.setContextData(new ContextData(AsapBindingUtilitiesImpl.extractData(p.process_context(), p.key())));
            iProps.setDescription(p.description());
            iProps.setFactoryKey(AsapBindingUtilitiesImpl.createFactoryKey(p.manager().name()));
            iProps.setHistory(ht);
            iProps.setKey(rqReceiverKey);
            iProps.setName(p.name());
            iProps.setObservers(os);
            iProps.setResultData(new ResultData(AsapBindingUtilitiesImpl.extractData(p.result(), p.key())));
            iProps.setState(AsapBindingUtilitiesImpl.parseState(p.state()));
            iProps.setSubject("");
            rsBody.value = new GetPropertiesRs(iProps, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
    }

    public void setProperties(Request rqHead, SetPropertiesRq rqBody, ResponseHolder rsHead, SetPropertiesRsHolder rsBody) throws RemoteException {
        try {
            URI rqReceiverKey = AsapBindingUtilitiesImpl.turnHeads(rqHead, rsHead);
            String procId = AsapBindingUtilitiesImpl.instanceURI2Id(rqReceiverKey);
            WfProcess p = SharkServiceImpl.getExecAdmin().getProcess(procId);
            Map context = AsapBindingUtilitiesImpl.parseContext(rqBody.getData(), p);
            if (null != context) {
                p.set_process_context(context);
            }
            RequesterImpl rr = (RequesterImpl)p.requester();
            Observers os = AsapBindingUtilitiesImpl.createObservers(rr.getObservers(rqReceiverKey));
            HistoryType ht = new HistoryType(AsapBindingUtilitiesImpl.extractEvents(p));
            InstancePropertiesGroup iProps = new InstancePropertiesGroup();
            iProps.setContextData(new ContextData(AsapBindingUtilitiesImpl.extractData(p.process_context(), p.key())));
            iProps.setDescription(p.description());
            iProps.setFactoryKey(AsapBindingUtilitiesImpl.createFactoryKey(p.manager().name()));
            iProps.setHistory(ht);
            iProps.setKey(rqReceiverKey);
            iProps.setName(p.name());
            iProps.setObservers(os);
            iProps.setResultData(new ResultData(AsapBindingUtilitiesImpl.extractData(p.result(), p.key())));
            iProps.setState(AsapBindingUtilitiesImpl.parseState(p.state()));
            iProps.setSubject("");
            rsBody.value = new SetPropertiesRs(iProps, null, null);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void subscribe(Request rqHead, SubscribeRq rqBody, ResponseHolder rsHead, StringHolder rsBody) throws RemoteException {
        try {
            URI rqReceiverKey = AsapBindingUtilitiesImpl.turnHeads(rqHead, rsHead);
            String instanceId = AsapBindingUtilitiesImpl.instanceURI2Id(rqReceiverKey);
            WfProcess proc = SharkServiceImpl.getExecAdmin().getProcess(instanceId);
            RequesterImpl r = (RequesterImpl)proc.requester();
            r.addObserver(rqReceiverKey, rqBody.getObserverKey());
            proc.set_requester((WfRequester)r);
            rsBody.value = "";
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
    }

    public void unsubscribe(Request rqHead, UnsubscribeRq rqBody, ResponseHolder rsHead, StringHolder rsBody) throws RemoteException {
        try {
            URI rqReceiverKey = AsapBindingUtilitiesImpl.turnHeads(rqHead, rsHead);
            String instanceId = AsapBindingUtilitiesImpl.instanceURI2Id(rqReceiverKey);
            WfProcess proc = SharkServiceImpl.getExecAdmin().getProcess(instanceId);
            RequesterImpl r = (RequesterImpl)proc.requester();
            r.removeObserver(rqReceiverKey, rqBody.getObserverKey());
            proc.set_requester((WfRequester)r);
            rsBody.value = "";
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }

    public void changeState(Request rqHead, ChangeStateRq rqBody, ResponseHolder rsHead, ChangeStateRsHolder rsBody) throws RemoteException {
        try {
            URI rqReceiverKey = AsapBindingUtilitiesImpl.turnHeads(rqHead, rsHead);
            String instanceId = AsapBindingUtilitiesImpl.instanceURI2Id(rqReceiverKey);
            WfProcess p = SharkServiceImpl.getExecAdmin().getProcess(instanceId);
            p.change_state(AsapBindingUtilitiesImpl.parseState(rqBody.getState()));
            rsBody.value = new ChangeStateRs(AsapBindingUtilitiesImpl.parseState(p.state()));
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage());
        }
    }
}

