/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.asap;

import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.holders.StringHolder;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.timebase.UtcT;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.SourceNotAvailable;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfDataEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfEventAudit;
import org.enhydra.shark.api.client.wfmodel.WfExecutionObject;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfStateEventAudit;
import org.enhydra.shark.asap.AsapObserverBindingStub;
import org.enhydra.shark.asap.SharkServiceImpl;
import org.enhydra.shark.asap.SharkWebServiceLocator;
import org.enhydra.shark.asap.types.CompletedRq;
import org.enhydra.shark.asap.types.CompletedRqResultData;
import org.enhydra.shark.asap.types.CreateInstanceRqContextData;
import org.enhydra.shark.asap.types.Event;
import org.enhydra.shark.asap.types.EventEventType;
import org.enhydra.shark.asap.types.Observers;
import org.enhydra.shark.asap.types.Request;
import org.enhydra.shark.asap.types.Response;
import org.enhydra.shark.asap.types.SchemaType;
import org.enhydra.shark.asap.types.StateChangedRq;
import org.enhydra.shark.asap.types.StateType;
import org.enhydra.shark.asap.types.YesNoIfError;
import org.enhydra.shark.asap.types.holders.ResponseHolder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AsapBindingUtilitiesImpl {
    public static String[] allowedJavaTypes = new String[]{"java.lang.Long", "java.lang.Boolean", "java.lang.Double", "java.util.Date", "java.lang.String"};
    public static String[] allowedXMLTypes = new String[]{"xsd:long", "xsd:int", "xsd:boolean", "xsd:double", "xsd:double", "xsd:date", "xsd:string"};

    public static Object xmlTypeToDefaultValue(String xmlType) {
        Object val = null;
        if (xmlType.equals("xsd:long") || xmlType.equals("xsd:int")) {
            val = new Long(0L);
        } else if (xmlType.equals("xsd:boolean")) {
            val = new Boolean(false);
        } else if (xmlType.equals("xsd:double") || xmlType.equals("xsd:float")) {
            val = new Double(0.0);
        } else if (xmlType.equals("xsd:date")) {
            val = new Date();
        } else if (xmlType.equals("xsd:string")) {
            val = new String();
        }
        return val;
    }

    public static String parseFactoryReceiverKey(URI rqReceiverKey) throws Exception {
        String qString = rqReceiverKey.getQueryString();
        String procMgr = "test_bs#1#math_operations";
        if (null != qString) {
            String procDef = null;
            String packageId = null;
            int n = qString.indexOf("procDef=");
            if (n >= 0) {
                procDef = qString.substring(n + "procDef=".length());
                int i = procDef.indexOf(38);
                if (i > 0) {
                    procDef = procDef.substring(0, i);
                }
                if ((n = qString.indexOf("packageId=")) >= 0 && (i = (packageId = qString.substring(n + "packageId=".length())).indexOf(38)) > 0) {
                    packageId.substring(0, i);
                }
                procMgr = SharkServiceImpl.getExecAdmin().getProcessMgr(packageId, procDef).name();
            } else {
                n = qString.indexOf("procMgr=");
                if (n >= 0) {
                    procMgr = qString.substring(n + "procMgr=".length());
                    int i = procMgr.indexOf(38);
                    if (i > 0) {
                        procMgr = procMgr.substring(0, i);
                    }
                    procMgr = URLDecoder.decode(procMgr, "UTF-8");
                }
            }
        }
        return procMgr;
    }

    protected static void completeActivity(URI rqReceiverKey, CompletedRqResultData rd) {
        String qString = rqReceiverKey.getQueryString();
        if (null != qString) {
            String procId = null;
            String actId = null;
            String varId = null;
            String procIdStr = "procId=";
            String actIdStr = "actId=";
            String varIdStr = "varId=";
            int n = qString.indexOf(procIdStr);
            if (n >= 0) {
                procId = qString.substring(n + procIdStr.length());
                int i = procId.indexOf(38);
                if (i > 0) {
                    procId = procId.substring(0, i);
                }
                if ((n = qString.indexOf(actIdStr)) >= 0 && (i = (actId = qString.substring(n + actIdStr.length())).indexOf(38)) > 0) {
                    actId = actId.substring(0, i);
                }
                if ((n = qString.indexOf(varIdStr)) >= 0 && (i = (varId = qString.substring(n + varIdStr.length())).indexOf(38)) > 0) {
                    varId = varId.substring(0, i);
                }
                try {
                    Map<String, HashMap> r;
                    System.out.println("Searching for activity [" + procId + "," + actId + "]");
                    WfActivity act = SharkServiceImpl.getExecAdmin().getActivity(procId, actId);
                    if (null != varId) {
                        HashMap res = AsapBindingUtilitiesImpl.retrieveContextVariables(rd.get_any());
                        r = new HashMap();
                        System.out.println("Putting results " + res + "in variable " + varId);
                        r.put(varId, res);
                    } else {
                        System.out.println("Putting results into activity context " + actId);
                        r = AsapBindingUtilitiesImpl.parseContext(rd.get_any(), act.container().manager().context_signature());
                    }
                    act.set_result(r);
                    act.complete();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    protected static Map parseContext(CreateInstanceRqContextData rqContextData, WfProcess p) throws Exception {
        if (null != rqContextData && null != rqContextData.get_any()) {
            return AsapBindingUtilitiesImpl.parseContext(rqContextData.get_any(), p.manager().context_signature());
        }
        return new HashMap();
    }

    protected static Map parseContext(Object rqContextData, WfProcess p) throws Exception {
        if (null != rqContextData) {
            return AsapBindingUtilitiesImpl.parseContext((MessageElement[])rqContextData, p.manager().context_signature());
        }
        return new HashMap();
    }

    protected static Map parseContext(MessageElement[] a, Map csig) throws Exception {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (int i = 0; i < a.length; ++i) {
            String n = a[i].getName();
            if (!csig.containsKey(n)) {
                System.err.println("WARNING:Variable " + n + " doesn't match context signiture!");
                continue;
            }
            String value = a[i].getValue();
            String t = (String)csig.get(n);
            try {
                Date dd;
                if (t.equals("java.lang.String")) {
                    if (value != null) {
                        ret.put(n, value);
                        continue;
                    }
                    ret.put(n, "");
                    continue;
                }
                if (value == null) {
                    value = "0";
                }
                if (t.equals("java.lang.Long")) {
                    ret.put(n, new Long(value));
                    continue;
                }
                if (t.equals("java.lang.Boolean")) {
                    ret.put(n, new Boolean(value));
                    continue;
                }
                if (t.equals("java.lang.Double")) {
                    ret.put(n, new Double(value));
                    continue;
                }
                if (!t.equals("java.util.Date")) continue;
                try {
                    dd = DateFormat.getDateInstance().parse(value);
                }
                catch (Exception _) {
                    dd = new Date(0L);
                }
                ret.put(n, dd);
                continue;
            }
            catch (Exception ex) {
                ret.put(n, null);
                System.out.println("Value " + a[i].getValue() + " can't be converted to type " + t + " - setting null value");
            }
        }
        return ret;
    }

    public static SchemaType getContextDataSchema(Map contextSigniture) {
        SchemaType cdt = new SchemaType();
        MessageElement[] mes = new MessageElement[]{AsapBindingUtilitiesImpl.getSchemaElement("ContextDataType", contextSigniture)};
        cdt.set_any(mes);
        return cdt;
    }

    protected static SchemaType getResultDataSchema(Map resultSigniture) {
        SchemaType rdt = new SchemaType();
        MessageElement[] mes = new MessageElement[]{AsapBindingUtilitiesImpl.getSchemaElement("ResultDataType", resultSigniture)};
        rdt.set_any(mes);
        return rdt;
    }

    public static Map getContextSigniture(SchemaType cdt) {
        return AsapBindingUtilitiesImpl.getSigniture(cdt.get_any());
    }

    public static Map getResultSigniture(SchemaType rdt) {
        return AsapBindingUtilitiesImpl.getSigniture(rdt.get_any());
    }

    private static Map getSigniture(MessageElement[] mes) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        try {
            System.out.println("mes-length=" + mes.length);
            MessageElement main = mes[0];
            Node sequence = main.getFirstChild().getFirstChild();
            NodeList cnodes = sequence.getChildNodes();
            List<String> allowedXMLT = Arrays.asList(allowedXMLTypes);
            for (int i = 0; i < cnodes.getLength(); ++i) {
                Node n = cnodes.item(i);
                NamedNodeMap nnm = n.getAttributes();
                String name = AsapBindingUtilitiesImpl.getAttributeValue(nnm, "name");
                String type = AsapBindingUtilitiesImpl.getAttributeValue(nnm, "type");
                m.put(name, AsapBindingUtilitiesImpl.xmlTypeToDefaultValue(type));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return m;
    }

    private static MessageElement getSchemaElement(String ctName, Map signiture) {
        MessageElement main = new MessageElement("schema", "xsd", "http://www.w3.org/2001/XMLSchema");
        main.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        main.setAttribute("targetNamespace", "http://shark.objectweb.org/");
        MessageElement main2 = new MessageElement("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
        main2.setAttribute("name", ctName);
        MessageElement sequence = new MessageElement("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
        try {
            main.addChild(main2);
            main2.addChild(sequence);
            Iterator it = signiture.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String javaClass = me.getValue().toString();
                String xsdType = null;
                if (javaClass.equals("java.lang.Boolean")) {
                    xsdType = "xsd:boolean";
                } else if (javaClass.equals("java.lang.String")) {
                    xsdType = "xsd:string";
                } else if (javaClass.equals("java.lang.Long")) {
                    xsdType = "xsd:long";
                } else if (javaClass.equals("java.lang.Double")) {
                    xsdType = "xsd:double";
                } else if (javaClass.equals("java.util.Date")) {
                    xsdType = "xsd:date";
                }
                if (xsdType == null) continue;
                MessageElement el = new MessageElement("element", "xsd", "http://www.w3.org/2001/XMLSchema");
                el.setAttribute("name", me.getKey().toString());
                el.setAttribute("type", xsdType);
                el.setAttribute("minOccurs", "0");
                sequence.addChild(el);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return main;
    }

    public static CreateInstanceRqContextData getContextData(Map m, String schemaLocation) {
        CreateInstanceRqContextData cd = new CreateInstanceRqContextData();
        cd.set_any(AsapBindingUtilitiesImpl.prepareContextVariables(m, schemaLocation));
        return cd;
    }

    protected static MessageElement[] prepareContextVariables(Map m, String schemaLocation) {
        ArrayList<MessageElement> main = new ArrayList<MessageElement>();
        try {
            Iterator it = m.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String element = me.getKey().toString();
                Object value = me.getValue();
                String valueStr = String.valueOf(me.getValue());
                if (value instanceof Date) {
                    valueStr = new SimpleDateFormat("yyyy-MM-dd").format(value);
                }
                String _prefix = "";
                if (schemaLocation.length() > 0) {
                    _prefix = "pd";
                }
                MessageElement el = new MessageElement(element, _prefix, schemaLocation);
                el.setValue(valueStr);
                main.add(el);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("main=" + main);
        MessageElement[] els = new MessageElement[main.size()];
        main.toArray(els);
        return els;
    }

    private static HashMap retrieveContextVariables(MessageElement[] mes) {
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            System.out.println("mes-length=" + mes.length);
            for (int i = 0; i < mes.length; ++i) {
                MessageElement me = mes[i];
                System.out.println("mes=" + me);
                String name = me.getName();
                String value = me.getValue();
                m.put(name, value);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return m;
    }

    protected static String parseState(StateType rqState) throws Exception {
        if (StateType.value1.equals((Object)rqState)) {
            return "open.not_running.not_started";
        }
        if (StateType.value2.equals((Object)rqState)) {
            return "open.not_running.suspended";
        }
        if (StateType.value3.equals((Object)rqState)) {
            return "open.running";
        }
        if (StateType.value4.equals((Object)rqState)) {
            return "closed.completed";
        }
        if (StateType.value5.equals((Object)rqState)) {
            return "closed.terminated";
        }
        if (StateType.value6.equals((Object)rqState)) {
            return "closed.terminated";
        }
        if (StateType.value7.equals((Object)rqState)) {
            return "closed.aborted";
        }
        throw new Exception("Argh!");
    }

    public static StateType parseState(String rqState) throws Exception {
        if ("open.not_running.not_started".equals(rqState)) {
            return StateType.value1;
        }
        if ("open.not_running.suspended".equals(rqState)) {
            return StateType.value2;
        }
        if ("open.running".equals(rqState)) {
            return StateType.value3;
        }
        if ("closed.completed".equals(rqState)) {
            return StateType.value4;
        }
        if ("closed.terminated".equals(rqState)) {
            return StateType.value5;
        }
        if ("closed.terminated".equals(rqState)) {
            return StateType.value6;
        }
        if ("closed.aborted".equals(rqState)) {
            return StateType.value7;
        }
        throw new Exception("Argh!");
    }

    protected static URI instanceId2URI(String string) throws Exception {
        URI instanceURI = new URI(new SharkWebServiceLocator().getasapInstanceBindingAddress());
        AsapBindingUtilitiesImpl.imprintURI(instanceURI);
        instanceURI.setQueryString("procInst=" + string);
        return instanceURI;
    }

    public static void imprintURI(URI factoryURI) throws URI.MalformedURIException {
        String[] a = MessageContext.getCurrentContext().getRequestMessage().getMimeHeaders().getHeader("X-Forwarded-Host");
        if (null != a && a.length > 0 && null != a[a.length - 1]) {
            URI tmp = new URI("http://" + a[a.length - 1]);
            factoryURI.setHost(tmp.getHost());
            factoryURI.setPort(tmp.getPort());
        }
    }

    protected static String instanceURI2Id(URI instanceURI) throws Exception {
        String string = instanceURI.getQueryString();
        return string.substring("procInst=".length());
    }

    protected static Event[] extractEvents(WfProcess p) throws Exception {
        WfEventAudit[] q = p.get_sequence_history(0);
        ArrayList<Event> list = new ArrayList<Event>();
        for (int n = 0; n < q.length; ++n) {
            if (!(q[n] instanceof WfStateEventAudit) || null == ((WfStateEventAudit)q[n]).old_state()) continue;
            Event e = new Event();
            e.setDetails(null);
            e.setEventType(AsapBindingUtilitiesImpl.parseEvent(q[n].event_type()));
            WfStateEventAudit sea = (WfStateEventAudit)q[n];
            e.setNewState(AsapBindingUtilitiesImpl.parseState(sea.new_state()));
            e.setOldState(AsapBindingUtilitiesImpl.parseState(sea.old_state()));
            e.setSourceKey(null);
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(q[n].time_stamp().getTime());
            e.setTime(c);
            list.add(e);
        }
        Event[] ret = new Event[list.size()];
        list.toArray(ret);
        return ret;
    }

    protected static EventEventType parseEvent(String string) {
        if (string.equals("processCreated")) {
            return EventEventType.InstanceCreated;
        }
        if (string.equals("activityContextChanged")) {
            return EventEventType.PropertiesSet;
        }
        if (string.equals("processContextChanged")) {
            return EventEventType.PropertiesSet;
        }
        if (string.equals("activityResultChanged")) {
            return EventEventType.PropertiesSet;
        }
        if (string.equals("activityStateChanged")) {
            return EventEventType.StateChanged;
        }
        if (string.equals("processStateChanged")) {
            return EventEventType.StateChanged;
        }
        new Throwable("Event not found " + string).printStackTrace();
        return EventEventType.Error;
    }

    protected static URI createFactoryKey(String string) throws Exception {
        URI factoryURI = new URI(SharkServiceImpl.factoryBindingAddress);
        AsapBindingUtilitiesImpl.imprintURI(factoryURI);
        factoryURI.setQueryString("procMgr=" + URLEncoder.encode(string, "UTF-8"));
        return factoryURI;
    }

    protected static MessageElement[] extractData(Map context, String prefix) throws RootException {
        ArrayList<MessageElement> mels = new ArrayList<MessageElement>();
        try {
            List<String> allowedJTs = Arrays.asList(allowedJavaTypes);
            Iterator it = context.entrySet().iterator();
            System.out.println("Extracting data for context " + context);
            while (it.hasNext()) {
                Map.Entry me = it.next();
                String varId = me.getKey().toString();
                Object varVal = me.getValue();
                if (!allowedJTs.contains(varVal.getClass().getName())) continue;
                MessageElement mel = new MessageElement("http://shark.objectweb.org/", varId, varVal);
                mels.add(mel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        MessageElement[] main = new MessageElement[mels.size()];
        mels.toArray(main);
        System.out.println("Extracting data result is  " + mels);
        return main;
    }

    public static URI turnHeads(Request rqHead, ResponseHolder rsHead) throws RemoteException {
        URI rqReceiverKey = rqHead.getReceiverKey();
        if (null == rqReceiverKey || 0 == rqReceiverKey.toString().length()) {
            throw new RemoteException("Invalid receiver key!!!");
        }
        String rqRequestID = rqHead.getRequestID();
        YesNoIfError rqResponseRequired = rqHead.getResponseRequired();
        URI rqSenderKey = rqHead.getSenderKey();
        rsHead.value = new Response(rqReceiverKey, rqSenderKey, rqRequestID);
        return rqReceiverKey;
    }

    protected static void notifyObservers(final String procId, final String myURI, final Map result, final String new_state, final String old_state, final Set observers) throws Exception {
        Thread notifier = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CompletedRqResultData crrd;
                StateType o;
                StateType n;
                URI instanceURI;
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    instanceURI = new URI(myURI);
                    n = AsapBindingUtilitiesImpl.parseState(new_state);
                    o = AsapBindingUtilitiesImpl.parseState(old_state);
                    crrd = new_state.startsWith("closed") ? new CompletedRqResultData(AsapBindingUtilitiesImpl.extractData(result, procId)) : null;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return;
                }
                Request rqh = new Request();
                StateChangedRq srqb = new StateChangedRq();
                CompletedRq crqb = new CompletedRq();
                ResponseHolder rsh = new ResponseHolder();
                rqh.setSenderKey(instanceURI);
                srqb.setState(n);
                srqb.setPreviousState(o);
                crqb.setInstanceKey(instanceURI);
                crqb.setResultData(crrd);
                StringHolder rsb = new StringHolder();
                boolean notified = false;
                boolean finished = null != crrd;
                System.err.println("finished:" + finished + " notified:" + notified);
                System.out.println("Notifying observers " + observers + " about event");
                int maxCnt = 5;
                do {
                    ArrayList obCopy = new ArrayList(observers);
                    int cnt = 0;
                    while (0 < obCopy.size()) {
                        Iterator iter = obCopy.iterator();
                        while (iter.hasNext()) {
                            Object var20_22;
                            boolean exc = false;
                            try {
                                block13: {
                                    try {
                                        String element = iter.next().toString();
                                        AsapObserverBindingStub binding = (AsapObserverBindingStub)new SharkWebServiceLocator().getasapObserverBinding(new URL(element));
                                        binding.setTimeout(60000);
                                        rqh.setReceiverKey(new URI(element));
                                        if (!notified) {
                                            binding.stateChanged(rqh, srqb, rsh, rsb);
                                            System.out.println("Observer " + element + " notified about state change.");
                                            break block13;
                                        }
                                        if (!finished) break block13;
                                        binding.completed(rqh, crqb, rsh, rsb);
                                        System.out.println("Observer " + element + " notified about process complete event.");
                                    }
                                    catch (Throwable e) {
                                        exc = true;
                                        e.printStackTrace();
                                        var20_22 = null;
                                        if (exc && cnt < maxCnt) continue;
                                        iter.remove();
                                        continue;
                                    }
                                }
                                var20_22 = null;
                                if (exc && cnt < maxCnt) continue;
                                iter.remove();
                            }
                            catch (Throwable throwable) {
                                var20_22 = null;
                                if (!exc || cnt >= maxCnt) {
                                    iter.remove();
                                }
                                throw throwable;
                            }
                        }
                        ++cnt;
                    }
                    boolean bl = notified = !notified;
                } while (finished && notified);
            }
        };
        notifier.start();
    }

    public static Observers createObservers(Set observerKeys) throws Exception {
        URI[] ret = new URI[observerKeys.size()];
        Iterator it = observerKeys.iterator();
        int i = 0;
        while (it.hasNext()) {
            Object __o = it.next();
            ret[i] = new URI(__o.toString());
            ++i;
        }
        Observers os = new Observers(ret);
        return os;
    }

    private static String getAttributeValue(NamedNodeMap nnm, String attrName) {
        try {
            Node attrib = nnm.getNamedItem(attrName);
            if (attrib.hasChildNodes()) {
                return attrib.getChildNodes().item(0).getNodeValue();
            }
            return attrib.getNodeValue();
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static boolean sendEventToActivity(URI rqReceiverKey, final String rqInstanceUri, CompletedRqResultData rqResultData, final String oldState, final String newState) {
        try {
            WfActivity act = AsapBindingUtilitiesImpl.findActivityFromURI(rqReceiverKey);
            final UtcT now = new UtcT(System.currentTimeMillis(), 0, 0, 0);
            if (null != rqResultData) {
                final HashMap data = AsapBindingUtilitiesImpl.retrieveContextVariables(rqResultData.get_any());
                WfDataEventAudit a = new WfDataEventAudit(){

                    public Map old_data() throws BaseException {
                        return null;
                    }

                    public Map new_data() throws BaseException {
                        return data;
                    }

                    public WfExecutionObject source() throws BaseException, SourceNotAvailable {
                        return null;
                    }

                    public WfExecutionObject source(SharkTransaction t) throws BaseException, SourceNotAvailable {
                        return null;
                    }

                    public UtcT time_stamp() throws BaseException {
                        return now;
                    }

                    public String event_type() throws BaseException {
                        return null;
                    }

                    public String activity_key() throws BaseException {
                        return "";
                    }

                    public String activity_name() throws BaseException {
                        return "";
                    }

                    public String process_key() throws BaseException {
                        return "";
                    }

                    public String process_name() throws BaseException {
                        return rqInstanceUri;
                    }

                    public String process_mgr_name() throws BaseException {
                        return "";
                    }

                    public String process_mgr_version() throws BaseException {
                        return "";
                    }
                };
                act.receive_event((WfEventAudit)a);
            }
            if (null != newState) {
                WfStateEventAudit b = new WfStateEventAudit(){

                    public String old_state() throws BaseException {
                        return oldState;
                    }

                    public String new_state() throws BaseException {
                        return newState;
                    }

                    public WfExecutionObject source() throws BaseException, SourceNotAvailable {
                        return null;
                    }

                    public WfExecutionObject source(SharkTransaction t) throws BaseException, SourceNotAvailable {
                        return null;
                    }

                    public UtcT time_stamp() throws BaseException {
                        return now;
                    }

                    public String event_type() throws BaseException {
                        return null;
                    }

                    public String activity_key() throws BaseException {
                        return "";
                    }

                    public String activity_name() throws BaseException {
                        return "";
                    }

                    public String process_key() throws BaseException {
                        return "";
                    }

                    public String process_name() throws BaseException {
                        return rqInstanceUri;
                    }

                    public String process_mgr_name() throws BaseException {
                        return "";
                    }

                    public String process_mgr_version() throws BaseException {
                        return "";
                    }
                };
                act.receive_event((WfEventAudit)b);
            }
        }
        catch (Throwable _) {
            return false;
        }
        return true;
    }

    protected static WfActivity findActivityFromURI(URI anUri) throws Exception {
        String qString = anUri.getQueryString();
        String procId = "";
        String actId = "";
        if (null != qString) {
            String procIdStr = "procId=";
            String actIdStr = "actId=";
            int n = qString.indexOf(procIdStr);
            if (n >= 0) {
                procId = qString.substring(n + procIdStr.length());
                int i = procId.indexOf(38);
                if (i > 0) {
                    procId = procId.substring(0, i);
                }
                if ((n = qString.indexOf(actIdStr)) >= 0 && (i = (actId = qString.substring(n + actIdStr.length())).indexOf(38)) > 0) {
                    actId = actId.substring(0, i);
                }
            }
        }
        return SharkServiceImpl.getExecAdmin().getActivity(procId, actId);
    }
}

