/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.expressionbuilders;

import java.util.Iterator;
import java.util.Properties;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.common.ProcessIteratorExpressionBuilder;
import org.enhydra.shark.expressionbuilders.BasicExpressionBuilder;

public class ProcessIteratorExpressionBuilderDODS
extends BasicExpressionBuilder
implements ProcessIteratorExpressionBuilder {
    private static final String sqlProcDefName = " PDefName ";
    private static final String sqlId = " Id ";
    private static final String sqlName = " Name ";
    private static final String sqlState = " State ";
    private static final String sqlPriority = " Priority ";
    private static final String sqlCreated = " Created ";
    private static final String sqlStarted = " Started ";
    private static final String sqlLastStateTime = " LastStateTime ";
    private static final String sqlResourceRequesterId = " ResourceRequesterId ";

    public ProcessIteratorExpressionBuilderDODS(Properties p) {
        super(p);
    }

    public ProcessIteratorExpressionBuilder and() {
        this.operator = 1;
        return this;
    }

    public ProcessIteratorExpressionBuilder or() {
        this.operator = 2;
        return this;
    }

    public ProcessIteratorExpressionBuilder not() {
        this.operator |= 4;
        return this;
    }

    public ProcessIteratorExpressionBuilder addPackageIdEquals(String exp) {
        this.addEqualsWithSubQuery("packageId", " ProcessDefinition ", "IN (SELECT " + this.objectid_column_name + " FROM ProcessDefinitions WHERE PackageId = ", exp, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addProcessDefIdEquals(String exp) {
        this.addEqualsWithSubQuery("processDefinitionId", " ProcessDefinition ", "IN (SELECT " + this.objectid_column_name + " FROM ProcessDefinitions WHERE ProcessDefinitionId = ", exp, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addMgrNameEquals(String exp) {
        this.addEqualsWithSubQuery("mgrName", " ProcessDefinition ", "IN (SELECT " + this.objectid_column_name + " FROM ProcessDefinitions WHERE Name = ", exp, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addVersionEquals(String exp) {
        this.addEqualsWithSubQuery("version", " ProcessDefinition ", "IN (SELECT " + this.objectid_column_name + " FROM ProcessDefinitions WHERE ProcessDefinitionVersion = ", exp, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addIsMgrEnabled() {
        this.addEqualsWithSubQuery("enabled", " ProcessDefinition ", "IN (SELECT " + this.objectid_column_name + " FROM ProcessDefinitions WHERE State = ", "0", ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addStateEquals(String arg) {
        this.addEqualsWithSubQuery("state", sqlState, "IN (SELECT " + this.objectid_column_name + " FROM ProcessStates WHERE Name = ", arg, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addStateStartsWith(String arg) {
        this.addStartsWithSubQuery("state", sqlState, "IN (SELECT " + this.objectid_column_name + " FROM ProcessStates WHERE Name LIKE ", arg, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addIdEquals(String arg) {
        this.addEquals("key", sqlId, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addNameEquals(String arg) {
        this.addEquals("name", sqlName, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addPriorityEquals(int arg) {
        this.addEquals("priority", sqlPriority, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addDescriptionEquals(String arg) {
        this.addEquals("description", " Description ", arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addDescriptionContains(String arg) {
        this.addContains("description", " Description ", arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addRequesterIdEquals(String arg) {
        this.addEqualsWithSubQueryTwice("requesterId", sqlId, "IN (SELECT Id FROM ProcessRequesters WHERE ActivityRequester IN (SELECT " + this.objectid_column_name + "FROM Activities WHERE Id = ", arg, ") OR ResourceRequester IN (SELECT " + this.objectid_column_name + "FROM ResourcesTable WHERE Username = ", ")) ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addRequesterUsernameEquals(String arg) {
        this.addEquals("resourceRequesterId", sqlResourceRequesterId, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addCreatedTimeEquals(long arg) {
        this.addEquals("createdTime_ms", sqlCreated, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addCreatedTimeBefore(long arg) {
        this.addLessThan("createdTime_ms", sqlCreated, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addCreatedTimeAfter(long arg) {
        this.addGreaterThan("startTime_ms", sqlCreated, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addStartTimeEquals(long arg) {
        this.addEquals("startTime_ms", sqlStarted, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addStartTimeBefore(long arg) {
        this.addLessThan("startTime_ms", sqlStarted, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addStartTimeAfter(long arg) {
        this.addGreaterThan("startTime_ms", sqlStarted, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addLastStateTimeEquals(long arg) {
        this.addEquals("lastStateTime_ms", sqlLastStateTime, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addLastStateTimeBefore(long arg) {
        this.addLessThan("lastStateTime_ms", sqlLastStateTime, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addLastStateTimeAfter(long arg) {
        this.addGreaterThan("lastStateTime_ms", sqlLastStateTime, arg);
        return this;
    }

    public ProcessIteratorExpressionBuilder addActiveActivitiesCountEquals(long arg) {
        String javaName = "activeActivitiesNo";
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".longValue()==" + arg + " ");
        this.sqlExpression.add("1 = 1");
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
        this.sqlComplete = false;
        return this;
    }

    public ProcessIteratorExpressionBuilder addActiveActivitiesCountGreaterThan(long arg) {
        String javaName = "activeActivitiesNo";
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".longValue()>" + arg + " ");
        this.sqlExpression.add("1 = 1");
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
        this.sqlComplete = false;
        return this;
    }

    public ProcessIteratorExpressionBuilder addActiveActivitiesCountLessThan(long arg) {
        String javaName = "activeActivitiesNo";
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".longValue()<" + arg + " ");
        this.sqlExpression.add("1 = 1");
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
        this.sqlComplete = false;
        return this;
    }

    public ProcessIteratorExpressionBuilder addVariableEquals(String vName, Object vValue) throws RootException {
        if (vValue instanceof String) {
            this.addVariableEquals(vName, (String)vValue);
        } else if (vValue instanceof Long) {
            this.addVariableEquals(vName, (Long)vValue);
        } else if (vValue instanceof Double) {
            this.addVariableEquals(vName, (Double)vValue);
        } else if (vValue instanceof Boolean) {
            this.addEqualsWithSubQuery("context_" + vName, this.objectid_column_name, "IN (SELECT Process FROM ProcessData" + (this.usingStandardVariableModel ? "" : "WOB") + " WHERE VariableValueBOOL = ", (Boolean)vValue != false ? 1L : 0L, ") ");
        } else {
            throw new RootException("Class " + vValue.getClass().getName() + " not supported");
        }
        return this;
    }

    public ProcessIteratorExpressionBuilder addVariableEquals(String vName, String vValue) {
        this.addEqualsWithSubQuery("context_" + vName, this.objectid_column_name, "IN (SELECT Process FROM ProcessData" + (this.usingStandardVariableModel ? "" : "WOB") + " WHERE VariableValueVCHAR = ", vValue, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addVariableEquals(String vName, long vValue) {
        this.addEqualsWithSubQuery("context_" + vName, this.objectid_column_name, "IN (SELECT Process FROM ProcessData" + (this.usingStandardVariableModel ? "" : "WOB") + " WHERE VariableValueLONG = ", vValue, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addVariableGreaterThan(String vName, long vValue) {
        this.addGreaterThanWithSubQuery("context_" + vName, this.objectid_column_name, "IN (SELECT Process FROM ProcessData" + (this.usingStandardVariableModel ? "" : "WOB") + " WHERE VariableValueLONG ", vValue, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addVariableLessThan(String vName, long vValue) {
        this.addLessThanWithSubQuery("context_" + vName, this.objectid_column_name, "IN (SELECT Process FROM ProcessData" + (this.usingStandardVariableModel ? "" : "WOB") + " WHERE VariableValueLONG ", vValue, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addVariableEquals(String vName, double vValue) {
        this.addEqualsWithSubQuery("context_" + vName, this.objectid_column_name, "IN (SELECT Process FROM ProcessData" + (this.usingStandardVariableModel ? "" : "WOB") + " WHERE VariableValueDBL = ", vValue, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addVariableGreaterThan(String vName, double vValue) {
        this.addGreaterThanWithSubQuery("context_" + vName, this.objectid_column_name, "IN (SELECT Process FROM ProcessData" + (this.usingStandardVariableModel ? "" : "WOB") + " WHERE VariableValueDBL ", vValue, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addVariableLessThan(String vName, double vValue) {
        this.addLessThanWithSubQuery("context_" + vName, this.objectid_column_name, "IN (SELECT Process FROM ProcessData" + (this.usingStandardVariableModel ? "" : "WOB") + " WHERE VariableValueDBL ", vValue, ") ");
        return this;
    }

    public ProcessIteratorExpressionBuilder addExpression(String exp) {
        this.sqlComplete = false;
        this.appendOperator(false);
        this.bshExpression.add(exp);
        return this;
    }

    public ProcessIteratorExpressionBuilder addExpression(ProcessIteratorExpressionBuilder eb) {
        this.appendOperator(eb.isComplete());
        this.bshExpression.add(eb);
        this.sqlExpression.add(eb);
        Iterator it = ((BasicExpressionBuilder)eb).propertiesUsed.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (this.propertiesUsed.contains(element)) continue;
            this.propertiesUsed.add(element);
        }
        this.sqlComplete |= eb.isComplete();
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderByMgrName(boolean ascending) {
        super.setOrderBy(sqlProcDefName, ascending);
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderById(boolean ascending) {
        super.setOrderBy(sqlId, ascending);
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderByName(boolean ascending) {
        super.setOrderBy(sqlName, ascending);
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderByState(boolean ascending) {
        super.setOrderBy(sqlState, ascending);
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderByPriority(boolean ascending) {
        super.setOrderBy(sqlPriority, ascending);
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderByCreatedTime(boolean ascending) {
        super.setOrderBy(sqlCreated, ascending);
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderByStartTime(boolean ascending) {
        super.setOrderBy(sqlStarted, ascending);
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderByLastStateTime(boolean ascending) {
        super.setOrderBy(sqlLastStateTime, ascending);
        return this;
    }

    public ProcessIteratorExpressionBuilder setOrderByResourceRequesterId(boolean ascending) {
        super.setOrderBy(sqlLastStateTime, ascending);
        return this;
    }
}

