/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.expressionbuilders;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.enhydra.shark.api.common.ExpressionBuilder;

public abstract class BasicExpressionBuilder
implements Serializable {
    protected List bshExpression;
    protected List sqlExpression;
    protected List propertiesUsed;
    private String orderBy;
    protected boolean sqlComplete = true;
    protected int operator;
    protected char delimiter = (char)39;
    protected boolean usingStandardVariableModel;
    protected String objectid_column_name = " oid ";
    public static final String PARAM_NAME_STRING_DELIMITER = "ExpressionBuilder.StringDelimiter";
    public static final String PARAM_NAME_OBJECTID_COLUMN_NAME = "DatabaseManager.ObjectIdColumnName";
    public static final String PARAM_NAME_VARIABLE_MODEL = "DODSEventAuditManager.useStandardVariableDataModel";

    protected BasicExpressionBuilder(Properties p) {
        this.bshExpression = new ArrayList();
        this.sqlExpression = new ArrayList();
        this.propertiesUsed = new ArrayList();
        if (null != p) {
            this.objectid_column_name = " " + p.getProperty(PARAM_NAME_OBJECTID_COLUMN_NAME, "oid") + " ";
            this.usingStandardVariableModel = Boolean.valueOf(p.getProperty(PARAM_NAME_VARIABLE_MODEL, "true"));
            this.delimiter = p.getProperty(PARAM_NAME_STRING_DELIMITER, "'").charAt(0);
        }
    }

    protected char getDelimiter() {
        return this.delimiter;
    }

    protected char appendOperator(boolean sqlToo) {
        char ret = ' ';
        if (1 == (1 & this.operator)) {
            this.bshExpression.add(" && ");
            if (sqlToo) {
                this.sqlExpression.add(" AND ");
            }
        } else if (2 == (2 & this.operator)) {
            this.bshExpression.add("||");
            if (sqlToo) {
                this.sqlExpression.add(" OR ");
            }
        }
        if (4 == (4 & this.operator)) {
            ret = '!';
        }
        this.operator = 0;
        return ret;
    }

    protected void addEquals(String java_name, String sql_name, String value) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + java_name + ".equals(\"" + value + "\")");
        this.sqlExpression.add(sql_name + _notPrecedes + "= " + this.getDelimiter() + value + this.getDelimiter() + " ");
        if (!this.propertiesUsed.contains(java_name)) {
            this.propertiesUsed.add(java_name);
        }
    }

    protected void addEquals(String java_name, String sql_name, long value) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(java_name + ".longValue()" + _notPrecedes + "== " + value);
        this.sqlExpression.add(sql_name + _notPrecedes + "= " + value + " ");
        if (!this.propertiesUsed.contains(java_name)) {
            this.propertiesUsed.add(java_name);
        }
    }

    protected void addGreaterThan(String java_name, String sql_name, long value) {
        char _notPrecedes = this.appendOperator(true);
        String operator = ' ' == _notPrecedes ? " > " : " <= ";
        this.bshExpression.add(java_name + ".longValue()" + operator + value);
        this.sqlExpression.add(sql_name + operator + value + " ");
        if (!this.propertiesUsed.contains(java_name)) {
            this.propertiesUsed.add(java_name);
        }
    }

    protected void addLessThan(String java_name, String sql_name, long value) {
        char _notPrecedes = this.appendOperator(true);
        String operator = ' ' == _notPrecedes ? " < " : " >= ";
        this.bshExpression.add(java_name + ".longValue()" + operator + value);
        this.sqlExpression.add(sql_name + operator + value + " ");
        if (!this.propertiesUsed.contains(java_name)) {
            this.propertiesUsed.add(java_name);
        }
    }

    protected void addGreaterThanWithSubQuery(String javaName, String sqlName, String sqlInPart, long value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        String operator = ' ' == _notPrecedes ? " > " : " <= ";
        this.bshExpression.add(javaName + ".longValue()" + operator + value);
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + operator + value + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addLessThanWithSubQuery(String javaName, String sqlName, String sqlInPart, long value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        String operator = ' ' == _notPrecedes ? " < " : " >= ";
        this.bshExpression.add(javaName + ".longValue()" + operator + value);
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + operator + value + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addEqualsWithSubQuery(String javaName, String sqlName, String sqlInPart, long value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".longValue() == " + value);
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + value + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addGreaterThanWithSubQuery(String javaName, String sqlName, String sqlInPart, double value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        String operator = ' ' == _notPrecedes ? " > " : " <= ";
        this.bshExpression.add(javaName + ".doubleValue()" + operator + value);
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + operator + value + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addLessThanWithSubQuery(String javaName, String sqlName, String sqlInPart, double value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        String operator = ' ' == _notPrecedes ? " < " : " >= ";
        this.bshExpression.add(javaName + ".doubleValue()" + operator + value);
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + operator + value + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addEqualsWithSubQuery(String javaName, String sqlName, String sqlInPart, double value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".doubleValue() == " + value);
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + value + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addEqualsWithSubQuery(String javaName, String sqlName, String sqlInPart, String value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".equals(\"" + value + "\")");
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + this.getDelimiter() + value + this.getDelimiter() + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addEqualsWithSubQueryTwice(String javaName, String sqlName, String sqlInPart, String value, String sqlMiddlePart, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".equals(\"" + value + "\")");
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + this.getDelimiter() + value + this.getDelimiter() + sqlMiddlePart + this.getDelimiter() + value + this.getDelimiter() + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addStartsWithSubQuery(String javaName, String sqlName, String sqlInPart, String value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".startsWith(\"" + value + "\")");
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + this.getDelimiter() + value + "%" + this.getDelimiter() + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addContainsWithSubQuery(String javaName, String sqlName, String sqlInPart, String value, String sqlEndPart) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".indexOf(\"" + value + "\") != -1");
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + sqlInPart + this.getDelimiter() + "%" + value + "%" + this.getDelimiter() + sqlEndPart);
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected void addContains(String javaName, String sqlName, String value) {
        char _notPrecedes = this.appendOperator(true);
        this.bshExpression.add(_notPrecedes + javaName + ".indexOf(\"" + value + "\") != -1");
        this.sqlExpression.add(sqlName + (' ' == _notPrecedes ? "" : "NOT ") + " LIKE " + this.getDelimiter() + "%" + value + "%" + this.getDelimiter());
        if (!this.propertiesUsed.contains(javaName)) {
            this.propertiesUsed.add(javaName);
        }
    }

    protected String parseSQLArguments() {
        StringBuffer sql = new StringBuffer();
        Iterator i = this.sqlExpression.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ExpressionBuilder) {
                ExpressionBuilder eb = (ExpressionBuilder)o;
                sql.append("( " + eb.toSQL() + " )");
                continue;
            }
            if (!(o instanceof String)) continue;
            sql.append(o);
        }
        if (null != this.orderBy) {
            sql.append(this.orderBy);
        }
        return sql.toString();
    }

    protected String parseBshParameters() {
        StringBuffer bsh = new StringBuffer();
        Iterator i = this.bshExpression.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof ExpressionBuilder) {
                ExpressionBuilder eb = (ExpressionBuilder)o;
                bsh.append("( " + eb.toScript() + " )");
                continue;
            }
            if (!(o instanceof String)) continue;
            bsh.append(o);
        }
        return bsh.toString();
    }

    public boolean isComplete() {
        return this.sqlComplete;
    }

    protected String whatsUsed() {
        StringBuffer ret = new StringBuffer();
        Iterator iter = this.propertiesUsed.iterator();
        while (iter.hasNext()) {
            ret.append(iter.next()).append(" ");
        }
        return ret.toString();
    }

    public String toSQL() {
        return this.parseSQLArguments();
    }

    public String toScript() {
        return this.parseBshParameters();
    }

    public String toExpression() {
        StringBuffer ret = new StringBuffer();
        if (!this.isComplete()) {
            ret.append("/*FORCE*/\n");
        }
        if (0 < this.propertiesUsed.size()) {
            ret.append("/*used ").append(this.whatsUsed()).append(" used*/\n");
        }
        ret.append(this.toScript());
        if (0 < this.sqlExpression.size()) {
            ret.append("\n/*sql ").append(this.toSQL()).append(" sql*/");
        }
        return ret.toString();
    }

    public void setOrderBy(String column, boolean isAscending) {
        this.orderBy = " ORDER BY " + column + (isAscending ? " ASC" : " DESC");
    }
}

