/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.usergroup;

import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.LogicalDatabase;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.enhydra.dods.DODS;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.UserTransaction;
import org.enhydra.shark.api.internal.usergroup.UserGroupManager;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.usergroup.data.GroupDO;
import org.enhydra.shark.usergroup.data.GroupLinkDO;
import org.enhydra.shark.usergroup.data.GroupLinkQuery;
import org.enhydra.shark.usergroup.data.GroupQuery;
import org.enhydra.shark.usergroup.data.UserDO;
import org.enhydra.shark.usergroup.data.UserLinkDO;
import org.enhydra.shark.usergroup.data.UserLinkQuery;
import org.enhydra.shark.usergroup.data.UserQuery;
import org.enhydra.shark.usertransaction.SharkDODSUserTransaction;
import org.enhydra.shark.utilities.MiscUtilities;
import org.enhydra.shark.utilities.dods.DODSUtilities;

public class DODSUserGroupManager
implements UserGroupManager {
    private static final String LDB_PARAM_NAME = "DODSUserGroupManager.DatabaseName";
    private CallbackUtilities callback;
    private LogicalDatabase db = null;

    public void configure(CallbackUtilities cus) throws RootException {
        if (null == cus) {
            throw new RootException("Cannot configure without call back impl.");
        }
        this.callback = cus;
        DODSUtilities.init((Properties)this.callback.getProperties());
        String dbName = this.callback.getProperty(LDB_PARAM_NAME, DODS.getDatabaseManager().getDefaultDB());
        try {
            this.db = DODS.getDatabaseManager().findLogicalDatabase(dbName);
        }
        catch (DatabaseManagerException e) {
            throw new RootException("Couldn't find logical database.", (Throwable)e);
        }
        this.callback.debug("DODSUserGroupManager configured");
    }

    public List getAllGroupnames(UserTransaction t) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        ArrayList<String> ret = new ArrayList<String>();
        GroupQuery qry = new GroupQuery(dbt);
        try {
            GroupDO group;
            while (null != (group = qry.getNextDO())) {
                ret.add(group.getGroupid());
            }
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
        finally {
            this.endTransaction(t, dbt, false);
        }
        return ret;
    }

    public List getAllUsers(UserTransaction t) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        ArrayList<String> ret = new ArrayList<String>();
        UserQuery qry = new UserQuery(dbt);
        try {
            UserDO user;
            while (null != (user = qry.getNextDO())) {
                ret.add(user.getUserid());
            }
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
        finally {
            this.endTransaction(t, dbt, false);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public List getAllUsers(UserTransaction t, String groupName) throws RootException {
        dbt = this.beginTransaction(t);
        ret = new ArrayList<String>();
        gqry = new GroupQuery(dbt);
        try {
            gqry.setQueryGroupid(groupName);
            gqry.requireUniqueInstance();
            gd = gqry.getNextDO();
            if (gd == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            lqry = new UserLinkQuery(dbt);
            lqry.setQueryGroupid(gd);
            while (null != (user = lqry.getNextDO())) {
                ret.add(user.getUserid().getUserid());
            }
            groupLinkQ = new GroupLinkQuery(dbt);
            groupLinkQ.setQueryGroupid(gd);
            block6: while (true) {
                if (null == (subGroup = groupLinkQ.getNextDO())) {
                    break;
                }
                l = this.getAllUsers(t, subGroup.getSub_gid().getGroupid());
                if (l.isEmpty()) continue;
                i = 0;
                while (true) {
                    if (i < l.size()) ** break;
                    continue block6;
                    if (!ret.contains((String)l.get(i))) {
                        ret.add((String)l.get(i));
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
        finally {
            this.endTransaction(t, dbt, false);
        }
        return ret;
    }

    public List getAllUsers(UserTransaction t, List groupNames) throws RootException {
        ArrayList ret = new ArrayList();
        Iterator it = groupNames.iterator();
        while (it.hasNext()) {
            ret.addAll(this.getAllUsers(t, (String)it.next()));
        }
        return ret;
    }

    public List getAllImmediateUsers(UserTransaction t, String groupName) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        ArrayList<String> ret = new ArrayList<String>();
        GroupQuery gqry = new GroupQuery(dbt);
        try {
            UserLinkDO user;
            gqry.setQueryGroupid(groupName);
            gqry.requireUniqueInstance();
            GroupDO gd = gqry.getNextDO();
            if (gd == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            UserLinkQuery lqry = new UserLinkQuery(dbt);
            lqry.setQueryGroupid(gd);
            while (null != (user = lqry.getNextDO())) {
                ret.add(user.getUserid().getUserid());
            }
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
        finally {
            this.endTransaction(t, dbt, false);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public List getAllSubgroups(UserTransaction t, String groupName) throws RootException {
        dbt = this.beginTransaction(t);
        ret = new ArrayList<String>();
        gqry = new GroupQuery(dbt);
        try {
            gqry.setQueryGroupid(groupName);
            gqry.requireUniqueInstance();
            gd = gqry.getNextDO();
            if (gd == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            groupLinkQ = new GroupLinkQuery(dbt);
            groupLinkQ.setQueryGroupid(gd);
            block5: while (true) {
                if (null == (subGroup = groupLinkQ.getNextDO())) {
                    break;
                }
                subId = subGroup.getSub_gid().getGroupid();
                if (ret.contains(subId)) continue;
                ret.add(subId);
                l = this.getAllSubgroups(t, subGroup.getSub_gid().getGroupid());
                if (l.isEmpty()) continue;
                i = 0;
                while (true) {
                    if (i < l.size()) ** break;
                    continue block5;
                    if (!ret.contains((String)l.get(i))) {
                        ret.add((String)l.get(i));
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
        finally {
            this.endTransaction(t, dbt, false);
        }
        return ret;
    }

    public List getAllSubgroups(UserTransaction t, List groupNames) throws RootException {
        ArrayList ret = new ArrayList();
        Iterator it = groupNames.iterator();
        while (it.hasNext()) {
            ret.addAll(this.getAllSubgroups(t, (String)it.next()));
        }
        return ret;
    }

    public List getAllImmediateSubgroups(UserTransaction t, String groupName) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        ArrayList<String> ret = new ArrayList<String>();
        GroupQuery gqry = new GroupQuery(dbt);
        try {
            GroupLinkDO subGroup;
            gqry.setQueryGroupid(groupName);
            gqry.requireUniqueInstance();
            GroupDO gd = gqry.getNextDO();
            if (gd == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            GroupLinkQuery groupLinkQ = new GroupLinkQuery(dbt);
            groupLinkQ.setQueryGroupid(gd);
            while (null != (subGroup = groupLinkQ.getNextDO())) {
                ret.add(subGroup.getSub_gid().getGroupid());
            }
        }
        catch (Exception e) {
            throw new RootException((Throwable)e);
        }
        finally {
            this.endTransaction(t, dbt, false);
        }
        return ret;
    }

    public void createGroup(UserTransaction t, String groupName, String description) throws RootException {
        if (this.doesGroupExist(t, groupName)) {
            throw new RootException("Group already exists");
        }
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupDO group = GroupDO.createVirgin(dbt);
            group.setGroupid(groupName);
            group.setDescription(description);
            group.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void removeGroup(UserTransaction t, String groupName) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery qry = new GroupQuery(dbt);
            qry.setQueryGroupid(groupName);
            qry.requireUniqueInstance();
            qry.getNextDO().delete();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public boolean doesGroupExist(UserTransaction t, String groupName) throws RootException {
        boolean ret = false;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery qry = new GroupQuery(dbt);
            qry.setQueryGroupid(groupName);
            qry.requireUniqueInstance();
            ret = null != qry.getNextDO();
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    public boolean doesGroupBelongToGroup(UserTransaction t, String groupName, String subgroupName) throws RootException {
        boolean ret = false;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            GroupQuery gQry1 = new GroupQuery(dbt);
            gQry1.setQueryGroupid(subgroupName);
            gQry1.requireUniqueInstance();
            GroupDO subgroup = gQry1.getNextDO();
            if (subgroup == null) {
                throw new RootException("Group " + subgroupName + "does not exist.");
            }
            GroupLinkQuery lQry = new GroupLinkQuery(dbt);
            lQry.setQueryGroupid(group);
            lQry.setQuerySub_gid(subgroup);
            lQry.requireUniqueInstance();
            GroupLinkDO result = lQry.getNextDO();
            if (result != null) {
                ret = true;
            } else {
                GroupLinkQuery lQry1 = new GroupLinkQuery(dbt);
                lQry1.setQueryGroupid(group);
                result = lQry1.getNextDO();
                while (!ret && result != null) {
                    ret = this.doesGroupBelongToGroup(t, result.getSub_gid(), subgroup);
                    result = lQry1.getNextDO();
                }
            }
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    private boolean doesGroupBelongToGroup(UserTransaction t, GroupDO group, GroupDO subgroup) throws RootException {
        boolean ret = false;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupLinkQuery lQry = new GroupLinkQuery(dbt);
            lQry.setQueryGroupid(group);
            lQry.setQuerySub_gid(subgroup);
            lQry.requireUniqueInstance();
            GroupLinkDO result = lQry.getNextDO();
            if (result != null) {
                ret = true;
            } else {
                GroupLinkQuery lQry1 = new GroupLinkQuery(dbt);
                lQry1.setQueryGroupid(group);
                result = lQry1.getNextDO();
                while (!ret && result != null) {
                    ret = this.doesGroupBelongToGroup(t, result.getSub_gid(), subgroup);
                    result = lQry1.getNextDO();
                }
            }
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    public void updateGroup(UserTransaction t, String groupName, String description) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery qry = new GroupQuery(dbt);
            qry.setQueryGroupid(groupName);
            qry.requireUniqueInstance();
            GroupDO group = qry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            group.setDescription(description);
            group.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void addGroupToGroup(UserTransaction t, String groupName, String subgroupName) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            GroupQuery gQry1 = new GroupQuery(dbt);
            gQry1.setQueryGroupid(subgroupName);
            gQry1.requireUniqueInstance();
            GroupDO subgroup = gQry1.getNextDO();
            if (subgroup == null) {
                throw new RootException("Group " + subgroupName + "does not exist.");
            }
            GroupLinkDO GroupLink = GroupLinkDO.createVirgin(dbt);
            GroupLink.setSub_gid(subgroup);
            GroupLink.setGroupid(group);
            GroupLink.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void removeGroupFromGroup(UserTransaction t, String groupName, String subgroupName) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            GroupQuery gQry1 = new GroupQuery(dbt);
            gQry1.setQueryGroupid(subgroupName);
            gQry1.requireUniqueInstance();
            GroupDO subgroup = gQry1.getNextDO();
            if (subgroup == null) {
                throw new RootException("Group " + subgroupName + "does not exist.");
            }
            GroupLinkQuery lQry = new GroupLinkQuery(dbt);
            lQry.setQuerySub_gid(subgroup);
            lQry.setQueryGroupid(group);
            lQry.requireUniqueInstance();
            lQry.getNextDO().delete();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void removeGroupTree(UserTransaction t, String groupName) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupLinkDO groupLinkDo;
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            GroupLinkQuery groupLinkQ = new GroupLinkQuery(dbt);
            groupLinkQ.setQueryGroupid(group);
            while (null != (groupLinkDo = groupLinkQ.getNextDO())) {
                this.removeChildTree(t, groupLinkDo);
            }
            this.removeUsersFromGroup(t, group);
            group.delete();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    private void removeChildTree(UserTransaction t, GroupLinkDO groupLink) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupDO group = groupLink.getSub_gid();
            GroupLinkQuery gQry = new GroupLinkQuery(dbt);
            gQry.setQueryGroupid(group);
            GroupLinkDO subgroupLink = gQry.getNextDO();
            while (subgroupLink != null) {
                this.removeChildTree(t, subgroupLink);
                subgroupLink = gQry.getNextDO();
            }
            GroupLinkQuery groupLinkQ = new GroupLinkQuery(dbt);
            groupLinkQ.setQuerySub_gid(group);
            int ii = groupLinkQ.getCount();
            if (groupLinkQ.getCount() > 1) {
                groupLink.delete();
            } else {
                this.removeUsersFromGroup(t, group);
                group.delete();
            }
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    private void removeUsersFromGroup(UserTransaction t, GroupDO group) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserLinkQuery userLinkQ = new UserLinkQuery(dbt);
            userLinkQ.setQueryGroupid(group);
            UserLinkDO[] userLink_dos = userLinkQ.getDOArray();
            for (int i = 0; i < userLink_dos.length; ++i) {
                UserLinkDO userLink_do = userLink_dos[i];
                UserDO user_do = userLink_do.getUserid();
                UserLinkQuery lQry = new UserLinkQuery(dbt);
                lQry.setQueryUserid(user_do);
                if (lQry.getCount() == 1) {
                    user_do.delete();
                    continue;
                }
                userLink_do.delete();
            }
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void removeUsersFromGroupTree(UserTransaction t, String groupName) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupLinkDO groupLink_do;
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            GroupLinkQuery groupLinkQ = new GroupLinkQuery(dbt);
            groupLinkQ.setQueryGroupid(group);
            while (null != (groupLink_do = groupLinkQ.getNextDO())) {
                this.removeUsersFromGroupTree(t, groupLink_do.getSub_gid());
            }
            this.removeUsersFromGroup(t, group);
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    private void removeUsersFromGroupTree(UserTransaction t, GroupDO group) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupLinkDO groupLink_do;
            GroupLinkQuery groupLinkQ = new GroupLinkQuery(dbt);
            groupLinkQ.setQueryGroupid(group);
            while (null != (groupLink_do = groupLinkQ.getNextDO())) {
                this.removeUsersFromGroupTree(t, groupLink_do.getSub_gid());
            }
            this.removeUsersFromGroup(t, group);
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void moveGroup(UserTransaction t, String currentParentGroup, String newParentGroup, String subgroupName) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(subgroupName);
            gQry.requireUniqueInstance();
            GroupDO subgroup = gQry.getNextDO();
            if (subgroup == null) {
                throw new RootException("Group " + subgroupName + "does not exist.");
            }
            GroupQuery gQry1 = new GroupQuery(dbt);
            gQry1.setQueryGroupid(currentParentGroup);
            gQry1.requireUniqueInstance();
            GroupDO currentGroup = gQry1.getNextDO();
            if (currentGroup == null) {
                throw new RootException("Group " + currentParentGroup + "does not exist.");
            }
            GroupQuery gQry2 = new GroupQuery(dbt);
            gQry2.setQueryGroupid(newParentGroup);
            gQry2.requireUniqueInstance();
            GroupDO newGroup = gQry2.getNextDO();
            if (newGroup == null) {
                throw new RootException("Group " + newParentGroup + "does not exist.");
            }
            GroupLinkQuery lQry = new GroupLinkQuery(dbt);
            lQry.setQuerySub_gid(subgroup);
            lQry.setQueryGroupid(currentGroup);
            lQry.requireUniqueInstance();
            lQry.getNextDO().delete();
            GroupLinkDO GroupLink = GroupLinkDO.createVirgin(dbt);
            GroupLink.setSub_gid(subgroup);
            GroupLink.setGroupid(newGroup);
            GroupLink.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public String getGroupDescription(UserTransaction t, String groupName) throws RootException {
        String ret = null;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery qry = new GroupQuery(dbt);
            qry.setQueryGroupid(groupName);
            qry.requireUniqueInstance();
            ret = qry.getNextDO().getDescription();
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    public void addUserToGroup(UserTransaction t, String groupName, String username) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            UserDO user = uQry.getNextDO();
            if (user == null) {
                throw new RootException("User " + username + "does not exist.");
            }
            UserLinkDO UserLink = UserLinkDO.createVirgin(dbt);
            UserLink.setUserid(user);
            UserLink.setGroupid(group);
            UserLink.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void removeUserFromGroup(UserTransaction t, String groupName, String username) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            UserDO user = uQry.getNextDO();
            if (user == null) {
                throw new RootException("User " + username + "does not exist.");
            }
            UserLinkQuery lQry = new UserLinkQuery(dbt);
            lQry.setQueryUserid(user);
            lQry.setQueryGroupid(group);
            lQry.requireUniqueInstance();
            lQry.getNextDO().delete();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void moveUser(UserTransaction t, String currentGroup, String newGroup, String username) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry1 = new GroupQuery(dbt);
            gQry1.setQueryGroupid(currentGroup);
            gQry1.requireUniqueInstance();
            GroupDO currentG = gQry1.getNextDO();
            if (currentG == null) {
                throw new RootException("Group " + currentGroup + "does not exist.");
            }
            GroupQuery gQry2 = new GroupQuery(dbt);
            gQry2.setQueryGroupid(newGroup);
            gQry2.requireUniqueInstance();
            GroupDO newG = gQry2.getNextDO();
            if (newG == null) {
                throw new RootException("Group " + newGroup + "does not exist.");
            }
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            UserDO user = uQry.getNextDO();
            if (user == null) {
                throw new RootException("User " + username + "does not exist.");
            }
            UserLinkQuery lQry = new UserLinkQuery(dbt);
            lQry.setQueryUserid(user);
            lQry.setQueryGroupid(currentG);
            lQry.requireUniqueInstance();
            lQry.getNextDO().delete();
            UserLinkDO UserLink = UserLinkDO.createVirgin(dbt);
            UserLink.setUserid(user);
            UserLink.setGroupid(newG);
            UserLink.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public boolean doesUserBelongToGroup(UserTransaction t, String groupName, String username) throws RootException {
        boolean ret = false;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            if (group == null) {
                throw new RootException("Group " + groupName + "does not exist.");
            }
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            UserDO user = uQry.getNextDO();
            if (user == null) {
                throw new RootException("User " + username + "does not exist.");
            }
            UserLinkQuery lQry = new UserLinkQuery(dbt);
            lQry.setQueryUserid(user);
            lQry.setQueryGroupid(group);
            lQry.requireUniqueInstance();
            UserLinkDO result = lQry.getNextDO();
            if (result != null) {
                ret = true;
            } else {
                GroupLinkQuery lQry1 = new GroupLinkQuery(dbt);
                lQry1.setQueryGroupid(group);
                GroupLinkDO result1 = lQry1.getNextDO();
                while (!ret && result1 != null) {
                    ret = this.doesUserBelongToGroup(t, result1.getSub_gid(), user);
                    result1 = lQry1.getNextDO();
                }
            }
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    private boolean doesUserBelongToGroup(UserTransaction t, GroupDO group, UserDO user) throws RootException {
        boolean ret = false;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserLinkQuery lQry = new UserLinkQuery(dbt);
            lQry.setQueryGroupid(group);
            lQry.setQueryUserid(user);
            lQry.requireUniqueInstance();
            UserLinkDO result = lQry.getNextDO();
            if (result != null) {
                ret = true;
            } else {
                GroupLinkQuery lQry1 = new GroupLinkQuery(dbt);
                lQry1.setQueryGroupid(group);
                GroupLinkDO result1 = lQry1.getNextDO();
                while (!ret && result1 != null) {
                    ret = this.doesUserBelongToGroup(t, result1.getSub_gid(), user);
                    result1 = lQry1.getNextDO();
                }
            }
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    public void createUser(UserTransaction t, String groupName, String username, String password, String firstName, String lastName, String emailAddress) throws RootException {
        if (this.doesUserExist(t, username)) {
            throw new RootException("User already exists");
        }
        DBTransaction dbt = this.beginTransaction(t);
        try {
            GroupQuery gQry = new GroupQuery(dbt);
            gQry.setQueryGroupid(groupName);
            gQry.requireUniqueInstance();
            GroupDO group = gQry.getNextDO();
            UserDO user = UserDO.createVirgin(dbt);
            user.setUserid(username);
            user.setPasswd(MiscUtilities.passwordDigest((String)password));
            user.setFirstname(firstName);
            user.setLastname(lastName);
            user.setEmail(emailAddress);
            user.save();
            UserLinkDO UserLink = UserLinkDO.createVirgin(dbt);
            UserLink.setUserid(user);
            UserLink.setGroupid(group);
            UserLink.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void updateUser(UserTransaction t, String username, String firstName, String lastName, String emailAddress) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            UserDO user = uQry.getNextDO();
            if (user == null) {
                throw new RootException("User " + username + "does not exist.");
            }
            user.setFirstname(firstName);
            user.setLastname(lastName);
            user.setEmail(emailAddress);
            user.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public void removeUser(UserTransaction t, String username) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            uQry.getNextDO().delete();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public boolean doesUserExist(UserTransaction t, String username) throws RootException {
        boolean ret = false;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            ret = null != uQry.getNextDO();
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    public void setPassword(UserTransaction t, String username, String password) throws RootException {
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            UserDO user = uQry.getNextDO();
            user.setPasswd(MiscUtilities.passwordDigest((String)password));
            user.save();
            this.endTransaction(t, dbt, true);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
    }

    public String getUserRealName(UserTransaction t, String username) throws RootException {
        String ret = null;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            UserDO resultDO = uQry.getNextDO();
            ret = resultDO.getFirstname();
            String lastName = resultDO.getLastname();
            if (ret != null) {
                if (lastName != null) {
                    ret = ret + " " + lastName;
                }
            } else if (lastName != null) {
                ret = lastName;
            }
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    public String getUserFirstName(UserTransaction t, String username) throws RootException {
        String ret = null;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            ret = uQry.getNextDO().getFirstname();
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    public String getUserLastName(UserTransaction t, String username) throws RootException {
        String ret = null;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            ret = uQry.getNextDO().getLastname();
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    public String getUserEMailAddress(UserTransaction t, String username) throws RootException {
        String ret = null;
        DBTransaction dbt = this.beginTransaction(t);
        try {
            UserQuery uQry = new UserQuery(dbt);
            uQry.setQueryUserid(username);
            uQry.requireUniqueInstance();
            ret = uQry.getNextDO().getEmail();
            this.endTransaction(t, dbt, false);
        }
        catch (Exception e) {
            if (e instanceof RootException) {
                throw (RootException)e;
            }
            throw new RootException((Throwable)e);
        }
        return ret;
    }

    private void endTransaction(UserTransaction t, DBTransaction dbt, boolean commitToo) throws RootException {
        if (!dbt.getDatabaseName().equals(this.db.getName())) {
            try {
                if (commitToo) {
                    dbt.commit();
                }
            }
            catch (SQLException e) {
                throw new RootException((Throwable)e);
            }
            finally {
                dbt.release();
            }
        }
    }

    private DBTransaction beginTransaction(UserTransaction t) throws RootException {
        DBTransaction dbt = ((SharkDODSUserTransaction)t).getDODSTransaction();
        if (!dbt.getDatabaseName().equals(this.db.getName())) {
            try {
                dbt = this.db.createTransaction();
            }
            catch (SQLException e) {
                throw new RootException((Throwable)e);
            }
        }
        return dbt;
    }
}

