/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.ToolAgent;
import org.enhydra.shark.api.internal.toolagent.ToolAgentFactory;
import org.enhydra.shark.api.internal.working.CallbackUtilities;

public class ToolAgentFactoryImpl
implements ToolAgentFactory {
    private static final String TOOL_AGENT_PREFIX = "ToolAgent.";
    private List toolAgents = new ArrayList();
    private CallbackUtilities cus;

    public void configure(CallbackUtilities cus) throws RootException {
        this.cus = cus;
        this.createToolAgentList();
    }

    public List getDefinedToolAgents(SharkTransaction t) throws RootException {
        return Collections.unmodifiableList(this.toolAgents);
    }

    public ToolAgent createToolAgent(SharkTransaction t, String className) throws RootException {
        try {
            Class<?> cls = Class.forName(className);
            ToolAgent ta = (ToolAgent)cls.newInstance();
            ta.configure(this.cus);
            return ta;
        }
        catch (Exception ex) {
            throw new RootException("Failed to create tool agent for class " + className, (Throwable)ex);
        }
    }

    private void createToolAgentList() {
        String taName = null;
        String className = null;
        Properties props = this.cus.getProperties();
        Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
        while (it.hasNext()) {
            try {
                Map.Entry<Object, Object> me = it.next();
                taName = me.getKey().toString();
                if (!taName.startsWith(TOOL_AGENT_PREFIX)) continue;
                taName = taName.substring(TOOL_AGENT_PREFIX.length());
                className = me.getValue().toString();
                this.toolAgents.add(className);
            }
            catch (Throwable ex) {
                this.cus.error("ToolAgentFactoryImpl -> Error when retrieving list of tool agents from properties!!!");
            }
        }
    }
}

