/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfservice.AdminInterface;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.SessionHandle;
import org.enhydra.shark.api.internal.toolagent.ToolAgent;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.toolagent.SingletonPooledExecutor;

class ToolAgentCmdProxy
implements Runnable {
    CallbackUtilities m_cus;
    String m_taName;
    ToolAgent m_ta;
    String m_username;
    String m_password;
    String m_engineName;
    String m_scope;
    long m_handle;
    String m_applicationName;
    String m_procInstId;
    String m_assId;
    AppParameter[] m_parameters;
    AppParameter[] m_proxyParameters;
    Integer m_appMode;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;

    ToolAgentCmdProxy(CallbackUtilities cus, ToolAgent ta, String taName, String username, String password, String engineName, String scope, long handle, String applicationName, String procInstId, String assId, AppParameter[] parameters, Integer appMode) {
        this.m_cus = cus;
        this.m_ta = ta;
        this.m_taName = taName;
        this.m_username = username;
        this.m_password = password;
        this.m_engineName = engineName;
        this.m_scope = scope;
        this.m_handle = handle;
        this.m_applicationName = applicationName;
        this.m_procInstId = procInstId;
        this.m_assId = assId;
        this.m_parameters = parameters;
        this.m_appMode = appMode;
    }

    private void info(String infoString) {
        if (null != this.m_cus) {
            this.m_cus.info(infoString);
        }
    }

    private void error(String infoString) {
        if (null != this.m_cus) {
            this.m_cus.error(infoString);
        }
    }

    private Map getResults() throws Exception {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (int i = 0; i < this.m_parameters.length; ++i) {
            AppParameter p = this.m_parameters[i];
            if (!p.the_mode.equals("INOUT") && !p.the_mode.equals("OUT")) continue;
            results.put(p.the_actual_name, this.convertToProperType(p.the_value, p.the_class));
        }
        return results;
    }

    private Object convertToProperType(Object toConvert, Class desiredType) throws Exception {
        if (null == toConvert || desiredType.isInstance(toConvert)) {
            return toConvert;
        }
        if (desiredType.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = ToolAgentCmdProxy.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(new Integer(toConvert.toString()));
        }
        if (desiredType.equals(class$java$lang$Long == null ? (class$java$lang$Long = ToolAgentCmdProxy.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(new Double(toConvert.toString()).longValue());
        }
        if (desiredType.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ToolAgentCmdProxy.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean(toConvert.toString());
        }
        if (desiredType.equals(class$java$lang$Double == null ? (class$java$lang$Double = ToolAgentCmdProxy.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(toConvert.toString());
        }
        if (desiredType.equals(class$java$util$Date == null ? (class$java$util$Date = ToolAgentCmdProxy.class$("java.util.Date")) : class$java$util$Date)) {
            return new Date(toConvert.toString());
        }
        return toConvert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        String oldThreadName;
        Thread curThread;
        block21: {
            curThread = Thread.currentThread();
            oldThreadName = curThread.getName();
            long status = -1L;
            SingletonPooledExecutor spe = null;
            try {
                spe = SingletonPooledExecutor.getInstance(this.m_cus);
            }
            catch (Exception _) {
                // empty catch block
            }
            if (null == spe) {
                this.error("Unable to get thread-pool!");
                return;
            }
            Shark shark = Shark.getInstance();
            if (null == shark) {
                this.error("Unable to get Shark engine instance!");
                spe.updateCompleteCount(this);
                return;
            }
            SharkTransaction trans = null;
            curThread.setName(oldThreadName + "->" + this.m_taName);
            trans = shark.createTransaction();
            SessionHandle taShandle = this.m_ta.connect(trans, this.m_username, this.m_password, this.m_engineName, this.m_scope);
            this.m_ta.invokeApplication(trans, taShandle.getHandle(), null, this.m_procInstId, this.m_assId, this.m_parameters, this.m_appMode);
            status = this.m_ta.requestAppStatus(trans, taShandle.getHandle(), this.m_procInstId, this.m_assId, this.m_parameters);
            this.m_ta.disconnect(trans, taShandle);
            int finishCount = spe.updateCompleteCount(this);
            AdminInterface adminInterface = shark.getAdminInterface();
            ExecutionAdministration execAdmin = adminInterface.getExecutionAdministration();
            execAdmin.connect(trans, spe.getSharkUsername(), spe.getSharkPassword(), this.m_engineName, this.m_scope);
            String activityId = adminInterface.getAdminMisc().getAssignmentActivityId(this.m_procInstId, this.m_assId);
            WfActivity wfActivity = execAdmin.getActivity(trans, this.m_procInstId, activityId);
            wfActivity.set_result(trans, this.getResults());
            if (0 == finishCount) {
                wfActivity.complete(trans);
            }
            execAdmin.disconnect(trans);
            trans.commit();
            Object var15_16 = null;
            try {
                shark.unlockProcesses(trans);
            }
            catch (Exception _) {
                // empty catch block
            }
            try {
                trans.release();
            }
            catch (Exception _) {
                // empty catch block
            }
            trans = null;
            {
                break block21;
                catch (Throwable ex) {
                    this.error("SchedulerToolAgent -> applicationProxy " + this.m_taName + " terminated incorrectly: " + ex);
                    status = -1L;
                    try {
                        shark.emptyCaches(trans);
                        trans.rollback();
                    }
                    catch (Exception _) {
                    }
                    Object var15_17 = null;
                    try {
                        shark.unlockProcesses(trans);
                    }
                    catch (Exception _) {
                        // empty catch block
                    }
                    try {
                        trans.release();
                    }
                    catch (Exception _) {
                        // empty catch block
                    }
                    trans = null;
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                try {
                    shark.unlockProcesses(trans);
                }
                catch (Exception _) {
                    // empty catch block
                }
                try {
                    trans.release();
                }
                catch (Exception _) {
                    // empty catch block
                }
                trans = null;
                throw throwable;
            }
        }
        curThread.setName(oldThreadName);
    }

    public void cancel() {
    }

    public Object getAssId() {
        return this.m_assId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

