/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.DeserializerFactory;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.ser.SimpleDeserializer;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.Utils;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ApplicationBusy;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotDefined;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStarted;
import org.enhydra.shark.api.internal.toolagent.SessionHandle;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.toolagent.AbstractToolAgent;

public class SOAPToolAgent
extends AbstractToolAgent {
    @Override
    public void invokeApplication(SharkTransaction t, long handle, String applicationName, String procInstId, String assId, AppParameter[] parameters, Integer appMode) throws ApplicationNotStarted, ApplicationNotDefined, ApplicationBusy, ToolAgentGeneralException {
        super.invokeApplication(t, handle, applicationName, procInstId, assId, parameters, appMode);
        try {
            this.status = 0L;
            if (this.appName == null || this.appName.trim().length() == 0) {
                this.readParamsFromExtAttributes((String)parameters[0].the_value);
            }
            AppParameter[] aps = new AppParameter[parameters.length - 1];
            System.arraycopy(parameters, 1, aps, 0, aps.length);
            String operationName = (String)aps[0].the_value;
            String portName = null;
            try {
                portName = operationName.substring(operationName.indexOf("(") + 1, operationName.indexOf(")"));
                operationName = operationName.substring(0, operationName.indexOf("("));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Parser wsdlParser = null;
            wsdlParser = new Parser();
            this.cus.info("SOAPToolAgent -> Reading WSDL document from '" + this.appName + "'");
            wsdlParser.run(this.appName);
            HashMap map = this.invokeMethod(wsdlParser, operationName, portName, aps);
            this.cus.info("SOAPToolAgent -> Result:");
            for (String name : map.keySet()) {
                this.cus.info("       " + name + "=" + map.get(name));
            }
            this.prepareResult(parameters, map);
            this.cus.info("\nSOAPToolAgent -> Done!");
            this.status = 4L;
        }
        catch (Throwable ex) {
            this.cus.error("SOAPToolAgent -> application " + this.appName + " terminated incorrectly: " + ex);
            this.status = -1L;
            throw new ToolAgentGeneralException(ex);
        }
    }

    @Override
    public String getInfo(SharkTransaction t) throws ToolAgentGeneralException {
        String i = "Executes WEB service operation.\nWhen you map XPDL application to this tool agent, you should set application \nname to the location of the WSDL file that defines WEB service to be called.\nAlso, this tool agent requires that the first parameter defined in XPDL Application's \nformal parameters represent the name of WEB service operation to be called.\n\nThis tool agent is able to understand the extended attribute with the following name:\n     * AppName - value of this attribute should represent the location of WSDL file where WEB service is defined\n\n NOTE: Tool agent will read extended attributes only if they are called through\n       Default tool agent (not by shark directly) and this is the case when information \n       on which tool agent to start for XPDL application definition is not contained in mappings";
        return i;
    }

    public HashMap invokeMethod(Parser wsdlParser, String operationName, String portName, AppParameter[] args) throws Exception {
        String serviceNS = null;
        String serviceName = null;
        Object operationQName = null;
        this.cus.info("SOAPToolAgent -> Preparing Axis dynamic invocation");
        Service service = SOAPToolAgent.getService(wsdlParser, serviceNS, serviceName);
        Operation operation = null;
        org.apache.axis.client.Service dpf = new org.apache.axis.client.Service(wsdlParser, service.getQName());
        ArrayList<Object> inputs = new ArrayList<Object>();
        Port port = SOAPToolAgent.getPort(service.getPorts(), portName);
        if (portName == null) {
            portName = port.getName();
        }
        Binding binding = port.getBinding();
        javax.xml.rpc.Call call = dpf.createCall(QName.valueOf(portName), QName.valueOf(operationName));
        ArrayList<String> outNames = new ArrayList<String>();
        ArrayList<String> inNames = new ArrayList<String>();
        ArrayList<Parameter> inTypes = new ArrayList<Parameter>();
        SymbolTable symbolTable = wsdlParser.getSymbolTable();
        BindingEntry bEntry = symbolTable.getBindingEntry(binding.getQName());
        Parameters parameters = null;
        for (Operation o : bEntry.getParameters().keySet()) {
            if (!o.getName().equals(operationName)) continue;
            operation = o;
            parameters = (Parameters)bEntry.getParameters().get(o);
            break;
        }
        if (operation == null || parameters == null) {
            throw new RuntimeException(String.valueOf(operationName) + " was not found.");
        }
        int j = 0;
        while (j < parameters.list.size()) {
            Parameter p = (Parameter)parameters.list.get(j);
            if (p.getMode() == 1) {
                inNames.add(p.getQName().getLocalPart());
                inTypes.add(p);
            } else if (p.getMode() == 2) {
                outNames.add("{" + p.getQName().getNamespaceURI() + "}" + p.getName());
            } else if (p.getMode() == 3) {
                inNames.add(p.getQName().getLocalPart());
                inTypes.add(p);
                outNames.add("{" + p.getQName().getNamespaceURI() + "}" + p.getName());
            }
            ++j;
        }
        if (parameters.returnParam != null) {
            QName returnType = Utils.getXSIType((Parameter)parameters.returnParam);
            QName returnQName = parameters.returnParam.getQName();
            outNames.add(returnQName.getLocalPart());
        }
        if (inNames.size() > args.length - 1) {
            throw new RuntimeException("Need " + inNames.size() + " arguments!!!");
        }
        int pos = 0;
        while (pos < inNames.size()) {
            AppParameter arg = args[pos + 1];
            Parameter p = (Parameter)inTypes.get(pos);
            inputs.add(SOAPToolAgent.getParamData((Call)call, p, arg));
            ++pos;
        }
        this.cus.info("SOAPToolAgent -> Executing operation " + operationName + " with parameters:");
        j = 0;
        while (j < inputs.size()) {
            this.cus.info("        " + inNames.get(j) + "=" + inputs.get(j));
            ++j;
        }
        Object ret = call.invoke(inputs.toArray());
        Map outputs = call.getOutputParams();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int pos2 = 0;
        while (pos2 < outNames.size()) {
            String name = (String)outNames.get(pos2);
            Object value = outputs.get(name);
            for (Map.Entry pairs : outputs.entrySet()) {
                if (name.compareToIgnoreCase(pairs.getKey().toString()) != 0) continue;
                value = pairs.getValue();
                if (value == null && pos2 == 0) {
                    map.put(name, ret);
                } else {
                    map.put(name, value);
                }
                System.out.println(String.valueOf(pairs.getKey().toString()) + " = " + pairs.getValue());
            }
            if (value == null && pos2 == 0) {
                map.put(name, ret);
            } else {
                map.put(name, value);
            }
            ++pos2;
        }
        return map;
    }

    private void prepareResult(AppParameter[] context, HashMap hashret) throws Exception {
        int n = 0;
        Set set = hashret.entrySet();
        Iterator it = set.iterator();
        Object[] val = new Object[hashret.size()];
        while (it.hasNext()) {
            Map.Entry mapentry = it.next();
            val[n] = mapentry.getValue();
            ++n;
        }
        if (context != null) {
            int en = 0;
            int i = 0;
            while (i < context.length) {
                if (context[i].the_mode.equals("OUT") || context[i].the_mode.equals("INOUT")) {
                    context[i].the_value = this.convertToProperType(val[en], context[i].the_class);
                    ++en;
                }
                ++i;
            }
        }
    }

    private Object convertToProperType(Object toConvert, Class desiredType) throws Exception {
        if (desiredType.isInstance(toConvert)) {
            return toConvert;
        }
        if (desiredType.equals(Long.class)) {
            return new Long(new Double(toConvert.toString()).longValue());
        }
        if (desiredType.equals(Boolean.class)) {
            return new Boolean(toConvert.toString());
        }
        if (desiredType.equals(Double.class)) {
            return new Double(toConvert.toString());
        }
        if (desiredType.equals(Date.class)) {
            return new Date(toConvert.toString());
        }
        return toConvert;
    }

    private static Object getParamData(Call c, Parameter p, AppParameter ap) throws Exception {
        DeserializerFactory factory;
        Deserializer deserializer;
        QName paramType = Utils.getXSIType((Parameter)p);
        String arg = null;
        TypeEntry type = p.getType();
        if (type instanceof BaseType && ((BaseType)type).isBaseType() && (deserializer = (factory = c.getTypeMapping().getDeserializer(paramType)).getDeserializerAs("Axis SAX Mechanism")) instanceof SimpleDeserializer) {
            Object obj = ap.the_value;
            arg = String.valueOf(obj);
            return ((SimpleDeserializer)deserializer).makeValue(arg);
        }
        throw new RuntimeException("don't know how to convert '" + arg + "' into " + c);
    }

    public static Service getService(Parser wsdlParser, String serviceNS, String serviceName) throws Exception {
        QName serviceQName = null;
        if (serviceNS != null && serviceName != null) {
            serviceQName = new QName(serviceNS, serviceName);
        }
        ServiceEntry serviceEntry = (ServiceEntry)SOAPToolAgent.getSymTabEntry(wsdlParser, serviceQName, ServiceEntry.class);
        return serviceEntry.getService();
    }

    public static Port getPort(Map ports, String portName) throws Exception {
        for (String name : ports.keySet()) {
            if (portName == null || portName.length() == 0) {
                Port port = (Port)ports.get(name);
                List list = port.getExtensibilityElements();
                int i = 0;
                while (list != null && i < list.size()) {
                    Object obj = list.get(i);
                    if (obj instanceof SOAPAddress) {
                        return port;
                    }
                    ++i;
                }
                continue;
            }
            if (name == null || !name.equals(portName)) continue;
            return (Port)ports.get(name);
        }
        return null;
    }

    public static SymTabEntry getSymTabEntry(Parser wsdlParser, QName qname, Class cls) {
        HashMap map = wsdlParser.getSymbolTable().getHashMap();
        for (Map.Entry entry : map.entrySet()) {
            QName key = (QName)entry.getKey();
            Vector v = (Vector)entry.getValue();
            if (qname != null && !qname.equals(qname)) continue;
            int i = 0;
            while (i < v.size()) {
                SymTabEntry symTabEntry = (SymTabEntry)v.elementAt(i);
                if (cls.isInstance(symTabEntry)) {
                    return symTabEntry;
                }
                ++i;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        SOAPToolAgent soapTA = new SOAPToolAgent();
        SOAPToolAgent.test1(soapTA);
        SOAPToolAgent.test2(soapTA);
        SOAPToolAgent.test3(soapTA);
        SOAPToolAgent.test4(soapTA);
    }

    public static void test1(SOAPToolAgent soapTA) {
        try {
            SessionHandle handle = soapTA.connect(null, "", "", "", "");
            String appName = "http://www.ebi.ac.uk/xembl/XEMBL.wsdl";
            AppParameter[] aps = new AppParameter[5];
            AppParameter ap = new AppParameter();
            ap.the_value = "";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[0] = ap;
            ap = new AppParameter();
            ap.the_value = "getNucSeq";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[1] = ap;
            ap = new AppParameter();
            ap.the_value = "Bsml";
            ap.the_actual_name = "nuc_format";
            ap.the_formal_name = "format";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[2] = ap;
            ap = new AppParameter();
            ap.the_value = "HSERPG U83300 AC000057";
            ap.the_actual_name = "nuc_ids";
            ap.the_formal_name = "ids";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[3] = ap;
            ap = new AppParameter();
            ap.the_value = null;
            ap.the_actual_name = "nuc_formula";
            ap.the_formal_name = "formula";
            ap.the_mode = "OUT";
            ap.the_class = String.class;
            aps[4] = ap;
            soapTA.invokeApplication(null, handle.getHandle(), appName, "1", "1", aps, new Integer(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void test2(SOAPToolAgent soapTA) {
        try {
            SessionHandle handle = soapTA.connect(null, "", "", "", "");
            String appName = "http://samples.gotdotnet.com/quickstart/aspplus/samples/services/MathService/VB/MathService.asmx?WSDL";
            AppParameter[] aps = new AppParameter[5];
            AppParameter ap = new AppParameter();
            ap.the_value = "";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[0] = ap;
            ap = new AppParameter();
            ap.the_value = "Add";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[1] = ap;
            ap = new AppParameter();
            ap.the_value = new Double(3.0);
            ap.the_actual_name = "par1";
            ap.the_formal_name = "p1";
            ap.the_mode = "IN";
            ap.the_class = Double.class;
            aps[2] = ap;
            ap = new AppParameter();
            ap.the_value = new Double(44.0);
            ap.the_actual_name = "par2";
            ap.the_formal_name = "p2";
            ap.the_mode = "IN";
            ap.the_class = Double.class;
            aps[3] = ap;
            ap = new AppParameter();
            ap.the_value = null;
            ap.the_actual_name = "res";
            ap.the_formal_name = "r";
            ap.the_mode = "OUT";
            ap.the_class = Double.class;
            aps[4] = ap;
            soapTA.invokeApplication(null, handle.getHandle(), appName, "1", "1", aps, new Integer(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void test3(SOAPToolAgent soapTA) {
        try {
            SessionHandle handle = soapTA.connect(null, "", "", "", "");
            String appName = "http://www.xmethods.net/sd/2001/TemperatureService.wsdl";
            AppParameter[] aps = new AppParameter[4];
            AppParameter ap = new AppParameter();
            ap.the_value = "";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[0] = ap;
            ap = new AppParameter();
            ap.the_value = "getTemp";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[1] = ap;
            ap = new AppParameter();
            ap.the_value = "02067";
            ap.the_actual_name = "par1";
            ap.the_formal_name = "p1";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[2] = ap;
            ap = new AppParameter();
            ap.the_value = null;
            ap.the_actual_name = "res";
            ap.the_formal_name = "r";
            ap.the_mode = "OUT";
            ap.the_class = Double.class;
            aps[3] = ap;
            soapTA.invokeApplication(null, handle.getHandle(), appName, "1", "1", aps, new Integer(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void test4(SOAPToolAgent soapTA) {
        try {
            SessionHandle handle = soapTA.connect(null, "", "", "", "");
            String appName = "http://services.xmethods.net/soap/urn:xmethods-delayed-quotes.wsdl";
            AppParameter[] aps = new AppParameter[4];
            AppParameter ap = new AppParameter();
            ap.the_value = "";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[0] = ap;
            ap = new AppParameter();
            ap.the_value = "getQuote";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[1] = ap;
            ap = new AppParameter();
            ap.the_value = "IBM";
            ap.the_actual_name = "par1";
            ap.the_formal_name = "p1";
            ap.the_mode = "IN";
            ap.the_class = String.class;
            aps[2] = ap;
            ap = new AppParameter();
            ap.the_value = null;
            ap.the_actual_name = "res";
            ap.the_formal_name = "r";
            ap.the_mode = "OUT";
            ap.the_class = Double.class;
            aps[3] = ap;
            soapTA.invokeApplication(null, handle.getHandle(), appName, "1", "1", aps, new Integer(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

