/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ApplicationBusy;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotDefined;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStarted;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.toolagent.AbstractToolAgent;
import org.enhydra.shark.toolagent.MailMessageHandler;

public class MailToolAgent
extends AbstractToolAgent {
    public static final long APP_MODE_SEND = 0L;
    public static final long APP_MODE_RECEIVE = 1L;

    public void invokeApplication(SharkTransaction t, long handle, String applicationName, String procInstId, String assId, AppParameter[] parameters, Integer appMode) throws ApplicationNotStarted, ApplicationNotDefined, ApplicationBusy, ToolAgentGeneralException {
        super.invokeApplication(t, handle, applicationName, procInstId, assId, parameters, appMode);
        try {
            this.status = 0L;
            if (this.appName == null || this.appName.trim().length() == 0) {
                this.readParamsFromExtAttributes((String)parameters[0].the_value);
            }
            if (this.appName == null || this.appName.trim().length() == 0) {
                this.appName = "org.enhydra.shark.toolagent.DefaultMailMessageHandler";
            }
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> c = cl.loadClass(this.appName);
            MailMessageHandler mch = (MailMessageHandler)c.newInstance();
            AppParameter[] aps = new AppParameter[parameters.length - 1];
            System.arraycopy(parameters, 1, aps, 0, aps.length);
            mch.configure(this.cus, aps);
            long am = 0L;
            if (appMode != null && (long)appMode.intValue() == 1L) {
                am = 1L;
            }
            if (am == 0L) {
                System.out.println("Sending mail...");
                mch.sendMail();
                System.out.println("Mail sent.");
            } else if (am == 1L) {
                System.out.println("Receiving mail...");
                String mailSubject = mch.receiveMail();
                System.out.println("Mail received:" + mailSubject);
            }
            this.status = 4L;
        }
        catch (ClassNotFoundException cnf) {
            this.cus.error("MailToolAgent - application " + this.appName + " terminated incorrectly, can't find class: " + cnf);
            this.status = -1L;
            throw new ApplicationNotDefined("Can't find class " + this.appName, (Throwable)cnf);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.cus.error("MailToolAgent - application " + this.appName + " terminated incorrectly, can't find class definition: " + ncdfe);
            throw new ApplicationNotDefined("Class " + this.appName + " can't be executed", (Throwable)ncdfe);
        }
        catch (Throwable ex) {
            this.cus.error("MailToolAgent - application " + this.appName + " terminated incorrectly: " + ex);
            this.status = -1L;
            throw new ToolAgentGeneralException(ex);
        }
    }

    public String getInfo(SharkTransaction t) throws ToolAgentGeneralException {
        String i = "Sends and receives mail messages.\nThere is a MailMessageHandler interface defined that is used to actually \nhandle mails. We gave default implementation of this interface, but one can \ncreate its own implementation. This interface is specifically defined for this \ntool agent, and it is not part of Shark's APIs.\nWhen performing mappings, you should set application name to be the full class \nname of the implementation class of MailMessageHandler interface.\n\nTo be able to work with our DefaultMailMessageHandler, you must define some \nproperties, and here is a section from shark's configuration file \"Shark.conf\" \nthat defines these properties:\n# the parameters for retrieving mails, possible values for protocol are \"pop3\" and \"imap\"\nDefaultMailMessageHandler.IncomingMailServer=someserver.co.yu\nDefaultMailMessageHandler.IncomingMailProtocol=pop3\nDefaultMailMessageHandler.StoreFolderName=INBOX\nDefaultMailMessageHandler.IMAPPortNo=143\nDefaultMailMessageHandler.POP3PortNo=110\n\n# the parameters for sending mails\nDefaultMailMessageHandler.SMTPMailServer=someserver.co.yu\nDefaultMailMessageHandler.SMTPPortNo=25\nDefaultMailMessageHandler.SourceAddress=shark@objectweb.org\n\n# credentials\nDefaultMailMessageHandler.Login=shark\nDefaultMailMessageHandler.Password=sharkspwd\n\nThis tool agent is able to understand the extended attributes with the following names:\n     * AppName - value of this attribute should represent the full class name of \n                 MailMessageHandler interface implementation that will handle mails\n     * AppMode - value of this attribute should represent the mode of execution, \n                 if set to 0 (zero), tool agent will send mails, and if set to 1 it \n                 will receive mails\n\n NOTE: Tool agent will read extended attributes only if they are called through\n       Default tool agent (not by shark directly) and this is the case when information \n       on which tool agent to start for XPDL application definition is not contained in mappings";
        return i;
    }
}

