/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.toolagent.ApplicationBusy;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotDefined;
import org.enhydra.shark.api.internal.toolagent.ApplicationNotStarted;
import org.enhydra.shark.api.internal.toolagent.ToolAgentGeneralException;
import org.enhydra.shark.toolagent.AbstractToolAgent;
import org.enhydra.shark.xpdl.elements.ExtendedAttribute;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JavaScriptToolAgent
extends AbstractToolAgent {
    public static final long APP_MODE_FILE = 0L;
    public static final long APP_MODE_TEXT = 1L;
    public static final String SCRIPT_EXT_ATTR_NAME = "Script";
    private String script;
    static /* synthetic */ Class class$org$enhydra$shark$toolagent$JavaScriptToolAgent;

    public void invokeApplication(SharkTransaction t, long handle, String applicationName, String procInstId, String assId, AppParameter[] parameters, Integer appMode) throws ApplicationNotStarted, ApplicationNotDefined, ApplicationBusy, ToolAgentGeneralException {
        super.invokeApplication(t, handle, applicationName, procInstId, assId, parameters, appMode);
        try {
            this.status = 0L;
            if (this.appName == null || this.appName.trim().length() == 0) {
                this.readParamsFromExtAttributes((String)parameters[0].the_value);
            }
            if (this.script == null) {
                this.script = appMode != null && (long)appMode.intValue() == 0L ? JavaScriptToolAgent.readScriptFromFile(this.appName) : this.appName;
            }
            Context cx = Context.enter();
            Scriptable scope = this.prepareContext(t, cx, parameters);
            StringReader sr = new StringReader(this.script);
            cx.evaluateReader(scope, (Reader)sr, "<script>", 1, null);
            this.prepareResult(parameters, scope);
            this.status = 4L;
        }
        catch (IOException ioe) {
            this.cus.error("JavaScriptToolAgent - application " + this.appName + " terminated incorrectly, can't find script file: " + ioe);
            throw new ApplicationNotDefined("Can't find script file " + this.appName, (Throwable)ioe);
        }
        catch (Throwable ex) {
            this.cus.error("JavaScriptToolAgent - application " + this.appName + " terminated incorrectly: " + ex);
            this.status = -1L;
            throw new ToolAgentGeneralException(ex);
        }
        finally {
            Context.exit();
        }
    }

    public String getInfo(SharkTransaction t) throws ToolAgentGeneralException {
        String i = "Executes scripts written in Java script syntax.\nIf you set application mode to 0 (zero), tool agent will search for a script \nfile given as applicationName parameter (this file has to be in the class path),\nand if it founds it, it will try to execute it. Otherwise, it will consider applicationName parameter to be the script itself, and will try to execute it.\n\nThis tool agent is able to understand the extended attributes with the following names:\n     * AppName - value of this attribute should represent the name of script file to \n                 execute (this file has to be in class path)\n     * Script - the value of this represents the script to be executed. I.e. this\n                extended attribute in XPDL can be defined as follows:\n                      <ExtendedAttribute Name=\"Script\" Value=\"c=a-b;\"/>\n           (a, b and c in above text are Formal parameter Ids from XPDL Application definition)\n\n NOTE: Tool agent will read extended attributes only if they are called through\n       Default tool agent (not by shark directly) and this is the case when information \n       on which tool agent to start for XPDL application definition is not contained in mappings";
        return i;
    }

    private Scriptable prepareContext(SharkTransaction t, Context cx, AppParameter[] context) {
        Scriptable scope = cx.initStandardObjects(null);
        if (context != null) {
            for (int i = 1; i < context.length; ++i) {
                String key = context[i].the_formal_name;
                Object value = context[i].the_value;
                if (key.equals("assId") || key.equals("procInstId") || key.equals("sharkTransaction")) {
                    this.cus.warn("Process \"" + this.procInstId + "\", activity \"" + this.assId + "\" variable conflict");
                }
                scope.put(key, scope, value);
            }
        }
        scope.put("assId", scope, (Object)this.assId);
        scope.put("procInstId", scope, (Object)this.procInstId);
        scope.put("sharkTransaction", scope, (Object)t);
        return scope;
    }

    private void prepareResult(AppParameter[] context, Scriptable scope) {
        if (context != null) {
            for (int i = 0; i < context.length; ++i) {
                if (!context[i].the_mode.equals("OUT") && !context[i].the_mode.equals("INOUT")) continue;
                Object val = scope.get(context[i].the_formal_name, scope);
                context[i].the_value = Context.toType((Object)val, (Class)context[i].the_class);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readScriptFromFile(String filename) throws IOException {
        String script = null;
        InputStreamReader rdr = null;
        InputStream in = null;
        URL url = null;
        ClassLoader cl = (class$org$enhydra$shark$toolagent$JavaScriptToolAgent == null ? (class$org$enhydra$shark$toolagent$JavaScriptToolAgent = JavaScriptToolAgent.class$("org.enhydra.shark.toolagent.JavaScriptToolAgent")) : class$org$enhydra$shark$toolagent$JavaScriptToolAgent).getClassLoader();
        url = cl.getResource(filename);
        if (url != null) {
            try {
                in = url.openStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (in != null) {
            rdr = new InputStreamReader(in);
        }
        if (rdr != null) {
            try {
                String line;
                BufferedReader brdr = new BufferedReader(rdr);
                StringBuffer sb = new StringBuffer();
                while ((line = brdr.readLine()) != null) {
                    sb.append(line);
                    sb.append('\n');
                }
                script = sb.toString();
            }
            finally {
                ((Reader)rdr).close();
            }
        }
        return script;
    }

    protected ExtendedAttributes readParamsFromExtAttributes(String extAttribs) throws Exception {
        ExtendedAttribute ea;
        ExtendedAttributes eas = super.readParamsFromExtAttributes(extAttribs);
        if ((this.appName == null || this.appName.trim().length() == 0) && (ea = eas.getFirstExtendedAttributeForName(SCRIPT_EXT_ATTR_NAME)) != null) {
            this.script = ea.getVValue();
        }
        return eas;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

