/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.toolagent;

import java.util.HashMap;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.enhydra.shark.api.RootException;
import org.enhydra.shark.api.internal.toolagent.AppParameter;
import org.enhydra.shark.api.internal.working.CallbackUtilities;
import org.enhydra.shark.toolagent.MailMessageHandler;
import org.enhydra.shark.toolagent.SmtpAuthenticator;

public class DefaultMailMessageHandler
implements MailMessageHandler {
    AppParameter[] sharkParams;
    protected static String SMTPMailServer;
    protected static String incomingMailServer;
    protected static int SMTPport;
    protected static int IMAPport;
    protected static int POP3port;
    protected static String sourceAddress;
    protected static String login;
    protected static String password;
    protected static String incomingMailProtocol;
    protected static String storeFolderName;

    public void configure(CallbackUtilities cus, AppParameter[] aps) throws RootException {
        this.sharkParams = aps;
        if (SMTPMailServer == null) {
            SMTPMailServer = cus.getProperty("DefaultMailMessageHandler.SMTPMailServer");
            incomingMailServer = cus.getProperty("DefaultMailMessageHandler.IncomingMailServer");
            try {
                SMTPport = Integer.parseInt(cus.getProperty("DefaultMailMessageHandler.SMTPPortNo"));
                IMAPport = Integer.parseInt(cus.getProperty("DefaultMailMessageHandler.IMAPPortNo"));
                POP3port = Integer.parseInt(cus.getProperty("DefaultMailMessageHandler.POP3PortNo"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            sourceAddress = cus.getProperty("DefaultMailMessageHandler.SourceAddress");
            login = cus.getProperty("DefaultMailMessageHandler.Login");
            password = cus.getProperty("DefaultMailMessageHandler.Password");
            incomingMailProtocol = cus.getProperty("DefaultMailMessageHandler.IncomingMailProtocol");
            storeFolderName = cus.getProperty("DefaultMailMessageHandler.StoreFolderName");
        }
    }

    public void sendMail() throws Exception {
        Properties props = new Properties();
        props.put("mail.smtp.host", SMTPMailServer);
        props.put("mail.smtp.port", "" + SMTPport);
        props.put("mail.smtp.user", login);
        props.put("mail.smtp.auth", "true");
        Session session = Session.getInstance((Properties)props, (Authenticator)new SmtpAuthenticator(login, password));
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(sourceAddress));
        String[] dests = this.getEMailDestinationAddresses();
        if (dests != null) {
            for (int i = 0; i < dests.length; ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(dests[i]));
            }
        }
        message.setSubject(this.composeMailMessageSubject());
        message.setContent((Object)this.composeMailMessageContent(), "text/plain");
        Transport.send((Message)message);
    }

    public String receiveMail() throws Exception {
        HashMap hashmap = new HashMap();
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props, null);
        int imPort = POP3port;
        if (!incomingMailProtocol.equals("pop3")) {
            imPort = IMAPport;
        }
        Store store = session.getStore(incomingMailProtocol);
        store.connect(incomingMailServer, imPort, login, password);
        Folder folder = null;
        Message[] messages = null;
        Message msg = null;
        folder = store.getFolder(storeFolderName);
        folder.open(2);
        messages = folder.getMessages();
        String subject = null;
        if (messages != null && messages.length > 0) {
            for (int i = 0; i < messages.length; ++i) {
                Flags flags = messages[i].getFlags();
                Flags.Flag[] flagarr = flags.getSystemFlags();
                boolean valid = true;
                System.out.println("Checking flags for mail message " + messages[i].getSubject());
                for (int j = 0; j < flagarr.length; ++j) {
                    if (!flagarr[j].equals(Flags.Flag.SEEN) && !flagarr[j].equals(Flags.Flag.ANSWERED) && !flagarr[j].equals(Flags.Flag.DELETED)) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                msg = messages[i];
                subject = msg.getSubject();
                msg.setFlag(Flags.Flag.SEEN, true);
                break;
            }
        }
        folder.close(true);
        store.close();
        if (msg != null) {
            this.setParamsBasedOnMailMessage(msg);
        } else {
            this.setParamsBasedOnMailMessage(null);
        }
        return subject;
    }

    public String composeMailMessageContent() throws Exception {
        return this.sharkParams[2].the_value.toString();
    }

    public String composeMailMessageSubject() throws Exception {
        return this.sharkParams[1].the_value.toString();
    }

    public String[] getEMailDestinationAddresses() throws Exception {
        String[] sa = new String[]{this.sharkParams[0].the_value.toString()};
        return sa;
    }

    public void setParamsBasedOnMailMessage(Message mmessage) throws Exception {
        this.sharkParams[0].the_value = mmessage != null ? mmessage.getSubject() : null;
    }
}

