/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.enhydra.shark.corba.WorkflowService.ConnectFailed;
import org.enhydra.shark.corba.WorkflowService.ExecutionAdministration;
import org.enhydra.shark.corba.WorkflowService.SharkConnection;
import org.enhydra.shark.corba.WorkflowService.SharkInterface;
import org.enhydra.shark.corba.WorkflowService.SharkInterfaceHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.WfBase.NameValue;
import org.omg.WfBase.NameValueInfo;
import org.omg.WorkflowModel.WfProcess;
import org.omg.WorkflowModel.WfProcessMgr;

public class CORBAProcStartClient {
    static final String HOST_PROPERTY_NAME = "host";
    static final String PORT_PROPERTY_NAME = "port";
    static final String ENGINENAME_PROPERTY_NAME = "enginename";
    static final String USERNAME_PROPERTY_NAME = "username";
    static final String PASSWORD_PROPERTY_NAME = "password";
    static String lastStatusString = "";
    private String confFilePath;
    private ORB orb;
    private SharkInterface shark;
    private SharkConnection sc;
    private ExecutionAdministration ea;
    private String statusString;
    private Properties props = new Properties();
    private String host;
    private String port;
    private String enginename;
    private String username;
    private String password;

    protected CORBAProcStartClient(String confFilePath) {
        this.confFilePath = confFilePath;
    }

    protected boolean init() {
        this.statusString = "";
        try {
            CORBAProcStartClient.configure(this.props, this.confFilePath);
            this.host = this.props.getProperty(HOST_PROPERTY_NAME);
            this.port = this.props.getProperty(PORT_PROPERTY_NAME);
            this.enginename = this.props.getProperty(ENGINENAME_PROPERTY_NAME);
            this.username = this.props.getProperty(USERNAME_PROPERTY_NAME);
            this.password = this.props.getProperty(PASSWORD_PROPERTY_NAME);
            String host = this.props.getProperty(HOST_PROPERTY_NAME);
            String port = this.props.getProperty(PORT_PROPERTY_NAME);
            String enginename = this.props.getProperty(ENGINENAME_PROPERTY_NAME);
            String username = this.props.getProperty(USERNAME_PROPERTY_NAME);
            String password = this.props.getProperty(PASSWORD_PROPERTY_NAME);
            if (host == null) {
                throw new Exception("host - property is not specified in configuration file");
            }
            if (port == null) {
                throw new Exception("port - property is not specified in configuration file");
            }
            if (enginename == null) {
                throw new Exception("enginename - property is not specified in configuration file");
            }
            if (username == null) {
                throw new Exception("username - property is not specified in configuration file");
            }
            if (password == null) {
                throw new Exception("password - property is not specified in configuration file");
            }
            String[] args = new String[]{"-ORBInitialHost", host, "-ORBInitialPort", port};
            this.orb = ORB.init((String[])args, null);
            Object objRef = this.orb.resolve_initial_references("NameService");
            NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
            NameComponent nc = new NameComponent(enginename, "");
            NameComponent[] path = new NameComponent[]{nc};
            this.shark = SharkInterfaceHelper.narrow((Object)ncRef.resolve(path));
            this.sc = this.shark.getSharkConnection();
            this.ea = this.shark.getExecutionAdministration();
            this.sc.connect(username, password, "", "");
            this.ea.connect(username, password, "", "");
            return true;
        }
        catch (Throwable thr) {
            this.statusString = this.host == null || this.port == null || this.enginename == null || this.username == null || this.password == null ? thr.getMessage() : (this.shark == null ? "Connection to shark server is not established - maybe the server is down, or the connection parameters are wrong!" : (thr instanceof ConnectFailed ? "Connection to shark server is not established - wrong username or password!" : thr.getMessage()));
            return false;
        }
    }

    protected boolean startProcess(String pkgId, String pDefId, Map vars) {
        this.statusString = "";
        WfProcessMgr mgr = null;
        boolean mgrOK = false;
        try {
            mgr = this.ea.getProcessMgrByXPDLDefinition(pkgId, pDefId);
            WfProcess proc = this.sc.createProcess(pkgId, pDefId);
            NameValueInfo[] cs = mgr.context_signature();
            mgrOK = true;
            if (vars != null && vars.size() > 0) {
                NameValue[] cntxt = new NameValue[vars.size()];
                Iterator it = vars.entrySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    Map.Entry me = it.next();
                    String id = (String)me.getKey();
                    java.lang.Object val = me.getValue();
                    Any any = this.orb.create_any();
                    String clsName = CORBAProcStartClient.getClassName(cs, id);
                    if (clsName == null) {
                        throw new Exception("The process definition knows nothing about variable " + id + " - you can't put it into process context");
                    }
                    if (!clsName.equals(val.getClass().getName())) {
                        throw new Exception("You are trying to set wrong type " + val.getClass().getName() + " for variable " + id + " which type is " + clsName);
                    }
                    if (val instanceof Long) {
                        any.insert_longlong(((Long)val).longValue());
                    } else if (val instanceof Double) {
                        any.insert_double(((Double)val).doubleValue());
                    } else if (val instanceof Boolean) {
                        any.insert_boolean(((Boolean)val).booleanValue());
                    } else if (val instanceof String) {
                        any.insert_wstring((String)val);
                    } else {
                        throw new Exception("Unsupported type " + val.getClass().getName() + " for variable " + id);
                    }
                    cntxt[i] = new NameValue();
                    cntxt[i].the_name = id;
                    cntxt[i].the_value = any;
                    ++i;
                }
                proc.set_process_context(cntxt);
            }
            proc.start();
            return true;
        }
        catch (Throwable thr) {
            if (!mgrOK) {
                lastStatusString = "Improper package or process definition Id!";
            } else {
                this.statusString = thr.getMessage();
                if (this.statusString == null || this.statusString.trim().equals("")) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(os);
                    thr.printStackTrace(ps);
                    ps.close();
                    this.statusString = ((java.lang.Object)os).toString();
                }
            }
            return false;
        }
    }

    public String getStatusString() {
        return this.statusString;
    }

    public static boolean run(String[] args) {
        if (args == null || args.length < 3) {
            lastStatusString = "Invalid number of parameters - must be at least 3 parameters!";
            return false;
        }
        String pkgId = args[1];
        String pDefId = args[2];
        WfProcessMgr mgr = null;
        boolean mgrOK = false;
        try {
            CORBAProcStartClient cpsc = new CORBAProcStartClient(args[0]);
            boolean isOK = cpsc.init();
            if (!isOK) {
                lastStatusString = cpsc.getStatusString();
                return false;
            }
            mgr = cpsc.ea.getProcessMgrByXPDLDefinition(pkgId, pDefId);
            NameValueInfo[] cs = mgr.context_signature();
            mgrOK = true;
            HashMap<String, java.lang.Object> cntx = new HashMap<String, java.lang.Object>();
            if (args.length > 3) {
                for (int i = 3; i < args.length; ++i) {
                    String cnt = args[i];
                    int ind = cnt.indexOf("=");
                    String id = cnt.substring(0, ind);
                    String val = cnt.substring(ind + 1, cnt.length());
                    if (CORBAProcStartClient.getClassName(cs, id).equals("java.lang.Boolean")) {
                        if (!val.equalsIgnoreCase("true") && !val.equalsIgnoreCase("false")) {
                            throw new Exception("The value for Boolean variable " + id + " is not set properly - it must be true or false");
                        }
                        cntx.put(id, new Boolean(val));
                        continue;
                    }
                    if (CORBAProcStartClient.getClassName(cs, id).equals("java.lang.Long")) {
                        cntx.put(id, new Long(val));
                        continue;
                    }
                    if (CORBAProcStartClient.getClassName(cs, id).equals("java.lang.Double")) {
                        cntx.put(id, new Double(val));
                        continue;
                    }
                    if (CORBAProcStartClient.getClassName(cs, id).equals("java.lang.String")) {
                        cntx.put(id, val);
                        continue;
                    }
                    throw new Exception("Can't init variable which type is " + CORBAProcStartClient.getClassName(cs, id).equals("java.lang.String"));
                }
            }
            if (!(isOK = cpsc.startProcess(pkgId, pDefId, cntx))) {
                lastStatusString = cpsc.getStatusString();
                return false;
            }
            return true;
        }
        catch (Throwable ex) {
            lastStatusString = !mgrOK ? "Improper package or process definition Id!" : ex.getMessage();
            return false;
        }
    }

    public static String getLastStatusString() {
        return lastStatusString;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 3) {
            CORBAProcStartClient.printUsage();
            return;
        }
        if (!CORBAProcStartClient.run(args)) {
            System.out.println("Error message: " + CORBAProcStartClient.getLastStatusString() + "\n");
            CORBAProcStartClient.printUsage();
        }
    }

    static void configure(Properties props, String filePath) throws Exception {
        if (filePath == null) {
            throw new Exception("Client need to be configured properly - given path to configuration file is null!!!");
        }
        File configFile = new File(filePath);
        if (!configFile.isAbsolute()) {
            configFile = configFile.getAbsoluteFile();
        }
        if (!configFile.exists()) {
            throw new Exception("Client need to be configured properly - configuration file " + configFile + " does not exist!!!");
        }
        FileInputStream fis = null;
        fis = new FileInputStream(configFile);
        props.load(fis);
        fis.close();
    }

    static String getClassName(NameValueInfo[] nvia, String varId) {
        if (nvia != null && nvia.length > 0) {
            for (int i = 0; i < nvia.length; ++i) {
                NameValueInfo nvi = nvia[i];
                if (!nvi.attribute_name.equals(varId)) continue;
                return nvi.type_name;
            }
        }
        return null;
    }

    static void printUsage() {
        System.err.println("This application is used to start shark's process through the CORBA.");
        System.err.println("It is supposed that CORBA server is up, and that corresponding xpdl is loaded into shark.");
        System.err.println();
        System.err.println("usage: java org.enhydra.shark.test.CORBAProcStartClient configFilePath pkgId pDefId [var1=val1 [var2=val2 ... ]]");
        System.err.println();
        System.err.println("arguments:");
        System.err.println("  configFilePath   the path to the configuration file.");
        System.err.println("  pkgId            the id of xpdl package.");
        System.err.println("  pDefId           the id of xpdl process definition.");
        System.err.println("  vari=vali        the process variable id and its value.");
        System.err.println();
        System.err.println("NOTE: the configuration file should contain name-value pairs, and following should be specified:");
        System.err.println("       - host        the name of CORBA name server host.");
        System.err.println("       - port        the port number for the CORBA name server.");
        System.err.println("       - enginename  the name of shark server instance (the one registerd with nameserver).");
        System.err.println("       - username    username credential to connect to shark server.");
        System.err.println("       - password    password credential to connect to shark server.");
        System.err.println();
        System.err.println("NOTE: variable value will be interpreted as:");
        System.err.println("       Boolean - if you enter 'true' or 'false',");
        System.err.println("       Long    - if you enter only digits,");
        System.err.println("       Double  - if you enter only digits and full-stop,");
        System.err.println("       String  - otherwise.");
    }
}

