/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.test;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.enhydra.shark.corba.WorkflowService.ConnectFailed;
import org.enhydra.shark.corba.WorkflowService.ExternalPackageInvalid;
import org.enhydra.shark.corba.WorkflowService.NotConnected;
import org.enhydra.shark.corba.WorkflowService.PackageAdministration;
import org.enhydra.shark.corba.WorkflowService.PackageInvalid;
import org.enhydra.shark.corba.WorkflowService.RepositoryMgr;
import org.enhydra.shark.corba.WorkflowService.SharkConnection;
import org.enhydra.shark.corba.WorkflowService.SharkInterface;
import org.enhydra.shark.corba.WorkflowService.SharkInterfaceHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.WfBase.BaseException;
import org.omg.WfBase.NameValue;
import org.omg.WorkflowModel.WfProcess;
import org.omg.WorkflowModel.WfResource;

public class CORBAManualTest
extends Thread {
    static final String HOST_PROPERTY_NAME = "host";
    static final String PORT_PROPERTY_NAME = "port";
    static final String ENGINENAME_PROPERTY_NAME = "enginename";
    static final String USERNAME_PROPERTY_NAME = "username";
    static final String PASSWORD_PROPERTY_NAME = "password";
    static ORB orb;
    static String host;
    static String port;
    static String enginename;
    static String username;
    static String password;
    static int counter;
    static String pkgId;
    static String pDefId;
    private static long startT;
    private static long endT;
    private static SharkInterface shark;
    static Properties props;
    private SharkConnection sc = shark.getSharkConnection();
    private WfResource res;
    private int actCompleted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CORBAManualTest() throws BaseException, ConnectFailed, NotConnected {
        this.sc.connect(username, password, "", "");
        this.res = this.sc.getResourceObject();
        this.actCompleted = 0;
        String string = password;
        synchronized (string) {
            ++counter;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        ass = null;
        block11: while (true) {
            try {
                ass = this.res.get_sequence_work_item(0);
            }
            catch (BaseException e) {
                e.printStackTrace();
                continue;
            }
            if (ass == null || ass.length <= 0) break;
            i = 0;
            while (true) {
                if (i < ass.length) ** break;
                continue block11;
                try {
                    if (!ass[i].get_accepted_status()) {
                        System.err.println("Thread " + this + " - Accepting ass [" + ass[i].activity().key() + "," + ass[i].assignee().resource_key() + "], active threads=" + Thread.activeCount());
                        ass[i].set_accepted_status(true);
                    }
                    System.err.println("Thread " + this + " - Completing ass [" + ass[i].activity().key() + "," + ass[i].assignee().resource_key() + "], active threads=" + Thread.activeCount());
                    act = ass[i].activity();
                    act.complete();
                    ++this.actCompleted;
                    this.sc.doneWith((Object)act);
                    this.sc.doneWith((Object)ass[i]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.err.println("Thread " + this + " - Problems while executing ass " + ass[i] + ", active threads=" + Thread.activeCount() + " errMsg=" + ex.getMessage());
                }
                ++i;
            }
            break;
        }
        this.sc.doneWith((Object)this.res);
        try {
            this.sc.disconnect();
            Thread.sleep(1500L);
        }
        catch (Exception var1_2) {
            // empty catch block
        }
        System.err.print("There are " + Thread.activeCount() + " active threads; this one completed " + this.actCompleted + " activities ");
        var1_1 = CORBAManualTest.password;
        synchronized (var1_1) {
            if (0 == --CORBAManualTest.counter) {
                CORBAManualTest.endT = System.currentTimeMillis();
                try {
                    ea = CORBAManualTest.shark.getExecutionAdministration();
                    ea.connect(CORBAManualTest.username, CORBAManualTest.password, "", "");
                    mgr = ea.getProcessMgrByXPDLDefinition(CORBAManualTest.pkgId, CORBAManualTest.pDefId);
                    procs = mgr.get_sequence_process(0);
                    for (i = 0; i < procs.length; ++i) {
                        System.out.println("Process " + procs[i].key() + " state is " + procs[i].state());
                        ea.doneWith((Object)procs[i]);
                    }
                    ea.doneWith((Object)mgr);
                    ea.disconnect();
                }
                catch (Exception var2_6) {
                    // empty catch block
                }
                System.out.println("The exec. lasted " + (CORBAManualTest.endT - CORBAManualTest.startT) + " ms");
                System.exit(0);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length < 3) {
            CORBAManualTest.printUsage();
            return;
        }
        try {
            CORBAManualTest.configure(args[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CORBAManualTest.printUsage();
        }
        host = props.getProperty(HOST_PROPERTY_NAME);
        port = props.getProperty(PORT_PROPERTY_NAME);
        enginename = props.getProperty(ENGINENAME_PROPERTY_NAME);
        username = props.getProperty(USERNAME_PROPERTY_NAME);
        password = props.getProperty(PASSWORD_PROPERTY_NAME);
        if (host == null || port == null || enginename == null || username == null || password == null) {
            CORBAManualTest.printUsage();
        }
        if (host == null) {
            throw new Exception("host - property is not specified in configuration file");
        }
        if (port == null) {
            throw new Exception("port - property is not specified in configuration file");
        }
        if (enginename == null) {
            throw new Exception("enginename - property is not specified in configuration file");
        }
        if (username == null) {
            throw new Exception("username - property is not specified in configuration file");
        }
        if (password == null) {
            throw new Exception("password - property is not specified in configuration file");
        }
        String xpdlName = args[1];
        String pDefId = args[2];
        int hmThreads = 1;
        if (args.length > 3) {
            hmThreads = Integer.parseInt(args[3]);
        }
        int hm = 1;
        if (args.length > 4) {
            hm = Integer.parseInt(args[4]);
        }
        HashMap<String, java.lang.Object> cntx = new HashMap<String, java.lang.Object>();
        if (args.length > 5) {
            for (int i = 5; i < args.length; ++i) {
                String cnt = args[i];
                int ind = cnt.indexOf("=");
                String id = cnt.substring(0, ind);
                String val = cnt.substring(ind + 1, cnt.length());
                try {
                    Long l = Long.valueOf(val);
                    cntx.put(id, l);
                    continue;
                }
                catch (Exception ex) {
                    cntx.put(id, val);
                }
            }
        }
        try {
            shark = CORBAManualTest.findWorkflowServer(host, port, enginename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CORBAManualTest.printUsage();
        }
        NameValue[] cntxt = new NameValue[cntx.size()];
        Iterator it = cntx.entrySet().iterator();
        int j = 0;
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String id = (String)me.getKey();
            java.lang.Object val = me.getValue();
            Any any = orb.create_any();
            if (val instanceof Long) {
                any.insert_longlong(((Long)val).longValue());
            } else {
                any.insert_wstring((String)val);
            }
            cntxt[j] = new NameValue();
            cntxt[j].the_name = id;
            cntxt[j].the_value = any;
            ++j;
        }
        PackageAdministration pa = shark.getPackageAdministration();
        RepositoryMgr rm = shark.getRepositoryManager();
        String pkgId = null;
        try {
            int i;
            pa.connect(username, password, "", "");
            rm.connect(username, password, "", "");
            pkgId = rm.getPackageId(xpdlName);
            if (!pa.isPackageOpened(pkgId)) {
                pa.openPkg(xpdlName);
            }
            rm.disconnect();
            pa.disconnect();
            SharkConnection sc = shark.getSharkConnection();
            sc.connect(username, password, "", "");
            startT = System.currentTimeMillis();
            for (i = 0; i < hm; ++i) {
                WfProcess proc = sc.createProcess(pkgId, pDefId);
                proc.set_process_context(cntxt);
                proc.start();
                sc.doneWith((Object)proc);
            }
            sc.disconnect();
            CORBAManualTest.pkgId = pkgId;
            CORBAManualTest.pDefId = pDefId;
            for (i = 0; i < hmThreads; ++i) {
                new CORBAManualTest();
            }
        }
        catch (Throwable ex) {
            if (ex instanceof PackageInvalid) {
                System.out.println("PIERRS=" + ((PackageInvalid)ex).XPDLValidationErrors);
            }
            if (ex instanceof ExternalPackageInvalid) {
                System.out.println("PIERRS=" + ((ExternalPackageInvalid)ex).XPDLValidationErrors);
            }
            ex.printStackTrace();
            CORBAManualTest.printUsage();
        }
    }

    static void configure(String filePath) throws Exception {
        if (filePath == null) {
            throw new Exception("Client need to be configured properly - given path to configuration file is null!!!");
        }
        File configFile = new File(filePath);
        if (!configFile.isAbsolute()) {
            configFile = configFile.getAbsoluteFile();
        }
        if (!configFile.exists()) {
            throw new Exception("Client need to be configured properly - configuration file " + configFile + " does not exist!!!");
        }
        FileInputStream fis = null;
        fis = new FileInputStream(configFile);
        props.load(fis);
        fis.close();
    }

    public static SharkInterface findWorkflowServer(String host, String port, String workflowServerName) throws Exception {
        String[] args = new String[]{"-ORBInitialHost", host, "-ORBInitialPort", port};
        orb = ORB.init((String[])args, null);
        Object objRef = orb.resolve_initial_references("NameService");
        NamingContext ncRef = NamingContextHelper.narrow((Object)objRef);
        NameComponent nc = new NameComponent(workflowServerName, "");
        NameComponent[] path = new NameComponent[]{nc};
        return SharkInterfaceHelper.narrow((Object)ncRef.resolve(path));
    }

    static void printUsage() {
        System.err.println("This application is used to start and execute shark's processes that contain at least one manual activity through the CORBA, until all of them are finished.");
        System.err.println("It is supposed that CORBA server is up.");
        System.err.println();
        System.err.println("usage: java CORBAManualTest configFilePath xpdlName pDefId [noOfThreads [noOfProcToStart [var1=val1 [var2=val2 ... ]]]]");
        System.err.println();
        System.err.println("arguments:");
        System.err.println("  configFilePath   the path to the configuration file.");
        System.err.println("  xpdlName         the path to XPDL file where process definition for the process one want to start can be found.");
        System.err.println("                   This path has to be relative to shark's external repository folder.");
        System.err.println("  pDefId           the id of xpdl process definition.");
        System.err.println("  noOfThreads      the number of threads that will fight to execute activities (default is 1).");
        System.err.println("  noOfProcToStart  the number of processes that will be started (default is 1).");
        System.err.println("  vari=vali        the process variable id and its value.");
        System.err.println();
        System.err.println("NOTE: the configuration file should contain name-value pairs, and following should be specified:");
        System.err.println("       - host        the name of CORBA name server host.");
        System.err.println("       - port        the port number for the CORBA name server.");
        System.err.println("       - enginename  the name of shark server instance (the one registerd with nameserver).");
        System.err.println("       - username    username credential to connect to shark server.");
        System.err.println("       - password    password credential to connect to shark server.");
        System.err.println();
        System.err.println("NOTE: variable value will be interpreted as:");
        System.err.println("       Boolean - if you enter 'true' or 'false',");
        System.err.println("       Long    - if you enter only digits,");
        System.err.println("       Double  - if you enter only digits and full-stop,");
        System.err.println("       String  - otherwise.");
    }

    static {
        counter = 0;
        props = new Properties();
    }
}

