/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.shark.swingclient.worklist.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JOptionPane;
import org.enhydra.shark.api.client.wfmodel.CannotComplete;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.swingclient.ActionBase;
import org.enhydra.shark.swingclient.ResourceManager;
import org.enhydra.shark.swingclient.SharkClient;
import org.enhydra.shark.swingclient.UpdateVariables;
import org.enhydra.shark.swingclient.WorkflowUtilities;
import org.enhydra.shark.swingclient.worklist.Worklist;

public class CompleteWorkitem
extends ActionBase {
    public CompleteWorkitem(Worklist worklist) {
        super(worklist);
    }

    public void actionPerformed(ActionEvent e) {
        Worklist worklist = (Worklist)this.actionPanel;
        WfAssignment ass = worklist.getSelectedAssignment();
        if (ass != null) {
            try {
                int updateVar;
                Map actContext;
                boolean accepted = ass.get_accepted_status();
                if (!accepted) {
                    JOptionPane.showMessageDialog(this.actionPanel.getWindow(), ResourceManager.getLanguageDependentString("WarningTheWorkitemMustBeAcceptedBeforeExecution"), SharkClient.getAppTitle(), 2);
                    return;
                }
                WfActivity wa = ass.activity();
                String waKey = wa.key();
                if (!worklist.isWorkitemContextUpdated(waKey) && (actContext = WorkflowUtilities.getActivityContext(wa.process_context(), wa, "VariableToProcess_ALL")) != null && actContext.size() > 0 && (updateVar = JOptionPane.showConfirmDialog(worklist.getWindow(), ResourceManager.getLanguageDependentString("MessageDoYouWantToUpdateProcessVariables"), ResourceManager.getLanguageDependentString("WorkitemKey") + " - " + wa.name(), 0, 3)) == 0) {
                    Window w = worklist.getWindow();
                    Map readOnlyContext = WorkflowUtilities.getActivityContext(actContext, wa, "VariableToProcess_VIEW");
                    UpdateVariables upvd = new UpdateVariables(w, ResourceManager.getLanguageDependentString("DialogUpdateProcessVariables"), wa.container().key(), actContext, readOnlyContext);
                    upvd.showDialog();
                    if (actContext != null) {
                        worklist.putWorkitemContext(waKey, actContext);
                    }
                }
                if (worklist.isWorkitemContextUpdated(waKey)) {
                    actContext = worklist.getWorkitemContext(waKey);
                    Map updContext = WorkflowUtilities.getActivityContext(actContext, wa, "VariableToProcess_UPDATE");
                    wa.set_result(updContext);
                }
                wa.complete();
                worklist.refresh();
            }
            catch (CannotComplete cnc) {
                JOptionPane.showMessageDialog(worklist.getWindow(), ResourceManager.getLanguageDependentString("WarningTheWorkitemCannotBeCompleted"), SharkClient.getAppTitle(), 2);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

